/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.persistence.services.StateServices;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMap;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.springframework.util.StringUtils;

public class ServicesRegistry {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)ServicesRegistry.class.getName());
    private static ServicesRegistry instance = new ServicesRegistry();
    private ServicesRegistryMap map = new ServicesRegistryMap();
    private AtomicBoolean inProgress = new AtomicBoolean(false);

    public static ServicesRegistry getInstance() {
        return instance;
    }

    private ServicesRegistry() {
        this.refreshCache();
    }

    public void update() {
        String location = "update";
        DuccId jobid = null;
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                this.refreshCache();
                logger.debug(location, jobid, new Object[]{"size:" + this.map.size()});
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        } else {
            logger.warn(location, jobid, new Object[]{"skipping: already in progress..."});
        }
        this.inProgress.set(false);
    }

    public void refreshCache() {
        try {
            ServicesRegistryMap mapRevised = new ServicesRegistryMap();
            StateServices iss = StateServices.getInstance();
            StateServicesDirectory ssd = iss.getStateServicesDirectory();
            if (!ssd.getDescendingKeySet().isEmpty()) {
                for (Integer key : ssd.getDescendingKeySet()) {
                    StateServicesSet entry = ssd.get(key);
                    Properties propertiesSvc = entry.get("svc");
                    Properties propertiesMeta = entry.get("meta");
                    ServicesRegistryMapPayload value = new ServicesRegistryMapPayload(propertiesSvc, propertiesMeta);
                    mapRevised.put(key, value);
                }
            }
            this.map = mapRevised;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ServicesRegistryMap getMap() {
        return this.map;
    }

    public ServicesRegistryMap getCurrentMap() {
        this.refreshCache();
        return this.map;
    }

    public String[] getList(String string) {
        String[] retVal = new String[]{};
        if (string != null && (string = string.trim()).length() > 0) {
            retVal = StringUtils.delimitedListToStringArray((String)string, (String)" ");
        }
        return retVal;
    }

    public ArrayList<String> getArrayList(String list) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (String string : this.getList(list)) {
            retVal.add(string);
        }
        return retVal;
    }

    public ServicesRegistryMapPayload findService(String name) {
        ServicesRegistryMapPayload retVal = null;
        try {
            for (Integer key : this.map.keySet()) {
                String endpoint;
                ServicesRegistryMapPayload payload = (ServicesRegistryMapPayload)this.map.get(key);
                Properties meta = payload.meta;
                if (meta == null || !meta.containsKey("endpoint") || !name.equals(endpoint = meta.getProperty("endpoint"))) continue;
                retVal = payload;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String findServiceUser(String id) {
        String retVal = null;
        try {
            for (Integer key : this.map.keySet()) {
                String sid;
                ServicesRegistryMapPayload payload = (ServicesRegistryMapPayload)this.map.get(key);
                Properties meta = payload.meta;
                if (meta == null || !meta.containsKey("numeric_id") || !id.equals(sid = meta.getProperty("numeric_id"))) continue;
                retVal = meta.getProperty("user").trim();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String findServiceName(DuccId duccId) {
        String retVal = null;
        try {
            long id = duccId.getFriendly();
            block2: for (Integer key : this.map.keySet()) {
                String[] list;
                ServicesRegistryMapPayload payload = (ServicesRegistryMapPayload)this.map.get(key);
                Properties meta = payload.meta;
                if (meta == null) continue;
                String implementors = meta.getProperty("implementors");
                for (String member : list = this.getList(implementors)) {
                    if (!member.equals(id + "")) continue;
                    if (!meta.containsKey("endpoint")) continue block2;
                    retVal = meta.getProperty("endpoint");
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public String getServiceState(String name) {
        String retVal = "NotKnown";
        try {
            String service_healthy;
            String ping_active;
            ServicesRegistryMapPayload payload = this.findService(name);
            Properties properties = payload.meta;
            String service_state = properties.getProperty("service-state").trim();
            retVal = service_state.equalsIgnoreCase("Available") ? ((ping_active = properties.getProperty("ping-active").trim()).equalsIgnoreCase("true") ? ((service_healthy = properties.getProperty("service-healthy").trim()).equalsIgnoreCase("true") ? "OK" : "NotHealthy") : "NotPinging") : "NotAvailable";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }
}

