/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.CasHelper;
import org.apache.uima.ducc.user.common.DuccUimaSerializer;
import org.apache.uima.ducc.user.common.QuotedOptions;
import org.apache.uima.ducc.user.dgen.iface.DeployableGeneration;
import org.apache.uima.ducc.user.jp.iface.IProcessContainer;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class DuccAbstractProcessContainer
implements IProcessContainer {
    protected AnalysisEngineMetaData analysisEngineMetadata;
    protected Map<Long, Throwable> errorMap = new HashMap<Long, Throwable>();
    protected int scaleout = 1;
    protected static Map<Long, DuccUimaSerializer> serializerMap = new HashMap<Long, DuccUimaSerializer>();
    protected final boolean debug = System.getProperty("ducc.debug") != null;
    private Logger logger = UIMAFramework.getLogger(DuccAbstractProcessContainer.class);
    private boolean dump = false;

    protected abstract void doDeploy() throws Exception;

    protected abstract int doInitialize(Properties var1, String[] var2) throws Exception;

    protected abstract void doStop() throws Exception;

    protected abstract List<Properties> doProcess(Object var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKey(String xmi) throws Exception {
        if (this.analysisEngineMetadata == null) {
            return null;
        }
        Properties props = new Properties();
        props.setProperty("cas_initial_heap_size", "1000");
        TypeSystemDescription tsd = this.analysisEngineMetadata.getTypeSystem();
        TypePriorities tp = this.analysisEngineMetadata.getTypePriorities();
        FsIndexDescription[] fsid = this.analysisEngineMetadata.getFsIndexes();
        Class<CasCreationUtils> clazz = CasCreationUtils.class;
        synchronized (CasCreationUtils.class) {
            CAS cas = CasCreationUtils.createCas((TypeSystemDescription)tsd, (TypePriorities)tp, (FsIndexDescription[])fsid, (Properties)props);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            this.getUimaSerializer().deserializeCasFromXmi(xmi, cas);
            String key = CasHelper.getId(cas);
            cas.release();
            return key;
        }
    }

    @Override
    public int getScaleout() {
        return this.scaleout;
    }

    protected DuccUimaSerializer getUimaSerializer() {
        return serializerMap.get(Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initialize(Properties p, String[] arg) throws Exception {
        this.logger.log(Level.INFO, "DuccAbstractProcessContainer.initialize() >>>>>>>>> Initializing User Container");
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            int n = this.doInitialize(p, arg);
            return n;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            this.logger.log(Level.INFO, "DuccAbstractProcessContainer.initialize() <<<<<<<< User Container initialized");
        }
    }

    @Override
    public void deploy() throws Exception {
        this.logger.log(Level.INFO, "DuccAbstractProcessContainer.deploy() >>>>>>>>> Deploying User Container");
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.doDeploy();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            serializerMap.put(Thread.currentThread().getId(), new DuccUimaSerializer());
            this.logger.log(Level.INFO, "DuccAbstractProcessContainer.deploy() <<<<<<<< User Container deployed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Properties> process(Object xmi) throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "DuccAbstractProcessContainer.process() >>>>>>>>> Processing User Container");
        }
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.errorMap.remove(Thread.currentThread().getId());
        try {
            List<Properties> list = this.doProcess(xmi);
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "DuccAbstractProcessContainer.process() <<<<<<<< User Container processed");
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "DuccAbstractProcessContainer.stop() >>>>>>>>> Stopping User Container");
        }
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.doStop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "DuccAbstractProcessContainer.stop() <<<<<<<< User Container stopped");
            }
        }
    }

    protected String serializeAsString(Throwable t) throws Exception {
        StringWriter sw = new StringWriter();
        String serializedCause = "";
        try {
            t.printStackTrace(new PrintWriter(sw));
            serializedCause = sw.toString();
        }
        catch (Throwable e) {
            try {
                this.logger.log(Level.WARNING, "Unable to Stringfiy " + t.getClass().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializedCause = "Unable to Stringifiy Exception " + t.getClass().getName() + " - Please Check JP Log File For More Details";
        }
        return serializedCause;
    }

    protected byte[] serialize(Throwable t) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(t);
        }
        return baos.toByteArray();
    }

    public byte[] getLastSerializedError() throws Exception {
        byte[] result = null;
        if (this.errorMap.containsKey(Thread.currentThread().getId())) {
            Throwable lastError = this.errorMap.get(Thread.currentThread().getId());
            if (System.getProperty("SendExceptionAsString") != null) {
                result = this.serialize(new RuntimeException(this.serializeAsString(lastError)));
            } else {
                try {
                    result = this.serialize(lastError);
                }
                catch (Exception e) {
                    result = this.serialize(new RuntimeException(this.serializeAsString(lastError)));
                }
            }
        } else {
            result = this.serialize(new RuntimeException("AE.process( )failed - check service log"));
        }
        return result;
    }

    private Socket connectWithAgent() throws Exception {
        InetAddress host = null;
        int statusUpdatePort = -1;
        host = InetAddress.getLocalHost();
        String port = System.getenv("DUCC_STATE_UPDATE_PORT");
        if (port != null) {
            try {
                statusUpdatePort = Integer.valueOf(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.logger.log(Level.INFO, "Service Connecting Socket to Host:" + host.getHostName() + " Port:" + statusUpdatePort);
        String localhost = null;
        return new Socket(localhost, statusUpdatePort);
    }

    protected void sendStateUpdate(String state) throws Exception {
        FilterOutputStream out = null;
        Socket socket = null;
        if (System.getenv("DUCC_STATE_UPDATE_PORT") == null) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("DUCC_PROCESS_UNIQUEID=").append(System.getenv("DUCC_PROCESS_UNIQUEID")).append(",");
            sb.append("DUCC_PROCESS_STATE=").append(state);
            socket = this.connectWithAgent();
            out = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)out).writeUTF(sb.toString());
            ((DataOutputStream)out).flush();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Sent new State:" + state);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }

    private void dumpSystemProperties() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "===== <System Properties> =====");
            Properties props = System.getProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                System.out.println(key + "=" + value);
            }
            this.logger.log(Level.FINE, "===== </System Properties> =====");
        }
    }

    private String getPropertyString(String key) {
        String value = System.getProperty(key);
        return value;
    }

    private List<String> getPropertyListString(String key) {
        String input = System.getProperty(key);
        return QuotedOptions.tokenizeList(input, true);
    }

    private Integer getPropertyInteger(String key) {
        String sval = this.getPropertyString(key);
        Integer value = new Integer(sval);
        return value;
    }

    protected String buildDeployable() {
        try {
            this.dumpSystemProperties();
            String directory = this.getPropertyString("ducc.deploy.JobDirectory");
            String id = this.getPropertyString("ducc.job.id");
            Integer dgenThreadCount = this.getPropertyInteger("ducc.deploy.JpThreadCount");
            String dgenFlowController = this.getPropertyString("ducc.deploy.JpFlowController");
            String jpType = this.getPropertyString("ducc.deploy.JpType");
            if (jpType == null) {
                jpType = "uima";
            }
            if (!jpType.equalsIgnoreCase("uima-as")) {
                String cmDescriptor = this.getPropertyString("ducc.deploy.JpCmDescriptor");
                List<String> cmOverrides = this.getPropertyListString("ducc.deploy.JpCmOverrides");
                String aeDescriptor = this.getPropertyString("ducc.deploy.JpAeDescriptor");
                List<String> aeOverrides = this.getPropertyListString("ducc.deploy.JpAeOverrides");
                String ccDescriptor = this.getPropertyString("ducc.deploy.JpCcDescriptor");
                List<String> ccOverrides = this.getPropertyListString("ducc.deploy.JpCcOverrides");
                DeployableGeneration dg = new DeployableGeneration();
                String name = dg.generate(directory, id, dgenThreadCount, dgenFlowController, cmDescriptor, cmOverrides, aeDescriptor, aeOverrides, ccDescriptor, ccOverrides, true);
                return name;
            }
            this.logger.log(Level.WARNING, "ERROR - should not be called for type=" + jpType);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.WARNING, "buildDeployable", (Throwable)e);
        }
        return null;
    }
}

