/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.dgen.iface;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.user.dgen.DeployableGenerator;
import org.apache.uima.ducc.user.dgen.DuccUimaAggregate;
import org.apache.uima.ducc.user.dgen.DuccUimaAggregateComponent;
import org.apache.uima.ducc.user.dgen.DuccUimaReferenceByName;
import org.apache.uima.ducc.user.dgen.IDuccGeneratorUimaAggregateComponent;
import org.apache.uima.ducc.user.dgen.iface.IDeployableGeneration;

public class DeployableGeneration
implements IDeployableGeneration {
    private void conditionalAddComponent(ArrayList<IDuccGeneratorUimaAggregateComponent> dgenComponents, String descriptor, List<String> overrides) {
        if (descriptor != null) {
            DuccUimaAggregateComponent dgenComponent = new DuccUimaAggregateComponent(descriptor, overrides);
            dgenComponents.add(dgenComponent);
        }
    }

    private void show(String text) {
        System.out.println(text);
    }

    private void show(String name, String value) {
        this.show(name + "=" + value);
    }

    private void show(String name, List<String> value) {
        if (value == null) {
            this.show(name + "=" + value);
        } else {
            this.show(name + "=" + value.toString());
        }
    }

    private String fabricateTargetDirectoryName(String baseDir, String jobId) {
        StringBuffer sb = new StringBuffer();
        if (baseDir != null) {
            sb.append(baseDir);
            if (!baseDir.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            if (jobId != null) {
                sb.append(jobId);
            }
        }
        return sb.toString();
    }

    @Override
    public String generate(String directory, String id, String dgenName, String dgenDescription, Integer dgenThreadCount, String dgenBrokerURL, String dgenEndpoint, String dgenFlowController, String cmDescriptor, List<String> cmOverrides, String aeDescriptor, List<String> aeOverrides, String ccDescriptor, List<String> ccOverrides) throws Exception {
        String retVal = null;
        try {
            this.show("directory", directory);
            this.show("id", id);
            this.show("dgenName", dgenName);
            this.show("dgenDescription", dgenDescription);
            this.show("dgenThreadCount", dgenThreadCount.toString());
            this.show("dgenBrokerURL", dgenBrokerURL);
            this.show("dgenEndpoint", dgenEndpoint);
            this.show("dgenFlowController", dgenFlowController);
            this.show("cmDescriptor", cmDescriptor);
            this.show("cmOverrides", cmOverrides);
            this.show("aeDescriptor", aeDescriptor);
            this.show("aeOverrides", aeOverrides);
            this.show("ccDescriptor", ccDescriptor);
            this.show("ccOverrides", ccOverrides);
            String targetDirectory = this.fabricateTargetDirectoryName(directory, id);
            DeployableGenerator deployableGenerator = new DeployableGenerator(targetDirectory);
            ArrayList<IDuccGeneratorUimaAggregateComponent> dgenComponents = new ArrayList<IDuccGeneratorUimaAggregateComponent>();
            this.conditionalAddComponent(dgenComponents, cmDescriptor, cmOverrides);
            this.conditionalAddComponent(dgenComponents, aeDescriptor, aeOverrides);
            this.conditionalAddComponent(dgenComponents, ccDescriptor, ccOverrides);
            DuccUimaAggregate configuration = new DuccUimaAggregate(dgenName, dgenDescription, dgenThreadCount, dgenBrokerURL, dgenEndpoint, dgenFlowController, dgenComponents);
            retVal = deployableGenerator.generate(configuration, id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.toString());
        }
        return retVal;
    }

    @Override
    public String generate(String directory, String id, String dgenName, String dgenDescription, Integer dgenThreadCount, String dgenBrokerURL, String dgenEndpoint, String dgenFlowController, String dgenReferenceByName) throws Exception {
        String retVal = null;
        try {
            this.show("directory", directory);
            this.show("id", id);
            this.show("dgenName", dgenName);
            this.show("dgenDescription", dgenDescription);
            this.show("dgenThreadCount", dgenThreadCount.toString());
            this.show("dgenBrokerURL", dgenBrokerURL);
            this.show("dgenEndpoint", dgenEndpoint);
            this.show("dgenFlowController", dgenFlowController);
            this.show("dgenReferenceByName", dgenReferenceByName);
            String targetDirectory = this.fabricateTargetDirectoryName(directory, id);
            DeployableGenerator deployableGenerator = new DeployableGenerator(targetDirectory);
            DuccUimaReferenceByName configuration = new DuccUimaReferenceByName(dgenName, dgenDescription, dgenThreadCount, dgenBrokerURL, dgenEndpoint, dgenFlowController, dgenReferenceByName);
            retVal = deployableGenerator.generate(configuration, id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.toString());
        }
        return retVal;
    }
}

