/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jp;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.user.common.UimaUtils;
import org.apache.uima.ducc.user.jp.ArgsParser;
import org.apache.uima.ducc.user.jp.DuccAbstractProcessContainer;
import org.apache.uima.ducc.user.jp.uima.UimaAnalysisEngineInstancePoolWithThreadAffinity;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class UimaProcessContainer
extends DuccAbstractProcessContainer {
    public static final String IMPORT_BY_NAME_PREFIX = "*importByName:";
    private static ResourceManager rm = null;
    Semaphore sharedInitSemaphore = new Semaphore(1);
    UimaAnalysisEngineInstancePoolWithThreadAffinity instanceMap = new UimaAnalysisEngineInstancePoolWithThreadAffinity();
    private static CasPool casPool = null;
    AtomicInteger counter = new AtomicInteger();
    private String analysisEngineDescriptor = null;
    private static CountDownLatch latch = new CountDownLatch(1);
    private static Object platformMBeanServer;
    private volatile boolean threadAffinity = true;

    @Override
    public boolean useThreadAffinity() {
        return this.threadAffinity;
    }

    private int configureAndGetScaleout(String[] args) throws Exception {
        this.analysisEngineDescriptor = ArgsParser.getArg("-aed", args);
        this.scaleout = Integer.valueOf(ArgsParser.getArg("-t", args));
        String jobType = System.getProperty("ducc.deploy.JpType");
        if ("uima".equals(jobType)) {
            System.out.println("UIMA Version:" + UimaVersion.getFullVersionString());
        }
        return this.scaleout;
    }

    public byte[] getLastSerializedError() throws Exception {
        if (this.lastError != null) {
            return this.serialize(this.lastError);
        }
        return null;
    }

    @Override
    public int doInitialize(Properties props, String[] args) throws Exception {
        return this.configureAndGetScaleout(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeploy() throws Exception {
        System.out.println("....... UimaProcessContainer.doDeploy()");
        ResourceSpecifier rSpecifier = null;
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        Class<UimaProcessContainer> clazz = UimaProcessContainer.class;
        synchronized (UimaProcessContainer.class) {
            block11: {
                if (rm == null) {
                    rm = UIMAFramework.newDefaultResourceManager();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                paramsMap.put("RESOURCE_MANAGER", rm);
                paramsMap.put("MBEAN_SERVER", platformMBeanServer);
                try {
                    this.sharedInitSemaphore.acquire();
                    rSpecifier = UimaUtils.getResourceSpecifier(this.analysisEngineDescriptor);
                    AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)rSpecifier, paramsMap);
                    this.instanceMap.checkin(ae);
                    if (this.instanceMap.size() != this.scaleout) break block11;
                    try {
                        Properties props = new Properties();
                        props.setProperty("cas_initial_heap_size", "1000");
                        this.analysisEngineMetadata = ae.getAnalysisEngineMetaData();
                        casPool = new CasPool(this.scaleout, (ProcessingResourceMetaData)this.analysisEngineMetadata, rm);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        throw new ResourceInitializationException((Throwable)e);
                    }
                }
                catch (Throwable e) {
                    latch.countDown();
                    Logger logger = UIMAFramework.getLogger();
                    logger.log(Level.WARNING, "UimaProcessContainer", e);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    this.sharedInitSemaphore.release();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        try {
            AnalysisEngine ae = this.instanceMap.checkout();
            if (ae != null) {
                ae.destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Properties> doProcess(Object xmi) throws Exception {
        ArrayList<Properties> arrayList;
        CAS cas;
        block8: {
            AnalysisEngine ae = null;
            latch.await();
            cas = casPool.getCas();
            try {
                this.lastError = null;
                this.getUimaSerializer().deserializeCasFromXmi((String)xmi, cas);
                ae = this.instanceMap.checkout();
                List<AnalysisEnginePerformanceMetrics> beforeAnalysis = this.getMetrics(ae);
                ae.process(cas);
                List<AnalysisEnginePerformanceMetrics> afterAnalysis = this.getMetrics(ae);
                List<AnalysisEnginePerformanceMetrics> casMetrics = this.getAEMetricsForCAS(afterAnalysis, beforeAnalysis);
                ArrayList<Properties> metricsList = new ArrayList<Properties>();
                for (AnalysisEnginePerformanceMetrics metrics : casMetrics) {
                    Properties p = new Properties();
                    p.setProperty("name", metrics.getName());
                    p.setProperty("uniqueName", metrics.getUniqueName());
                    p.setProperty("analysisTime", String.valueOf(metrics.getAnalysisTime()));
                    p.setProperty("numProcessed", String.valueOf(metrics.getNumProcessed()));
                    metricsList.add(p);
                }
                arrayList = metricsList;
                if (ae == null) break block8;
            }
            catch (Throwable e) {
                try {
                    this.lastError = e;
                    Logger logger = UIMAFramework.getLogger();
                    logger.log(Level.WARNING, "UimaProcessContainer", e);
                    e.printStackTrace();
                    throw new AnalysisEngineProcessException();
                }
                catch (Throwable throwable) {
                    if (ae != null) {
                        this.instanceMap.checkin(ae);
                    }
                    if (cas != null) {
                        casPool.releaseCas(cas);
                    }
                    throw throwable;
                }
            }
            this.instanceMap.checkin(ae);
        }
        if (cas != null) {
            casPool.releaseCas(cas);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnalysisEnginePerformanceMetrics> getMetrics(AnalysisEngine ae) throws Exception {
        ArrayList<AnalysisEnginePerformanceMetrics> analysisManagementObjects = new ArrayList<AnalysisEnginePerformanceMetrics>();
        Class<UimaProcessContainer> clazz = UimaProcessContainer.class;
        synchronized (UimaProcessContainer.class) {
            AnalysisEngineManagement aem = ae.getManagementInterface();
            if (aem.getComponents().size() > 0) {
                this.getLeafManagementObjects(aem, analysisManagementObjects);
            } else {
                String path = this.produceUniqueName(aem);
                analysisManagementObjects.add(this.deepCopyMetrics(aem, path));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return analysisManagementObjects;
        }
    }

    private void getLeafManagementObjects(AnalysisEngineManagement aem, List<AnalysisEnginePerformanceMetrics> result) {
        this.getLeafManagementObjects(aem, result, "");
    }

    private void getLeafManagementObjects(AnalysisEngineManagement aem, List<AnalysisEnginePerformanceMetrics> result, String uimaFullyQualifiedAEContext) {
        if (aem.getComponents().isEmpty()) {
            if (!aem.getName().equals("Fixed Flow Controller")) {
                if (aem.getUniqueMBeanName().indexOf("p0=") > -1) {
                    int p1indx = aem.getUniqueMBeanName().indexOf("p1=");
                    if (p1indx > -1) {
                        String[] parts;
                        String tmp = aem.getUniqueMBeanName().substring(p1indx);
                        for (String part : parts = tmp.split(",")) {
                            if (!part.startsWith("name=")) continue;
                            uimaFullyQualifiedAEContext = uimaFullyQualifiedAEContext + "/" + part.substring(5);
                            break;
                        }
                    } else {
                        uimaFullyQualifiedAEContext = "";
                    }
                }
                result.add(this.deepCopyMetrics(aem, uimaFullyQualifiedAEContext));
            }
        } else {
            for (AnalysisEngineManagement child : aem.getComponents().values()) {
                this.getLeafManagementObjects(child, result, this.produceUniqueName(aem));
            }
        }
    }

    private String produceUniqueName(AnalysisEngineManagement aem) {
        String[] parts = aem.getUniqueMBeanName().split(",");
        StringBuffer sb = new StringBuffer();
        for (String part : parts) {
            int pos = part.indexOf("=");
            if (pos > -1 && part.startsWith("p")) {
                String indx;
                String n = part.substring(pos + 1, part.indexOf(" Components"));
                if (part.startsWith("p0=") && n.indexOf(" ") > -1 && (indx = n.substring(n.lastIndexOf(" "))) != null) {
                    int instanceNumber = -1;
                    try {
                        instanceNumber = Integer.parseInt(indx.trim());
                        sb.append(instanceNumber).append(" Components ");
                        n = n.substring(0, n.lastIndexOf(" "));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                sb.append("/").append(n.trim());
                continue;
            }
            if (!part.trim().startsWith("name=") && !part.trim().startsWith("org.apache.uima:name=")) continue;
            sb.append("/").append(part.substring(part.trim().indexOf("=") + 1));
        }
        return sb.toString();
    }

    private AnalysisEnginePerformanceMetrics deepCopyMetrics(AnalysisEngineManagement aem, String uimaFullyQualifiedAEContext) {
        String index = "";
        int pos = aem.getUniqueMBeanName().lastIndexOf("name=");
        if (pos > -1) {
            String tmp = aem.getUniqueMBeanName().substring(pos + 5);
            int last = tmp.lastIndexOf(" ");
            index = last == -1 ? "1" : tmp.substring(last).trim();
            if (uimaFullyQualifiedAEContext.trim().length() > 0 && last > -1) {
                try {
                    Integer.parseInt(index);
                    uimaFullyQualifiedAEContext = uimaFullyQualifiedAEContext.substring(0, last + 1);
                }
                catch (NumberFormatException nfe) {
                }
                catch (Exception e) {}
            } else if (!uimaFullyQualifiedAEContext.endsWith(tmp)) {
                uimaFullyQualifiedAEContext = uimaFullyQualifiedAEContext + "/" + tmp;
            }
        }
        return new AnalysisEnginePerformanceMetrics(aem.getName(), uimaFullyQualifiedAEContext, aem.getAnalysisTime(), aem.getNumberOfCASesProcessed());
    }

    private List<AnalysisEnginePerformanceMetrics> getAEMetricsForCAS(List<AnalysisEnginePerformanceMetrics> afterAnalysisManagementObjects, List<AnalysisEnginePerformanceMetrics> beforeAnalysisManagementObjects) throws Exception {
        ArrayList<AnalysisEnginePerformanceMetrics> performanceList = new ArrayList<AnalysisEnginePerformanceMetrics>();
        block0: for (AnalysisEnginePerformanceMetrics after : afterAnalysisManagementObjects) {
            for (AnalysisEnginePerformanceMetrics before : beforeAnalysisManagementObjects) {
                String uniqueName = after.getUniqueName();
                if (!before.getUniqueName().equals(after.getUniqueName())) continue;
                if (after.getAnalysisTime() - before.getAnalysisTime() < 0L) {
                    Logger logger = UIMAFramework.getLogger();
                    logger.log(Level.WARNING, "Thread:" + Thread.currentThread() + " UimaProcessContainer.getAEMetricsForCAS() - Unexpected negative result for analysis time:" + (after.analysisTime - before.analysisTime) + " Component:" + uniqueName + " before=" + before.analysisTime + " after=" + after.analysisTime);
                }
                AnalysisEnginePerformanceMetrics metrics = new AnalysisEnginePerformanceMetrics(after.getName(), uniqueName, after.getAnalysisTime() - before.getAnalysisTime(), after.getNumProcessed());
                performanceList.add(metrics);
                continue block0;
            }
        }
        return performanceList;
    }

    static {
        try {
            Class<?> managementFactory = Class.forName("java.lang.management.ManagementFactory");
            Method getPlatformMBeanServer = managementFactory.getMethod("getPlatformMBeanServer", new Class[0]);
            platformMBeanServer = getPlatformMBeanServer.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            platformMBeanServer = null;
        }
    }

    private static class AnalysisEnginePerformanceMetrics {
        private String name;
        private String uniqueName;
        private long analysisTime;
        private long numProcessed;

        public AnalysisEnginePerformanceMetrics(String name, String uimaContextPath, long analysisTime, long numProcessed) {
            this.name = name;
            this.uniqueName = uimaContextPath;
            this.analysisTime = analysisTime;
            this.numProcessed = numProcessed;
        }

        public String getName() {
            return this.name;
        }

        public String getUniqueName() {
            if (this.uniqueName != null && this.uniqueName.trim().length() > 0 && !this.uniqueName.trim().equals("Components")) {
                return this.uniqueName;
            }
            return this.getName();
        }

        public long getAnalysisTime() {
            return this.analysisTime;
        }

        public long getNumProcessed() {
            return this.numProcessed;
        }
    }
}

