/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.ErrorHandlerDirective;
import org.apache.uima.ducc.IErrorHandler;
import org.apache.uima.ducc.IErrorHandlerDirective;
import org.apache.uima.ducc.user.common.QuotedOptions;
import org.apache.uima.ducc.user.error.iface.Transformer;
import org.apache.uima.ducc.user.jd.JdUser;

public class ErrorHandler
implements IErrorHandler {
    private static int DefaultJobErrorLimit = JdUser.DefaultJobErrorLimit;
    private AtomicInteger jobErrorLimit = new AtomicInteger(DefaultJobErrorLimit);
    private AtomicInteger jobErrorCount = new AtomicInteger(0);

    public ErrorHandler() {
    }

    public ErrorHandler(String initializationData) {
        this.initialize(initializationData);
    }

    private Map<String, String> parse(String initializationData) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList<String> toks;
            if (initializationData != null && (toks = QuotedOptions.tokenizeList(initializationData, true)) != null) {
                for (String tok : toks) {
                    String[] split = tok.split("=");
                    String key = split[0].trim().toLowerCase();
                    String value = split[1].trim();
                    map.put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public void initialize(String initializationData) {
        if (initializationData != null) {
            String key;
            Map<String, String> map = this.parse(initializationData);
            if (map.containsKey(key = InitializationDataKey.KillJobLimit.name().toLowerCase())) {
                String value = map.get(key);
                this.initKillJob(value);
            } else {
                String altkey = InitializationDataKey.KillJobLimit.altname();
                if (map.containsKey(altkey)) {
                    String value = map.get(altkey);
                    this.initKillJob(value);
                }
            }
        }
    }

    private void initKillJob(String value) {
        try {
            int expect = DefaultJobErrorLimit;
            int update = Integer.parseInt(value);
            this.jobErrorLimit.compareAndSet(expect, update);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IErrorHandlerDirective handle(String serializedCAS, Object object) {
        ErrorHandlerDirective jdUserDirective = new ErrorHandlerDirective();
        try {
            Throwable userThrowable = null;
            if (serializedCAS != null) {
                // empty if block
            }
            if (object != null) {
                if (object instanceof Exception) {
                    userThrowable = (Throwable)object;
                    userThrowable.getClass();
                } else {
                    Object byteArray = object;
                    userThrowable = Transformer.deserialize(byteArray);
                    userThrowable.getClass();
                }
            }
            this.jobErrorCount.incrementAndGet();
            if (this.jobErrorCount.get() > this.jobErrorLimit.get()) {
                jdUserDirective.setKillJob();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jdUserDirective;
    }

    public static enum InitializationDataKey {
        KillJobLimit("max_job_errors");

        private String altname = null;

        private InitializationDataKey() {
            this.altname = this.name();
        }

        private InitializationDataKey(String value) {
            this.altname = value;
        }

        public String altname() {
            return this.altname;
        }
    }
}

