/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.BinaryCasSerDes6;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DuccUimaSerializer {
    private final ThreadLocal<XMLReader> localXmlReader = new ThreadLocal();

    public void serializeToXMI(OutputStream stream, CAS aCAS, String encoding, TypeSystem typeSystem, OutOfTypeSystemData otsd) throws IOException, SAXException {
        if (typeSystem == null) {
            typeSystem = aCAS.getTypeSystem();
        }
        XMLSerializer xmlSer = new XMLSerializer(stream, false);
        if (encoding != null) {
            xmlSer.setOutputProperty("encoding", encoding);
        }
        XmiCasSerializer ser = new XmiCasSerializer(typeSystem);
        ser.serialize(aCAS, xmlSer.getContentHandler());
    }

    public String serializeCasToXmi(CAS aCAS, XmiSerializationSharedData serSharedData) throws Exception {
        try (StringWriter writer = new StringWriter();){
            XMLSerializer xmlSer = new XMLSerializer((Writer)writer, false);
            XmiCasSerializer ser = new XmiCasSerializer(aCAS.getTypeSystem());
            ser.serialize(aCAS, xmlSer.getContentHandler(), null, serSharedData);
            String string = ((Object)writer).toString();
            return string;
        }
    }

    public String serializeCasToXmi(CAS aCAS, XmiSerializationSharedData serSharedData, Marker aMarker) throws Exception {
        try (StringWriter writer = new StringWriter();){
            XMLSerializer xmlSer = new XMLSerializer((Writer)writer, false);
            XmiCasSerializer ser = new XmiCasSerializer(aCAS.getTypeSystem());
            ser.serialize(aCAS, xmlSer.getContentHandler(), null, serSharedData, aMarker);
            String string = ((Object)writer).toString();
            return string;
        }
    }

    public void deserializeCasFromXmi(String anXmlStr, CAS aCAS, XmiSerializationSharedData aSharedData, boolean aLenient, int aMergePoint) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (this.localXmlReader.get() == null) {
            this.localXmlReader.set(XMLReaderFactory.createXMLReader());
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        StringReader reader = new StringReader(anXmlStr);
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(reader));
    }

    public void deserializeCasFromXmi(String anXmlStr, CAS aCAS, XmiSerializationSharedData aSharedData, boolean aLenient, int aMergePoint, AllowPreexistingFS allow) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (this.localXmlReader.get() == null) {
            this.localXmlReader.set(XMLReaderFactory.createXMLReader());
        }
        XMLReader xmlReader = this.localXmlReader.get();
        StringReader reader = new StringReader(anXmlStr);
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS, aLenient, aSharedData, aMergePoint, allow);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(reader));
    }

    public SerialFormat deserializeCasFromBinary(byte[] binarySource, CAS aCAS) throws Exception {
        try (ByteArrayInputStream fis = null;){
            fis = new ByteArrayInputStream(binarySource);
            SerialFormat serialFormat = Serialization.deserializeCAS((CAS)aCAS, (InputStream)fis);
            return serialFormat;
        }
    }

    public byte[] serializeCasToBinary(CAS aCAS) throws Exception {
        try (ByteArrayOutputStream fos = null;){
            fos = new ByteArrayOutputStream();
            Serialization.serializeCAS((CAS)aCAS, (OutputStream)fos);
            byte[] byArray = fos.toByteArray();
            return byArray;
        }
    }

    public byte[] serializeCasToBinary(CAS aCAS, Marker aMark) throws Exception {
        try (ByteArrayOutputStream fos = null;){
            fos = new ByteArrayOutputStream();
            Serialization.serializeCAS((CAS)aCAS, (OutputStream)fos, (Marker)aMark);
            byte[] byArray = fos.toByteArray();
            return byArray;
        }
    }

    public byte[] serializeCasToBinary6(CAS aCAS) throws Exception {
        ByteArrayOutputStream fos = null;
        fos = new ByteArrayOutputStream();
        BinaryCasSerDes6 bcs = new BinaryCasSerDes6((AbstractCas)aCAS);
        bcs.serialize((Object)fos);
        return fos.toByteArray();
    }

    public byte[] serializeCasToBinary6(CAS aCAS, InProcessCache.CacheEntry entry, TypeSystemImpl tgtTs) throws Exception {
        ByteArrayOutputStream fos = null;
        fos = new ByteArrayOutputStream();
        BinaryCasSerDes6 bcs = new BinaryCasSerDes6((AbstractCas)aCAS, tgtTs);
        bcs.serialize((Object)fos);
        entry.setCompress6ReuseInfo(bcs.getReuseInfo());
        return fos.toByteArray();
    }

    public byte[] serializeCasToBinary6(CAS aCAS, Marker aMark, BinaryCasSerDes6.ReuseInfo reuseInfo) throws Exception {
        ByteArrayOutputStream fos = null;
        fos = new ByteArrayOutputStream();
        BinaryCasSerDes6 bcs = new BinaryCasSerDes6((AbstractCas)aCAS, (MarkerImpl)aMark, null, reuseInfo);
        bcs.serialize((Object)fos);
        return fos.toByteArray();
    }
}

