/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.sm;

import java.io.Serializable;

public interface IService
extends Serializable {
    public static final String NULL = "<none>";

    public static enum ServiceState {
        Pending{

            @Override
            public String decode() {
                return "pending";
            }
        }
        ,
        Waiting{

            @Override
            public String decode() {
                return "waiting";
            }
        }
        ,
        Starting{

            @Override
            public String decode() {
                return "starting";
            }
        }
        ,
        Initializing{

            @Override
            public String decode() {
                return "initializing";
            }
        }
        ,
        Available{

            @Override
            public String decode() {
                return "available";
            }
        }
        ,
        NotAvailable{

            @Override
            public String decode() {
                return "not-available";
            }
        }
        ,
        Stopped{

            @Override
            public String decode() {
                return "stopped";
            }
        }
        ,
        Stopping{

            @Override
            public String decode() {
                return "stopping";
            }
        }
        ,
        Undefined{

            @Override
            public String decode() {
                return "undefined";
            }
        };


        public abstract String decode();

        public static ServiceState encode(String value) {
            if (value.equals("pending")) {
                return Pending;
            }
            if (value.equals("waiting")) {
                return Waiting;
            }
            if (value.equals("starting")) {
                return Starting;
            }
            if (value.equals("stopped")) {
                return Stopped;
            }
            if (value.equals("initializing")) {
                return Initializing;
            }
            if (value.equals("available")) {
                return Available;
            }
            if (value.equals("not-available")) {
                return NotAvailable;
            }
            if (value.equals("stopping")) {
                return Stopping;
            }
            if (value.equals("undefined")) {
                return Undefined;
            }
            return Undefined;
        }

        public int ordinality() {
            switch (this) {
                case Pending: {
                    return 9;
                }
                case Available: {
                    return 8;
                }
                case Waiting: {
                    return 7;
                }
                case Initializing: {
                    return 6;
                }
                case Starting: {
                    return 5;
                }
                case Stopping: {
                    return 4;
                }
                case Stopped: {
                    return 3;
                }
                case NotAvailable: {
                    return 2;
                }
                case Undefined: {
                    return 1;
                }
            }
            return 0;
        }
    }

    public static enum ServiceClass {
        Implicit{

            @Override
            public String decode() {
                return "Implicit";
            }
        }
        ,
        Submitted{

            @Override
            public String decode() {
                return "Submitted";
            }
        }
        ,
        Registered{

            @Override
            public String decode() {
                return "Registered";
            }
        }
        ,
        Custom{

            @Override
            public String decode() {
                return "Custom";
            }
        }
        ,
        Undefined{

            @Override
            public String decode() {
                return "Undefined";
            }
        };


        public abstract String decode();

        public static ServiceClass encode(String value) {
            if (value.equals("Implicit")) {
                return Implicit;
            }
            if (value.equals("Submitted")) {
                return Submitted;
            }
            if (value.equals("Registered")) {
                return Registered;
            }
            if (value.equals("Custom")) {
                return Custom;
            }
            return Undefined;
        }
    }

    public static enum ServiceType {
        UimaAs{

            @Override
            public String decode() {
                return "UIMA-AS";
            }
        }
        ,
        Custom{

            @Override
            public String decode() {
                return "CUSTOM";
            }
        }
        ,
        Undefined{

            @Override
            public String decode() {
                return "UNDEFINED";
            }
        };


        public abstract String decode();

        public static ServiceType encode(String value) {
            if (value.equals("UIMA-AS")) {
                return UimaAs;
            }
            if (value.equals("CUSTOM")) {
                return Custom;
            }
            return Undefined;
        }
    }

    public static enum Trinary {
        True{

            @Override
            public boolean decode() {
                return true;
            }
        }
        ,
        False{

            @Override
            public boolean decode() {
                return false;
            }
        }
        ,
        Unset{

            @Override
            public boolean decode() {
                throw new IllegalStateException("decode() is illegal for Trinary.");
            }
        };


        public abstract boolean decode();

        public static Trinary encode(String value) {
            if (value.equals("true")) {
                return True;
            }
            if (value.equals("false")) {
                return False;
            }
            return Unset;
        }
    }
}

