/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.jd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.jd.files.workitem.IRemoteLocation;
import org.apache.uima.ducc.common.jd.files.workitem.RemoteLocation;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.container.common.IJdConstants;
import org.apache.uima.ducc.container.common.Util;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.mh.iface.IOperatingInfo;
import org.apache.uima.ducc.container.jd.mh.iface.IProcessInfo;
import org.apache.uima.ducc.container.jd.mh.iface.IWorkItemInfo;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.transport.event.common.DuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.DuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.Rationale;
import org.apache.uima.ducc.transport.event.jd.DuccProcessWorkItemsReport;
import org.apache.uima.ducc.transport.event.jd.IDriverState;
import org.apache.uima.ducc.transport.event.jd.IDriverStatusReport;

public class JobDriverReport
implements Serializable,
IDriverStatusReport {
    private static Logger logger = Logger.getLogger(JobDriverReport.class, (String)IComponent.Id.JD.name());
    private static final long serialVersionUID = 200L;
    private DuccId duccId = null;
    private String node = null;
    private int port = 0;
    private String jdState = null;
    private String jmxUrl = null;
    private long workItemsTotal = 0L;
    private int workItemsProcessingCompleted = 0;
    private int workItemsProcessingError = 0;
    private int workItemsRetry = 0;
    private int workItemsDispatched = 0;
    private int workItemsPreempted = 0;
    private long wiMillisMin = 0L;
    private long wiMillisMax = 0L;
    private long wiMillisAvg = 0L;
    private long wiMillisOperatingLeast = 0L;
    private long wiMillisCompletedMost = 0L;
    private long wiTodMostRecentStart = 0L;
    private boolean wiPending = true;
    private boolean killJob = false;
    private ArrayList<IWorkItemInfo> listActiveWorkItemInfo = null;
    private Map<RemoteLocation, Long> mapProcessOperatingMillis = null;
    private Map<RemoteLocation, Long> mapProcessInvestmentMillis = null;
    private Map<IRemoteLocation, IResourceState.ProcessDeallocationType> processKillMap = null;
    private String jpDeployable = null;
    private IDuccCompletionType.JobCompletionType jobCompletionType = IDuccCompletionType.JobCompletionType.EndOfJob;
    private IRationale jobCompletionRationale = null;
    private IDuccPerWorkItemStatistics duccPerWorkItemStatistics = null;
    private double avgTimeForWorkItemsSkewedByActive = 0.0;
    private DuccProcessWorkItemsReport duccProcessWorkItemsReport = null;

    private long max(long a, long b) {
        long retVal = a;
        if (b > a) {
            retVal = b;
        }
        return retVal;
    }

    private long min(long a, long b) {
        long retVal = a;
        if (b < a) {
            retVal = b;
        }
        return retVal;
    }

    private DuccId getDuccId(IOperatingInfo operatingInfo) {
        DuccId retVal = null;
        try {
            String jobId = operatingInfo.getJobId();
            long value = Long.parseLong(jobId);
            retVal = new DuccId(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public JobDriverReport(IOperatingInfo operatingInfo, IDuccProcessMap dpMap) {
        long fMax;
        long fMin;
        String location = "JobDriverReport";
        this.setDuccId(this.getDuccId(operatingInfo));
        this.setJdState(operatingInfo.getJdState());
        this.setWorkItemsTotal(operatingInfo.getWorkItemCrTotal());
        this.setWorkItemsProcessingCompleted(operatingInfo.getWorkItemEndSuccesses());
        this.setWorkItemsProcessingError(operatingInfo.getWorkItemEndFailures());
        this.setWorkItemsDispatched(operatingInfo.getWorkItemDispatcheds());
        this.setWorkItemsRetry(operatingInfo.getWorkItemRetrys());
        this.setWorkItemsPreempt(operatingInfo.getWorkItemPreemptions());
        long min = fMin = operatingInfo.getWorkItemFinishedMillisMin();
        long rMin = operatingInfo.getWorkItemRunningMillisMin();
        if (rMin > 0L) {
            min = this.min(fMin, rMin);
        }
        this.setWiMillisMin(min);
        long max = fMax = operatingInfo.getWorkItemFinishedMillisMax();
        long rMax = operatingInfo.getWorkItemRunningMillisMax();
        if (rMax > 0L) {
            max = this.max(fMax, rMax);
        }
        this.setWiMillisMax(max);
        long avg = operatingInfo.getWorkItemFinishedMillisAvg();
        this.setWiMillisAvg(avg);
        this.setWiMillisOperatingLeast(rMin);
        this.setWiMillisCompletedMost(fMax);
        this.setMostRecentStart(operatingInfo.getWorkItemTodMostRecentStart());
        this.setWiPending(operatingInfo.isWorkItemCrPending());
        if (operatingInfo.isKillJob()) {
            this.setKillJob();
            this.setCompletionType(operatingInfo.getCompletionType());
            String completionText = operatingInfo.getCompletionText();
            if (completionText != null) {
                Rationale completionRationale = new Rationale(completionText);
                this.setCompletionRationale(completionRationale);
            }
        }
        this.setActiveWorkItemInfo(operatingInfo.getActiveWorkItemInfo());
        this.setJpDeployable(operatingInfo.getJpDeployable());
        DuccPerWorkItemStatistics perWorkItemStatistics = new DuccPerWorkItemStatistics(operatingInfo.getWorkItemFinishedMillisMax(), operatingInfo.getWorkItemFinishedMillisMin(), operatingInfo.getWorkItemFinishedMillisAvg(), operatingInfo.getWorkItemFinishedMillisStdDev());
        this.setPerWorkItemStatistics(perWorkItemStatistics);
        this.setAvgTimeForWorkItemsSkewedByActive(operatingInfo.getWorkItemSkewAvg());
        ArrayList list = operatingInfo.getProcessItemInfo();
        if (list != null) {
            if (!list.isEmpty()) {
                this.duccProcessWorkItemsReport = new DuccProcessWorkItemsReport();
                for (IProcessInfo pi : list) {
                    String ip = pi.getNodeAddress();
                    int pid = pi.getPid();
                    IDuccProcess dp = dpMap.findProcess(ip, "" + pid);
                    if (dp != null) {
                        DuccId key = dp.getDuccId();
                        DuccProcessWorkItems value = new DuccProcessWorkItems(pi);
                        this.duccProcessWorkItemsReport.accum(key, value);
                        continue;
                    }
                    logger.debug(location, null, new Object[]{"process not found: ip=" + ip + " pid=" + pid});
                    int i = 0;
                    for (Map.Entry entry : dpMap.entrySet()) {
                        IDuccProcess value = (IDuccProcess)entry.getValue();
                        logger.debug(location, null, new Object[]{"process[" + i + "]: ip=" + value.getNodeIdentity().getIp() + " pid=" + value.getPID()});
                        ++i;
                    }
                }
            } else {
                logger.debug(location, null, new Object[]{"list is empty"});
            }
        } else {
            logger.debug(location, null, new Object[]{"list is null"});
        }
        Map<IRemoteLocation, IResourceState.ProcessDeallocationType> map = this.convert(operatingInfo.getProcessKillMap());
        this.setProcessKillMap(map);
    }

    private Map<IRemoteLocation, IResourceState.ProcessDeallocationType> convert(Map<IRemoteLocation, IJdConstants.DeallocateReason> jdMap) {
        HashMap<IRemoteLocation, IResourceState.ProcessDeallocationType> map = new HashMap<IRemoteLocation, IResourceState.ProcessDeallocationType>();
        block3: for (Map.Entry<IRemoteLocation, IJdConstants.DeallocateReason> entry : jdMap.entrySet()) {
            switch (entry.getValue()) {
                case WorkItemTimeout: {
                    map.put(entry.getKey(), IResourceState.ProcessDeallocationType.Timeout);
                    continue block3;
                }
            }
            map.put(entry.getKey(), IResourceState.ProcessDeallocationType.Undefined);
        }
        return map;
    }

    private void setDuccId(DuccId value) {
        this.duccId = value;
    }

    @Override
    public void setNode(String value) {
        this.node = value;
    }

    @Override
    public void setPort(int value) {
        this.port = value;
    }

    @Override
    public void setJdState(String value) {
        this.jdState = value;
    }

    @Override
    public void setJmxUrl(String value) {
        this.jmxUrl = value;
    }

    private void setWorkItemsTotal(long value) {
        this.workItemsTotal = value;
    }

    private void setWorkItemsProcessingCompleted(int value) {
        this.workItemsProcessingCompleted = value;
    }

    private void setWorkItemsProcessingError(int value) {
        this.workItemsProcessingError = value;
    }

    private void setWorkItemsDispatched(int value) {
        this.workItemsDispatched = value;
    }

    private void setWorkItemsRetry(int value) {
        this.workItemsRetry = value;
    }

    private void setWorkItemsPreempt(int value) {
        this.workItemsPreempted = value;
    }

    private void setWiMillisMin(long value) {
        this.wiMillisMin = value;
    }

    private void setWiMillisMax(long value) {
        this.wiMillisMax = value;
    }

    private void setWiMillisAvg(long value) {
        this.wiMillisAvg = value;
    }

    private void setWiMillisOperatingLeast(long value) {
        this.wiMillisOperatingLeast = value;
    }

    private void setWiMillisCompletedMost(long value) {
        this.wiMillisCompletedMost = value;
    }

    private void setMostRecentStart(long value) {
        this.wiTodMostRecentStart = value;
    }

    private void setWiPending(boolean value) {
        this.wiPending = value;
    }

    private void setKillJob() {
        this.killJob = true;
    }

    private void setActiveWorkItemInfo(ArrayList<IWorkItemInfo> value) {
        this.listActiveWorkItemInfo = value;
    }

    private void setJpDeployable(String value) {
        this.jpDeployable = value;
    }

    private void setPerWorkItemStatistics(IDuccPerWorkItemStatistics value) {
        this.duccPerWorkItemStatistics = value;
    }

    public void setProcessKillMap(Map<IRemoteLocation, IResourceState.ProcessDeallocationType> value) {
        this.processKillMap = value;
    }

    @Override
    public long getVersion() {
        return 200L;
    }

    @Override
    public DuccId getDuccId() {
        return this.duccId;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getJdState() {
        return this.jdState;
    }

    @Override
    public String getLogReport() {
        StringBuffer sb = new StringBuffer();
        sb.append("state: " + this.getJdState() + " ");
        sb.append("total: " + this.getWorkItemsTotal() + " ");
        sb.append("done: " + this.getWorkItemsProcessingCompleted() + " ");
        sb.append("error: " + this.getWorkItemsProcessingError() + " ");
        sb.append("killJob: " + this.isKillJob() + " ");
        return sb.toString();
    }

    @Override
    public long getWorkItemsTotal() {
        return this.workItemsTotal;
    }

    @Override
    public int getWorkItemsProcessingCompleted() {
        return this.workItemsProcessingCompleted;
    }

    @Override
    public int getWorkItemsProcessingError() {
        return this.workItemsProcessingError;
    }

    @Override
    public int getWorkItemsRetry() {
        return this.workItemsRetry;
    }

    @Override
    public int getWorkItemsDispatched() {
        return this.workItemsDispatched;
    }

    @Override
    public int getWorkItemsPreempted() {
        return this.workItemsPreempted;
    }

    @Override
    public long getWiMillisMin() {
        return this.wiMillisMin;
    }

    @Override
    public long getWiMillisMax() {
        return this.wiMillisMax;
    }

    @Override
    public long getWiMillisAvg() {
        return this.wiMillisAvg;
    }

    @Override
    public long getWiMillisOperatingLeast() {
        return this.wiMillisOperatingLeast;
    }

    @Override
    public long getWiMillisCompletedMost() {
        return this.wiMillisCompletedMost;
    }

    @Override
    public long getMostRecentStart() {
        return this.wiTodMostRecentStart;
    }

    @Override
    public boolean isPending() {
        return this.wiPending;
    }

    @Override
    public boolean isKillJob() {
        return this.killJob;
    }

    @Override
    public boolean isOperating(String nodeIP, String PID) {
        boolean retVal = false;
        if (this.listActiveWorkItemInfo != null) {
            for (IWorkItemInfo wii : this.listActiveWorkItemInfo) {
                if (!Util.compare((String)wii.getNodeAddress(), (String)nodeIP) || !Util.compare((String)("" + wii.getPid()), (String)PID)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    @Override
    public String getJdJmxUrl() {
        return this.jmxUrl;
    }

    @Override
    public String getUimaDeploymentDescriptor() {
        return null;
    }

    @Override
    public String getUimaAnalysisEngine() {
        return this.jpDeployable;
    }

    @Override
    public Map<IRemoteLocation, IResourceState.ProcessDeallocationType> getProcessKillMap() {
        return this.processKillMap;
    }

    @Override
    @Deprecated
    public IDriverState.DriverState getDriverState() {
        IDriverState.DriverState retVal = IDriverState.DriverState.Undefined;
        String state = this.getJdState();
        if (state != null) {
            if (state.equals(IMetaCasTransaction.JdState.Initializing.name())) {
                retVal = IDriverState.DriverState.Initializing;
            } else if (state.equals(IMetaCasTransaction.JdState.Active.name())) {
                retVal = IDriverState.DriverState.Running;
            } else if (state.equals(IMetaCasTransaction.JdState.Ended.name())) {
                retVal = IDriverState.DriverState.Completed;
            }
        }
        return retVal;
    }

    private void setCompletionType(IOperatingInfo.CompletionType completionType) {
        switch (completionType) {
            case Normal: {
                break;
            }
            case Exception: {
                this.jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledByDriver;
            }
        }
    }

    private void setCompletionRationale(IRationale value) {
        this.jobCompletionRationale = value;
    }

    @Override
    public IDuccCompletionType.JobCompletionType getJobCompletionType() {
        return this.jobCompletionType;
    }

    @Override
    public IRationale getJobCompletionRationale() {
        return this.jobCompletionRationale;
    }

    @Override
    public IDuccPerWorkItemStatistics getPerWorkItemStatistics() {
        return this.duccPerWorkItemStatistics;
    }

    @Override
    public DuccProcessWorkItemsReport getDuccProcessWorkItemsMap() {
        return this.duccProcessWorkItemsReport;
    }

    @Override
    public synchronized Map<RemoteLocation, Long> getOperatingMillisMap() {
        if (this.mapProcessOperatingMillis == null) {
            this.mapProcessOperatingMillis = new HashMap<RemoteLocation, Long>();
            if (this.listActiveWorkItemInfo != null) {
                for (IWorkItemInfo wii : this.listActiveWorkItemInfo) {
                    String PID;
                    String nodeIP = wii.getNodeAddress();
                    RemoteLocation rl = new RemoteLocation(nodeIP, PID = "" + wii.getPid());
                    if (!this.mapProcessOperatingMillis.containsKey(rl)) {
                        this.mapProcessOperatingMillis.put(rl, new Long(0L));
                    }
                    long millis = wii.getOperatingMillis() + this.mapProcessOperatingMillis.get(rl);
                    this.mapProcessOperatingMillis.put(rl, new Long(millis));
                }
            }
        }
        return this.mapProcessOperatingMillis;
    }

    @Override
    public synchronized Map<RemoteLocation, Long> getInvestmentMillisMap() {
        this.mapProcessInvestmentMillis = new HashMap<RemoteLocation, Long>();
        if (this.listActiveWorkItemInfo != null) {
            for (IWorkItemInfo wii : this.listActiveWorkItemInfo) {
                String nodeIP = wii.getNodeAddress();
                String PID = "" + wii.getPid();
                RemoteLocation rl = new RemoteLocation(nodeIP, PID);
                this.mapProcessInvestmentMillis.put(rl, wii.getInvestmentMillis());
            }
        }
        return this.mapProcessInvestmentMillis;
    }

    @Override
    public double getAvgTimeForWorkItemsSkewedByActive() {
        return this.avgTimeForWorkItemsSkewedByActive;
    }

    private void setAvgTimeForWorkItemsSkewedByActive(double value) {
        this.avgTimeForWorkItemsSkewedByActive = value;
    }
}

