/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;

public class DuccWorkUtil {
    private static void put(List<String> list, NodeIdentity nodeIdentity) {
        String name;
        if (list != null && nodeIdentity != null && (name = nodeIdentity.getName()) != null && !list.contains(name)) {
            list.add(name);
        }
    }

    private static void putProcessMapNodes(List<String> list, IDuccProcessMap processMap) {
        Set<Map.Entry<DuccId, IDuccProcess>> entrySet;
        Map<DuccId, IDuccProcess> map;
        if (list != null && processMap != null && (map = processMap.getMap()) != null && (entrySet = map.entrySet()) != null) {
            for (Map.Entry<DuccId, IDuccProcess> entry : entrySet) {
                IDuccProcess process;
                if (entry == null || (process = entry.getValue()) == null) continue;
                NodeIdentity nodeIdentity = process.getNodeIdentity();
                DuccWorkUtil.put(list, nodeIdentity);
            }
        }
    }

    private static void putJobDriverNode(List<String> list, IDuccWorkJob dwJob) {
        DuccWorkPopDriver driver;
        if (dwJob != null && (driver = dwJob.getDriver()) != null) {
            IDuccProcessMap processMap = driver.getProcessMap();
            DuccWorkUtil.putProcessMapNodes(list, processMap);
        }
    }

    private static void putJobProcessNodes(List<String> list, IDuccWorkJob dwJob) {
        if (dwJob != null) {
            IDuccProcessMap processMap = dwJob.getProcessMap();
            DuccWorkUtil.putProcessMapNodes(list, processMap);
        }
    }

    private static void putReservationNodes(List<String> list, IDuccWorkReservation dwReservation) {
        Set entrySet;
        IDuccReservationMap reservationMap;
        if (dwReservation != null && list != null && (reservationMap = dwReservation.getReservationMap()) != null && (entrySet = reservationMap.entrySet()) != null) {
            for (Map.Entry entry : entrySet) {
                IDuccReservation reservation;
                if (entry == null || (reservation = (IDuccReservation)entry.getValue()) == null) continue;
                NodeIdentity nodeIdentity = reservation.getNodeIdentity();
                DuccWorkUtil.put(list, nodeIdentity);
            }
        }
    }

    public static void getJobNodes(List<String> list, DuccWorkMap duccWorkMap) {
        Set<DuccId> jobKeySet;
        if (duccWorkMap != null && (jobKeySet = duccWorkMap.getJobKeySet()) != null) {
            for (DuccId duccId : jobKeySet) {
                IDuccWork duccWork = duccWorkMap.findDuccWork(duccId);
                IDuccWorkJob dwJob = (IDuccWorkJob)duccWork;
                DuccWorkUtil.putJobDriverNode(list, dwJob);
                DuccWorkUtil.putJobProcessNodes(list, dwJob);
            }
        }
    }

    public static void getReservationNodes(List<String> list, DuccWorkMap duccWorkMap) {
        Set<DuccId> reservationKeySet;
        if (duccWorkMap != null && (reservationKeySet = duccWorkMap.getReservationKeySet()) != null) {
            for (DuccId duccId : reservationKeySet) {
                IDuccWork duccWork = duccWorkMap.findDuccWork(duccId);
                IDuccWorkReservation dwReservation = (IDuccWorkReservation)duccWork;
                DuccWorkUtil.putReservationNodes(list, dwReservation);
            }
        }
    }

    public static List<String> getNodes(DuccWorkMap duccWorkMap) {
        ArrayList<String> list = new ArrayList<String>();
        DuccWorkUtil.getJobNodes(list, duccWorkMap);
        DuccWorkUtil.getReservationNodes(list, duccWorkMap);
        return list;
    }
}

