/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.event.common.CGroup;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.Util;

public class DuccProcess
implements IDuccProcess {
    private static final long serialVersionUID = 1L;
    private long dataVersion = 1L;
    private DuccId duccId = null;
    private Node node = null;
    private NodeIdentity nodeIdentity = null;
    private String pid = null;
    private IProcessState.ProcessState processState = IProcessState.ProcessState.Undefined;
    private IResourceState.ResourceState resourceState = IResourceState.ResourceState.Undefined;
    private IResourceState.ProcessDeallocationType deallocationType = IResourceState.ProcessDeallocationType.Undefined;
    private ITimeWindow timeWindowInit = null;
    private ITimeWindow timeWindowRun = null;
    private long residentMemory = 0L;
    private long residentMemoryMax = 0L;
    private IDuccProcessType.ProcessType processType;
    private List<IUimaPipelineAEComponent> uimaPipelineComponentList = new ArrayList<IUimaPipelineAEComponent>();
    private ProcessGarbageCollectionStats gcStats = null;
    private String processJmxUrl;
    private IDuccProcessWorkItems processWorkItems = null;
    private long cpuUsage;
    private String reason;
    private String extendedReason;
    private boolean initialized = false;
    private int exitCode;
    private CGroup cgroup;
    private long majorFaults = SpecialValue.Unknown.getlong();
    private long swapUsage = SpecialValue.Unknown.getlong();
    private long swapUsageMax = SpecialValue.Unknown.getlong();
    private long wiMillisInvestment;
    private long currentCPU;

    public DuccProcess(DuccId duccId, NodeIdentity nodeIdentity) {
        this.setDuccId(duccId);
        this.setNodeIdentity(nodeIdentity);
    }

    public DuccProcess(DuccId duccId, Node node) {
        this.setDuccId(duccId);
        this.setNode(node);
        NodeIdentity nodeIdentity = node.getNodeIdentity();
        this.setNodeIdentity(nodeIdentity);
    }

    public DuccProcess(DuccId duccId, NodeIdentity nodeIdentity, IDuccProcessType.ProcessType processType) {
        this.setDuccId(duccId);
        this.setNodeIdentity(nodeIdentity);
        this.setProcessType(processType);
    }

    public DuccProcess(DuccId duccId, Node node, IDuccProcessType.ProcessType processType) {
        this.setDuccId(duccId);
        this.setNode(node);
        NodeIdentity nodeIdentity = node.getNodeIdentity();
        this.setNodeIdentity(nodeIdentity);
        this.setProcessType(processType);
    }

    @Override
    public long getDataVersion() {
        long retVal = 0L;
        try {
            retVal = this.dataVersion;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public List<IUimaPipelineAEComponent> getUimaPipelineComponents() {
        return this.uimaPipelineComponentList;
    }

    @Override
    public void setUimaPipelineComponents(List<IUimaPipelineAEComponent> uimaPipelineComponentList) {
        this.uimaPipelineComponentList = uimaPipelineComponentList;
    }

    @Override
    public DuccId getDuccId() {
        return this.duccId;
    }

    @Override
    public void setDuccId(DuccId duccId) {
        this.duccId = duccId;
    }

    @Override
    public NodeIdentity getNodeIdentity() {
        return this.nodeIdentity;
    }

    @Override
    public void setNodeIdentity(NodeIdentity nodeIdentity) {
        this.nodeIdentity = nodeIdentity;
    }

    @Override
    public String getPID() {
        return this.pid;
    }

    @Override
    public void setPID(String pid) {
        this.pid = pid;
    }

    @Override
    public IProcessState.ProcessState getProcessState() {
        return this.processState;
    }

    @Override
    public void setProcessState(IProcessState.ProcessState processState) {
        this.processState = processState;
        this.setEndTimes();
    }

    private void setEndTime(ITimeWindow tw) {
        if (tw != null && tw.getStart() != null && tw.getEnd() == null) {
            tw.setEndLong(System.currentTimeMillis());
        }
    }

    private void setEndTimes() {
        switch (this.getProcessState()) {
            case LaunchFailed: 
            case Stopped: 
            case Failed: 
            case FailedInitialization: 
            case InitializationTimeout: 
            case Killed: {
                this.setEndTime(this.timeWindowInit);
                this.setEndTime(this.timeWindowRun);
                break;
            }
        }
    }

    @Override
    public void advanceProcessState(IProcessState.ProcessState nextProcessState) {
        block0 : switch (this.getProcessState()) {
            case Starting: {
                switch (nextProcessState) {
                    case Undefined: 
                    case Starting: {
                        break block0;
                    }
                }
                this.setProcessState(nextProcessState);
                break;
            }
            case Started: {
                switch (nextProcessState) {
                    case Undefined: 
                    case Starting: 
                    case Started: {
                        break block0;
                    }
                }
                this.setProcessState(nextProcessState);
                break;
            }
            case Initializing: {
                switch (nextProcessState) {
                    case Undefined: 
                    case Starting: 
                    case Started: 
                    case Initializing: {
                        break block0;
                    }
                }
                this.setProcessState(nextProcessState);
                break;
            }
            case Running: {
                switch (nextProcessState) {
                    case Undefined: 
                    case Starting: 
                    case Started: 
                    case Initializing: 
                    case Running: {
                        break block0;
                    }
                }
                this.setProcessState(nextProcessState);
                break;
            }
            case LaunchFailed: 
            case Stopped: 
            case Failed: 
            case FailedInitialization: 
            case InitializationTimeout: 
            case Killed: {
                break;
            }
            default: {
                switch (nextProcessState) {
                    case Undefined: {
                        break block0;
                    }
                }
                this.setProcessState(nextProcessState);
            }
        }
        this.setEndTimes();
    }

    @Override
    public IResourceState.ResourceState getResourceState() {
        return this.resourceState;
    }

    @Override
    public void setResourceState(IResourceState.ResourceState resourceState) {
        this.resourceState = resourceState;
    }

    @Override
    public IResourceState.ProcessDeallocationType getProcessDeallocationType() {
        return this.deallocationType;
    }

    @Override
    public void setProcessDeallocationType(IResourceState.ProcessDeallocationType deallocationType) {
        this.deallocationType = deallocationType;
    }

    @Override
    public ITimeWindow getTimeWindowInit() {
        return this.timeWindowInit;
    }

    @Override
    public void setTimeWindowInit(ITimeWindow timeWindow) {
        this.timeWindowInit = timeWindow;
    }

    @Override
    public ITimeWindow getTimeWindowRun() {
        return this.timeWindowRun;
    }

    @Override
    public void setTimeWindowRun(ITimeWindow timeWindow) {
        this.timeWindowRun = timeWindow;
    }

    @Override
    public boolean stateChange(IProcessState.ProcessState state) {
        boolean retVal = false;
        if (!retVal) {
            throw new RuntimeException("not implemented");
        }
        return retVal;
    }

    @Override
    public boolean isAssignedWork() {
        boolean retVal = true;
        IDuccProcessWorkItems pwi = this.getProcessWorkItems();
        retVal = pwi == null ? false : pwi.isAssignedWork();
        return retVal;
    }

    @Override
    public boolean isActive() {
        boolean retVal = false;
        switch (this.processState) {
            case Starting: 
            case Started: 
            case Initializing: 
            case Running: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isReady() {
        boolean retVal = false;
        switch (this.processState) {
            case Running: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isFailed() {
        boolean retVal = false;
        switch (this.processState) {
            case LaunchFailed: 
            case Failed: 
            case Killed: {
                retVal = true;
                break;
            }
            case Stopped: {
                String reason = this.getReasonForStoppingProcess();
                if (reason == null) break;
                if (reason.equals("FailedInitialization")) {
                    retVal = true;
                    break;
                }
                if (!reason.equals("InitializationTimeout")) break;
                retVal = true;
                break;
            }
            case FailedInitialization: 
            case InitializationTimeout: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isFailedInitialization() {
        boolean retVal = false;
        String reason = this.getReasonForStoppingProcess();
        if (reason != null) {
            if (reason.equals("FailedInitialization")) {
                retVal = true;
            } else if (reason.equals("InitializationTimeout")) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isPreempted() {
        boolean retVal = false;
        switch (this.deallocationType) {
            case Forced: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isVolunteered() {
        boolean retVal = false;
        switch (this.deallocationType) {
            case Voluntary: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isComplete() {
        boolean retVal = false;
        switch (this.processState) {
            case LaunchFailed: 
            case Stopped: 
            case Failed: 
            case FailedInitialization: 
            case InitializationTimeout: 
            case Killed: 
            case Abandoned: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isDeallocated() {
        boolean retVal = false;
        switch (this.resourceState) {
            case Deallocated: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isDefunct() {
        boolean retVal = false;
        switch (this.resourceState) {
            case Deallocated: {
                retVal = this.isComplete();
            }
        }
        return retVal;
    }

    @Override
    public boolean isDeallocationNormal() {
        boolean retVal = true;
        switch (this.deallocationType) {
            case Forced: 
            case Voluntary: 
            case JobCanceled: 
            case JobFailure: 
            case JobCompleted: 
            case Stopped: 
            case Canceled: 
            case Undefined: {
                retVal = true;
                break;
            }
            case Exception: 
            case AutonomousStop: 
            case Failed: 
            case FailedInitialization: 
            case InitializationTimeout: 
            case Killed: 
            case Purged: {
                retVal = false;
            }
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDuccId() == null ? 0 : this.getDuccId().hashCode());
        result = 31 * result + (this.getNodeIdentity() == null ? 0 : this.getNodeIdentity().hashCode());
        result = 31 * result + (this.getPID() == null ? 0 : this.getPID().hashCode());
        result = 31 * result + (this.getProcessState() == null ? 0 : this.getProcessState().hashCode());
        result = 31 * result + (this.getResourceState() == null ? 0 : this.getResourceState().hashCode());
        result = 31 * result + (this.getTimeWindowInit() == null ? 0 : this.getTimeWindowInit().hashCode());
        result = 31 * result + (this.getTimeWindowRun() == null ? 0 : this.getTimeWindowRun().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (this == obj) {
            retVal = true;
        } else if (this.getClass() == obj.getClass()) {
            DuccProcess that = (DuccProcess)obj;
            if (Util.compare(this.getDuccId(), that.getDuccId()) && Util.compare(this.getNodeIdentity(), that.getNodeIdentity()) && Util.compare(this.getPID(), that.getPID()) && Util.compare((Object)this.getProcessState(), (Object)that.getProcessState()) && Util.compare((Object)this.getResourceState(), (Object)that.getResourceState()) && Util.compare(this.getTimeWindowInit(), that.getTimeWindowInit()) && Util.compare(this.getTimeWindowRun(), that.getTimeWindowRun())) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public void setResidentMemory(long residentMemory) {
        if (residentMemory > this.residentMemoryMax) {
            this.residentMemoryMax = residentMemory;
        }
        this.residentMemory = residentMemory;
    }

    @Override
    public long getResidentMemory() {
        return this.residentMemory;
    }

    @Override
    public long getResidentMemoryMax() {
        long retVal = 0L;
        try {
            retVal = this.residentMemoryMax;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public IDuccProcessType.ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    public void setProcessType(IDuccProcessType.ProcessType processType) {
        this.processType = processType;
    }

    @Override
    public void setGarbageCollectionStats(ProcessGarbageCollectionStats gcStats) {
        this.gcStats = gcStats;
    }

    @Override
    public ProcessGarbageCollectionStats getGarbageCollectionStats() {
        return this.gcStats;
    }

    @Override
    public void setProcessJmxUrl(String processJmxUrl) {
        this.processJmxUrl = processJmxUrl;
    }

    @Override
    public String getProcessJmxUrl() {
        return this.processJmxUrl;
    }

    @Override
    public IDuccProcessWorkItems getProcessWorkItems() {
        return this.processWorkItems;
    }

    @Override
    public void setProcessWorkItems(IDuccProcessWorkItems processWorkItems) {
        this.processWorkItems = processWorkItems;
    }

    @Override
    public void setCpuTime(long cpuTime) {
        this.cpuUsage = cpuTime;
    }

    @Override
    public long getCpuTime() {
        return this.cpuUsage;
    }

    @Override
    public String getReasonForStoppingProcess() {
        return this.reason;
    }

    @Override
    public String getExtendedReasonForStoppingProcess() {
        return this.extendedReason;
    }

    @Override
    public void setReasonForStoppingProcess(String reason) {
        this.reason = reason;
    }

    @Override
    public void setExtendedReasonForStoppingProcess(String reason) {
        this.extendedReason = reason;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized() {
        this.initialized = true;
    }

    @Override
    public void resetInitialized() {
        this.initialized = false;
    }

    @Override
    public void setProcessExitCode(int pExitCode) {
        this.exitCode = pExitCode;
    }

    @Override
    public int getProcessExitCode() {
        return this.exitCode;
    }

    @Override
    public void setCGroup(CGroup cgroup) {
        this.cgroup = cgroup;
    }

    @Override
    public CGroup getCGroup() {
        return this.cgroup;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void setNode(Node node) {
        this.node = node;
    }

    @Override
    public void setMajorFaults(long faultCount) {
        this.majorFaults = faultCount;
    }

    @Override
    public long getMajorFaults() {
        return this.majorFaults;
    }

    @Override
    public void setSwapUsage(long susage) {
        this.swapUsage = susage;
    }

    @Override
    public long getSwapUsage() {
        return this.swapUsage;
    }

    @Override
    public void setSwapUsageMax(long susage) {
        this.swapUsageMax = susage;
    }

    @Override
    public long getSwapUsageMax() {
        return this.swapUsageMax;
    }

    @Override
    public void setWiMillisInvestment(long value) {
        this.wiMillisInvestment = value;
    }

    @Override
    public long getWiMillisInvestment() {
        return this.wiMillisInvestment;
    }

    @Override
    public void setCurrentCPU(long cpu) {
        this.currentCPU = cpu;
    }

    @Override
    public long getCurrentCPU() {
        return this.currentCPU;
    }

    public static enum SpecialValue {
        Unknown(-100L),
        Unavailable(-1L);

        long sv = 0L;

        private SpecialValue(long value) {
            this.sv = value;
        }

        long getlong() {
            return this.sv;
        }
    }
}

