/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;

public class OrchestratorStateDuccEvent
extends AbstractDuccEvent {
    private static final long serialVersionUID = 2L;
    private static DuccId jobid = null;
    private static DuccLogger logger = null;
    private IDuccWorkMap workMap = null;

    public OrchestratorStateDuccEvent() {
        super(DuccEvent.EventType.ORCHESTRATOR_STATE);
    }

    public OrchestratorStateDuccEvent(DuccLogger duccLogger) {
        super(DuccEvent.EventType.ORCHESTRATOR_STATE);
        logger = duccLogger;
    }

    public void setWorkMap(IDuccWorkMap value) {
        this.workMap = value.deepCopy();
        this.trim();
    }

    public IDuccWorkMap getWorkMap() {
        IDuccWorkMap value = this.workMap.deepCopy();
        return value;
    }

    private int sizeOf(Object object) {
        String location = "sizeOf";
        int retVal = 0;
        try {
            if (object != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(object);
                String string = bos.toString();
                os.close();
                retVal = string.length();
            }
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
            e.printStackTrace();
        }
        return retVal;
    }

    private void trim() {
        String location = "trim";
        int bytesTrimmed = 0;
        for (Object key : this.workMap.keySet()) {
            int s1;
            ICommandLine cmdLine1 = null;
            ICommandLine cmdLine2 = null;
            DuccId duccId = (DuccId)key;
            IDuccWork dw = (IDuccWork)this.workMap.get(duccId);
            if (dw instanceof IDuccWorkJob) {
                IDuccWorkJob job = (IDuccWorkJob)dw;
                if (logger != null) {
                    cmdLine1 = job.getCommandLine();
                    s1 = this.sizeOf(cmdLine1);
                    DuccWorkPopDriver driver = job.getDriver();
                    if (driver != null) {
                        cmdLine2 = driver.getCommandLine();
                        driver.setCommandLine(null);
                    }
                    int s2 = this.sizeOf(cmdLine2);
                    String message = "jd:" + s1 + " jp:" + s2 + " total:" + (bytesTrimmed += s1 + s2);
                    logger.trace(location, duccId, new Object[]{message});
                }
                job.setCommandLine(null);
                continue;
            }
            if (dw instanceof IDuccWorkService) {
                IDuccWorkJob service = (IDuccWorkJob)dw;
                if (logger != null) {
                    s1 = 0;
                    cmdLine2 = service.getCommandLine();
                    int s2 = this.sizeOf(cmdLine2);
                    String message = "sp:" + s2 + " total:" + (bytesTrimmed += s1 + s2);
                    logger.trace(location, duccId, new Object[]{message});
                }
                service.setCommandLine(null);
                continue;
            }
            if (!(dw instanceof IDuccWorkExecutable)) continue;
            IDuccWorkExecutable dwe = (IDuccWorkExecutable)((Object)dw);
            if (logger != null) {
                cmdLine1 = dwe.getCommandLine();
                s1 = this.sizeOf(cmdLine1);
                int s2 = 0;
                String message = "mr:" + s1 + " total:" + (bytesTrimmed += s1 + s2);
                logger.trace(location, duccId, new Object[]{message});
            }
            dwe.setCommandLine(null);
        }
        if (logger != null) {
            String message = "total:" + bytesTrimmed;
            logger.debug(location, jobid, new Object[]{message});
        }
    }
}

