/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import java.io.InvalidClassException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.pool.BasicConnPool;
import org.apache.http.util.EntityUtils;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.container.net.iface.IPerformanceMetrics;
import org.apache.uima.ducc.container.net.impl.MetaCasTransaction;
import org.apache.uima.ducc.container.net.impl.PerformanceMetrics;
import org.apache.uima.ducc.container.net.impl.TransactionId;
import org.apache.uima.ducc.container.sd.ServiceRegistry;
import org.apache.uima.ducc.container.sd.ServiceRegistry_impl;
import org.apache.uima.ducc.transport.configuration.jp.JobProcessComponent;

public class DuccHttpClient {
    private static final String REGISTERED_DRIVER = "ducc.deploy.registered.driver";
    private static final String SERVICE_TYPE = "ducc.deploy.service.type";
    private DuccLogger logger = new DuccLogger(DuccHttpClient.class);
    private JobProcessComponent duccComponent;
    private BasicConnPool connPool = null;
    private HttpHost host = null;
    private NodeIdentity nodeIdentity;
    private String pid = "";
    private ReentrantLock lock = new ReentrantLock();
    private HttpClient httpClient = null;
    private String jdUrl;
    private PoolingHttpClientConnectionManager cMgr = null;
    private int ClientMaxConnections = 0;
    private int ClientMaxConnectionsPerRoute = 0;
    private int ClientMaxConnectionsPerHostPort = 0;
    private ServiceRegistry registry = null;
    private String taskServerName;

    public DuccHttpClient(JobProcessComponent duccComponent) {
        this.duccComponent = duccComponent;
    }

    public void setScaleout(int scaleout) {
        this.connPool.setMaxTotal(scaleout);
        this.connPool.setDefaultMaxPerRoute(scaleout);
        this.connPool.setMaxPerRoute((Object)this.host, scaleout);
    }

    public String getJdUrl() {
        if (this.registry == null) {
            return this.jdUrl;
        }
        String address = this.registry.fetch(this.taskServerName);
        this.logger.info("getJdUrl", null, new Object[]{"Registry entry for", this.taskServerName, "is", address});
        return address;
    }

    public void initialize(String jdUrl) throws Exception {
        if (jdUrl == null || jdUrl.isEmpty()) {
            String[] parts;
            String registryAddr = null;
            String registryUri = System.getProperty(REGISTERED_DRIVER);
            if (registryUri != null && (parts = registryUri.split("\\?", 2)).length == 2) {
                registryAddr = parts[0];
                this.taskServerName = parts[1];
            }
            if (registryAddr == null) {
                throw new RuntimeException("Missing or invalid system property ducc.deploy.registered.driver: " + registryUri);
            }
            this.registry = ServiceRegistry_impl.getInstance();
            if (!this.registry.initialize(registryAddr)) {
                throw new RuntimeException("Failed to connect to registry at " + registryAddr + " to locate server " + this.taskServerName);
            }
            this.logger.info("initialize", null, new Object[]{"Using registry at", registryAddr, "to locate server", this.taskServerName});
            jdUrl = this.getJdUrl();
        }
        this.jdUrl = jdUrl;
        this.logger.info("initialize", null, new Object[]{"Found jdUrl =", jdUrl});
        int pos = jdUrl.indexOf("//");
        int ipEndPos = jdUrl.indexOf(":", pos);
        String jdIP = jdUrl.substring(pos + 2, ipEndPos);
        int portEndPos = jdUrl.indexOf("/", ipEndPos);
        String jdScheme = jdUrl.substring(portEndPos + 1);
        String jdPort = jdUrl.substring(ipEndPos + 1, portEndPos);
        this.pid = this.getProcessIP("N/A");
        this.nodeIdentity = new NodeIdentity();
        this.cMgr = new PoolingHttpClientConnectionManager();
        if (this.ClientMaxConnections > 0) {
            this.cMgr.setMaxTotal(this.ClientMaxConnections);
        }
        if (this.ClientMaxConnectionsPerRoute > 0) {
            this.cMgr.setDefaultMaxPerRoute(this.ClientMaxConnectionsPerRoute);
        }
        HttpHost httpHost = new HttpHost(jdIP, Integer.valueOf(jdPort).intValue(), jdScheme);
        if (this.ClientMaxConnectionsPerHostPort > 0) {
            this.cMgr.setMaxPerRoute(new HttpRoute(httpHost), this.ClientMaxConnectionsPerHostPort);
        }
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.cMgr).build();
    }

    public void stop() throws Exception {
        if (this.cMgr != null) {
            this.cMgr.shutdown();
        }
    }

    public void close() {
    }

    private String getProcessIP(String fallback) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pos = name.indexOf(64);
        if (pos < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(name.substring(0, pos)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    private String getIP() {
        String ip = this.nodeIdentity.getIp();
        if (System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value()) != null) {
            ip = System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value());
        }
        return ip;
    }

    private String getNodeName() {
        String nn = this.nodeIdentity.getName();
        if (System.getenv(IDuccUser.EnvironmentVariable.DUCC_NODENAME.value()) != null) {
            nn = System.getenv(IDuccUser.EnvironmentVariable.DUCC_NODENAME.value());
        }
        return nn;
    }

    private String getProcessName() {
        String pn = System.getProperty(SERVICE_TYPE);
        if (pn == null) {
            pn = System.getenv(IDuccUser.EnvironmentVariable.DUCC_ID_PROCESS.value());
        }
        return pn;
    }

    private void addCommonHeaders(IMetaCasTransaction transaction) {
        String location = "addCommonHeaders";
        transaction.setRequesterAddress(this.getIP());
        transaction.setRequesterNodeName(this.getNodeName());
        transaction.setRequesterProcessName(this.getProcessName());
        transaction.setRequesterProcessId(Integer.valueOf(this.pid).intValue());
        transaction.setRequesterThreadId((int)Thread.currentThread().getId());
        this.logger.trace(location, null, new Object[]{"ip:" + transaction.getRequesterAddress()});
        this.logger.trace(location, null, new Object[]{"nodeName:" + transaction.getRequesterNodeName()});
        this.logger.trace(location, null, new Object[]{"processName:" + transaction.getRequesterProcessName()});
        this.logger.trace(location, null, new Object[]{"processId:" + transaction.getRequesterProcessId()});
        this.logger.trace(location, null, new Object[]{"threadId:" + transaction.getRequesterThreadId()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonHeaders(HttpPost method) {
        Class<DuccHttpClient> clazz = DuccHttpClient.class;
        synchronized (DuccHttpClient.class) {
            method.setHeader("IP", this.getIP());
            method.setHeader("Hostname", this.getNodeName());
            method.setHeader("ThreadID", String.valueOf(Thread.currentThread().getId()));
            method.setHeader("PID", this.pid);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetaCasTransaction execute(IMetaCasTransaction transaction, HttpPost postMethod) throws Exception {
        MetaCasTransaction reply;
        Exception lastError;
        block16: {
            lastError = null;
            reply = null;
            this.addCommonHeaders(transaction);
            transaction.setDirection(IMetaCasTransaction.Direction.Request);
            try {
                Object o;
                String body = XStreamUtils.marshall((Object)transaction);
                StringEntity e = new StringEntity(body, ContentType.APPLICATION_XML);
                postMethod.setEntity((HttpEntity)e);
                this.addCommonHeaders(postMethod);
                this.logger.debug("execute", null, new Object[]{"calling httpClient.executeMethod()"});
                HttpResponse response = null;
                try {
                    response = this.httpClient.execute((HttpUriRequest)postMethod);
                }
                catch (HttpHostConnectException ex) {
                    response = this.retryUntilSuccessfull(transaction, postMethod);
                }
                catch (NoHttpResponseException ex) {
                    response = this.retryUntilSuccessfull(transaction, postMethod);
                }
                if (!this.duccComponent.isRunning()) {
                    IMetaCasTransaction ex = null;
                    return ex;
                }
                this.logger.debug("execute", null, new Object[]{"httpClient.executeMethod() returned"});
                HttpEntity entity = response.getEntity();
                String content = EntityUtils.toString((HttpEntity)entity);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() != 200) {
                    this.logger.error("execute", null, new Object[]{"Unable to Communicate with JD - Error:" + statusLine});
                    this.logger.error("execute", null, new Object[]{"Content causing error:" + content});
                    throw new RuntimeException("JP Http Client Unable to Communicate with JD - Error:" + statusLine);
                }
                this.logger.debug("execute", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " JD Reply Status:" + statusLine});
                this.logger.debug("execute", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " Recv'd:" + content});
                try {
                    o = XStreamUtils.unmarshall((String)content);
                }
                catch (Exception ex) {
                    this.logger.error("execute", null, new Object[]{"Thread:" + Thread.currentThread().getId() + " ERRR::Content causing error:" + content, ex});
                    throw ex;
                }
                if (o instanceof IMetaCasTransaction) {
                    reply = (MetaCasTransaction)o;
                    break block16;
                }
                throw new InvalidClassException("Expected IMetaCasTransaction - Instead Received " + o.getClass().getName());
            }
            catch (Exception t) {
                lastError = t;
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        if (reply != null) {
            return reply;
        }
        if (lastError != null) {
            throw lastError;
        }
        throw new RuntimeException("Shouldn't happen ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse retryUntilSuccessfull(IMetaCasTransaction transaction, HttpPost postMethod) throws Exception {
        HttpResponse response = null;
        this.logger.error("retryUntilSucessfull", null, new Object[]{"Connection Lost to", postMethod.getURI(), "- Retrying Until Successful ..."});
        this.lock.lock();
        while (this.duccComponent.isRunning()) {
            try {
                this.jdUrl = this.getJdUrl();
                URI jdUri = new URI(this.jdUrl);
                postMethod.setURI(jdUri);
                this.logger.warn("retryUntilSucessfull", null, new Object[]{"Trying to connect to", this.jdUrl});
                response = this.httpClient.execute((HttpUriRequest)postMethod);
                this.logger.warn("retryUntilSucessfull", null, new Object[]{"Recovered Connection"});
                if (!this.lock.isHeldByCurrentThread()) break;
                this.lock.unlock();
                break;
            }
            catch (HttpHostConnectException exx) {
                HttpPost httpPost = postMethod;
                synchronized (httpPost) {
                    this.logger.warn("retryUntilSucessfull", null, new Object[]{"Connection failed - retry in", this.duccComponent.getThreadSleepTime() / 1000, "secs"});
                    postMethod.wait(this.duccComponent.getThreadSleepTime());
                }
            }
        }
        return response;
    }

    public static void main(String[] args) {
        try {
            HttpPost postMethod = new HttpPost(args[0]);
            DuccHttpClient client = new DuccHttpClient(null);
            client.initialize(args[0]);
            int minor = 0;
            MetaCasTransaction transaction = new MetaCasTransaction();
            AtomicInteger seq = new AtomicInteger(0);
            TransactionId tid = new TransactionId(seq.incrementAndGet(), minor);
            transaction.setTransactionId(tid);
            transaction.setType(IMetaCasTransaction.Type.Get);
            transaction = client.execute((IMetaCasTransaction)transaction, postMethod);
            if (transaction.getMetaCas() != null) {
                transaction.setType(IMetaCasTransaction.Type.Ack);
                tid = new TransactionId(seq.incrementAndGet(), minor++);
                transaction.setTransactionId(tid);
                transaction = client.execute((IMetaCasTransaction)transaction, postMethod);
            }
            transaction.setType(IMetaCasTransaction.Type.End);
            tid = new TransactionId(seq.incrementAndGet(), minor++);
            transaction.setTransactionId(tid);
            PerformanceMetrics metricsWrapper = new PerformanceMetrics();
            metricsWrapper.set(Arrays.asList(new Properties()));
            transaction.getMetaCas().setPerformanceMetrics((IPerformanceMetrics)metricsWrapper);
            transaction = client.execute((IMetaCasTransaction)transaction, postMethod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

