/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jd;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.blacklist.JobProcessBlacklist;
import org.apache.uima.ducc.container.jd.mh.IMessageHandler;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.IOperatingInfo;
import org.apache.uima.ducc.container.jd.mh.iface.IProcessInfo;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.impl.ProcessInfo;
import org.apache.uima.ducc.transport.configuration.jd.JobDriverComponent;
import org.apache.uima.ducc.transport.dispatcher.DuccEventHttpDispatcher;
import org.apache.uima.ducc.transport.dispatcher.IDuccEventDispatcher;
import org.apache.uima.ducc.transport.event.JdReplyEvent;
import org.apache.uima.ducc.transport.event.JdRequestEvent;
import org.apache.uima.ducc.transport.event.common.DuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.jd.JobDriverReport;

public class JobDriverStateExchanger
extends Thread {
    private JobProcessBlacklist jobProcessBlacklist = JobProcessBlacklist.getInstance();
    private static final DuccLogger logger = DuccLoggerComponents.getJdOut((String)JobDriverStateExchanger.class.getName());
    private static final DuccId jobid = null;
    private JobDriverComponent jdc = null;
    private IDuccEventDispatcher dispatcher;
    private String orchestrator = "orchestrator";
    private long minMillis = 1000L;
    private long wakeUpMillis;
    private long sleepTime = this.wakeUpMillis = 15000L;
    private long lastTime = System.currentTimeMillis();
    private boolean die = false;
    private boolean communications_ok = true;
    private AtomicInteger getStateReqNo = new AtomicInteger(0);
    private IDuccProcessMap dpMap = new DuccProcessMap();

    public static IDuccEventDispatcher create(Object specs) throws Exception {
        DuccEventHttpDispatcher retVal = null;
        String targetUrl = (String)specs;
        retVal = new DuccEventHttpDispatcher(targetUrl);
        return retVal;
    }

    public JobDriverStateExchanger() {
        this.initialize();
    }

    private void initialize() {
        this.initializeTarget();
        this.initializeThread();
    }

    private void initializeThread() {
        String location = "initializeThread";
        String key = "ducc.orchestrator.state.publish.rate";
        String exchange_rate = DuccPropertiesResolver.getInstance().getProperty(key);
        if (exchange_rate != null) {
            try {
                long rate = Long.parseLong(exchange_rate);
                if (rate < this.minMillis) {
                    logger.error(location, jobid, new Object[]{key + " < minimum of " + this.minMillis});
                } else {
                    this.sleepTime = this.wakeUpMillis = rate;
                }
            }
            catch (Throwable t) {
                logger.error(location, jobid, t, new Object[0]);
            }
        }
        logger.debug(location, jobid, new Object[]{"rate:" + this.wakeUpMillis});
    }

    private void initializeTarget() {
        String location = "initializeTarget";
        try {
            String targetUrl = this.getTargetUrl();
            logger.info(location, jobid, new Object[]{targetUrl});
            this.dispatcher = JobDriverStateExchanger.create(targetUrl);
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private String getServer() {
        return this.orchestrator;
    }

    private String getTargetUrl() {
        String targetUrl = null;
        String server = this.getServer();
        String host = DuccPropertiesResolver.get((String)("ducc." + server + ".http.node"));
        String port = DuccPropertiesResolver.get((String)("ducc." + server + ".http.port"));
        if (host == null || port == null) {
            String message = "ducc." + server + ".http.node and/or .port not set in ducc.properties";
            throw new IllegalStateException(message);
        }
        targetUrl = "http://" + host + ":" + port + "/" + server.substring(0, 2);
        return targetUrl;
    }

    public void setJobDriverComponent(JobDriverComponent value) {
        this.jdc = value;
    }

    private void setProcessMap(IDuccProcessMap value) {
        this.dpMap = new DuccProcessMap(value);
    }

    private JdReplyEvent request(JdRequestEvent jdRequestEvent) throws Exception {
        String location = "request";
        JdReplyEvent jdReplyEvent = null;
        try {
            jdReplyEvent = (JdReplyEvent)this.dispatcher.dispatchAndWaitForDuccReply(jdRequestEvent);
        }
        catch (Exception e) {
            logger.trace(location, jobid, (Throwable)e, new Object[0]);
            throw e;
        }
        return jdReplyEvent;
    }

    private JdRequestEvent getJdRequestEvent() {
        String location = "getJdRequestEvent";
        JdRequestEvent jdRequestEvent = new JdRequestEvent();
        try {
            IMessageHandler mh = JobDriver.getInstance().getMessageHandler();
            IOperatingInfo oi = mh.handleGetOperatingInfo();
            JobDriverReport driverStatusReport = new JobDriverReport(oi, this.dpMap);
            driverStatusReport.setNode(this.jdc.getNode());
            driverStatusReport.setPort(this.jdc.getPort());
            driverStatusReport.setJmxUrl(this.jdc.getJmxUrl());
            jdRequestEvent.setDriverStatusReport(driverStatusReport);
            logger.debug(location, jobid, new Object[]{"reqNo: " + this.getStateReqNo.incrementAndGet()});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return jdRequestEvent;
    }

    private void abortIfTold(JdReplyEvent jdReplyEvent) {
        String killDriverReason;
        String location = "abortIfTold";
        if (jdReplyEvent != null && (killDriverReason = jdReplyEvent.getKillDriverReason()) != null) {
            int code = 255;
            StringBuffer sb = new StringBuffer();
            sb.append("System Exit");
            sb.append(" ");
            sb.append("code=" + code);
            sb.append(" ");
            sb.append("reason=" + killDriverReason);
            logger.warn(location, jobid, new Object[]{sb.toString()});
            System.exit(code);
        }
    }

    private void handle(JdReplyEvent jdReplyEvent) {
        String location = "handle";
        try {
            this.abortIfTold(jdReplyEvent);
            JobDriver jd = JobDriver.getInstance();
            IMessageHandler mh = jd.getMessageHandler();
            this.setProcessMap(jdReplyEvent.getProcessMap());
            IWorkItemStateKeeper wisk = JobDriver.getInstance().getWorkItemStateKeeper();
            wisk.persist();
            IDuccProcessMap pMap = jdReplyEvent.getProcessMap();
            block10: for (Map.Entry entry : pMap.entrySet()) {
                RemoteWorkerProcess rwp;
                IDuccProcess p = (IDuccProcess)entry.getValue();
                IProcessState.ProcessState state = p.getProcessState();
                NodeIdentity ni = p.getNodeIdentity();
                String node = ni.getName();
                String ip = ni.getIp();
                String pidName = p.getDuccId().getFriendly() + "";
                String pid = p.getPID();
                StringBuffer sb = new StringBuffer();
                sb.append("node: " + node);
                sb.append(" ");
                sb.append("ip: " + ip);
                sb.append(" ");
                sb.append("pid: " + pid);
                sb.append(" ");
                sb.append("state:" + state.name());
                sb.append(" ");
                String reasonStopped = p.getReasonForStoppingProcess();
                if (reasonStopped != null) {
                    sb.append("reason[stopped]:" + reasonStopped);
                    sb.append(" ");
                }
                String reasonDeallocated = null;
                IResourceState.ProcessDeallocationType processDeallocationType = p.getProcessDeallocationType();
                if (processDeallocationType != null) {
                    switch (processDeallocationType) {
                        case Undefined: {
                            break;
                        }
                        default: {
                            reasonDeallocated = processDeallocationType.name();
                            sb.append("reason[deallocated]:" + reasonDeallocated);
                            sb.append(" ");
                        }
                    }
                }
                if (this.jobProcessBlacklist.includes((IRemoteWorkerProcess)(rwp = RemoteWorkerProcess.factory((String)node, (String)ip, (String)pidName, (String)pid)))) {
                    logger.trace(location, jobid, new Object[]{sb.toString()});
                    continue;
                }
                logger.debug(location, jobid, new Object[]{sb.toString()});
                switch (state) {
                    case Started: 
                    case Starting: 
                    case Initializing: 
                    case Running: {
                        continue block10;
                    }
                }
                try {
                    if (pid == null) continue;
                    int iPid = Integer.parseInt(pid.trim());
                    ProcessInfo processInfo = new ProcessInfo(node, ip, pidName, iPid, reasonStopped, reasonDeallocated);
                    if (p.isFailedInitialization()) {
                        mh.handleProcessFailedInitialization((IProcessInfo)processInfo);
                        continue;
                    }
                    if (p.isPreempted()) {
                        mh.handleProcessPreempt((IProcessInfo)processInfo);
                        continue;
                    }
                    if (p.isVolunteered()) {
                        mh.handleProcessVolunteered((IProcessInfo)processInfo);
                        continue;
                    }
                    mh.handleProcessDown((IProcessInfo)processInfo);
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private boolean isTime() {
        String location = "isTime";
        boolean retVal = true;
        try {
            long currTime = System.currentTimeMillis();
            long elapsedTime = currTime - this.lastTime;
            logger.debug(location, jobid, new Object[]{"elapsedTime: " + elapsedTime});
            if (elapsedTime < this.wakeUpMillis) {
                retVal = false;
                this.sleepTime = this.wakeUpMillis - elapsedTime;
            } else {
                this.lastTime = currTime;
                this.sleepTime = this.wakeUpMillis;
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private void exchange() {
        block3: {
            String location = "exchange";
            try {
                JdRequestEvent jdRequestEvent = this.getJdRequestEvent();
                JdReplyEvent jdReplyEvent = this.request(jdRequestEvent);
                this.handle(jdReplyEvent);
                if (!this.communications_ok) {
                    logger.warn(location, jobid, new Object[]{"Status reporting resumed."});
                    this.communications_ok = true;
                }
            }
            catch (Exception e) {
                if (!this.communications_ok) break block3;
                logger.warn(location, jobid, new Object[]{"Status reporting stopped.  Condition may be temporary."});
                this.communications_ok = false;
            }
        }
    }

    private void wait_a_while() {
        String location = "wait_a_while";
        try {
            logger.debug(location, jobid, new Object[]{"sleep " + this.sleepTime / 1000L});
            Thread.sleep(this.sleepTime);
        }
        catch (Exception e) {
            logger.trace(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void run() {
        String location = "run";
        logger.trace(location, jobid, new Object[]{"begin"});
        while (!this.die) {
            if (this.isTime()) {
                this.exchange();
            }
            this.wait_a_while();
        }
        logger.trace(location, jobid, new Object[]{"end"});
    }
}

