/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jd;

import java.io.BufferedReader;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.container.jd.mh.MessageHandler;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.container.net.impl.MetaCasTransaction;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.configuration.jd.JobDriverComponent;
import org.apache.uima.ducc.transport.configuration.jd.JobDriverEventListener;
import org.apache.uima.ducc.transport.configuration.jd.iface.IJobDriverComponent;
import org.apache.uima.ducc.transport.dispatcher.ProcessStateDispatcher;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class JobDriverConfiguration {
    private static DuccLogger logger = DuccLoggerComponents.getJdOut((String)JobDriverConfiguration.class.getName());
    private static DuccId jobid = null;
    private static int port = 0;
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration jobDriverTransport;

    public JobDriverEventListener jobDriverDelegateListener(IJobDriverComponent jdc) {
        JobDriverEventListener jdel = new JobDriverEventListener(jdc);
        return jdel;
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String endpoint, final JobDriverEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                this.from(endpoint).bean((Object)delegate);
            }
        };
    }

    public Server createServer(int port, String app, IJobDriverComponent jdc) throws Exception {
        int portHttp = port;
        QueuedThreadPool threadPool = new QueuedThreadPool();
        int cores = Runtime.getRuntime().availableProcessors();
        if (this.common.jettyMaxThreads != null) {
            try {
                int maxThreads = Integer.parseInt(this.common.jettyMaxThreads.trim());
                if (maxThreads < threadPool.getMinThreads()) {
                    logger.warn("JobDriver", jobid, new Object[]{"Invalid value for jetty MaxThreads(" + maxThreads + ") - it should be greater or equal to " + threadPool.getMinThreads() + ". Defaulting to jettyMaxThreads=" + threadPool.getMaxThreads()});
                } else {
                    threadPool.setMaxThreads(maxThreads);
                }
            }
            catch (NumberFormatException e) {
                logger.warn("JobDriver", jobid, new Object[]{"Invalid value for jetty MaxThreads - check ducc.properties - defaulting to " + threadPool.getMaxThreads()});
            }
        }
        if (cores > threadPool.getMaxThreads()) {
            logger.warn("JobDriver", jobid, new Object[]{"Invalid value for jetty MaxThreads(" + threadPool.getMaxThreads() + ") - it should be greater or equal to " + cores + ". Defaulting to Number of CPU Cores=" + cores});
            threadPool.setMaxThreads(cores);
        }
        Server server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(portHttp);
        server.setConnectors(new Connector[]{connector});
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new JDServlet(jdc)), app);
        logger.info("JobDriver", jobid, new Object[]{"Jetty Configuration - Port: " + port + " Threads: " + threadPool.getMinThreads() + "-" + threadPool.getMaxThreads()});
        return server;
    }

    @Bean
    public JobDriverComponent jobDriver() throws Exception {
        String location = "jobDriver";
        try {
            ProcessStateDispatcher stateNotifier = new ProcessStateDispatcher();
            this.initializing(stateNotifier);
            JobDriverComponent jdc = new JobDriverComponent("JobDriver", this.common.camelContext(), this);
            JobDriverEventListener delegateListener = this.jobDriverDelegateListener(jdc);
            delegateListener.setDuccEventDispatcher(this.jobDriverTransport.duccEventDispatcher(this.common.orchestratorStateUpdateEndpoint, jdc.getContext()));
            try {
                NodeIdentity nodeIdentity = new NodeIdentity();
                jdc.setNode(nodeIdentity.getIp());
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
            port = Utils.findFreePort();
            jdc.setPort(port);
            String jdUniqueId = "/jdApp";
            Server server = this.createServer(port, jdUniqueId, jdc);
            server.start();
            logger.info(location, jobid, new Object[]{"Jetty Started - Port: " + port});
            this.running(stateNotifier);
            return jdc;
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            int code = 55;
            logger.warn(location, jobid, new Object[]{"halt code=" + code});
            Runtime.getRuntime().halt(code);
            throw e;
        }
    }

    private void initializing(ProcessStateDispatcher stateNotifier) throws Exception {
        String location = "initializing";
        String args = "";
        stateNotifier.sendStateUpdate(IProcessState.ProcessState.Initializing.name());
        logger.info(location, jobid, new Object[]{args});
    }

    private void running(ProcessStateDispatcher stateNotifier) throws Exception {
        String location = "running";
        String args = "";
        stateNotifier.sendStateUpdate(IProcessState.ProcessState.Running.name());
        logger.info(location, jobid, new Object[]{args});
    }

    public class JDServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private IJobDriverComponent jdc;

        public JDServlet(IJobDriverComponent jdc) {
            this.jdc = jdc;
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            try {
                String line;
                long post_stime = System.nanoTime();
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                String content = sb.toString().trim();
                logger.debug("doPost", jobid, new Object[]{"Http Request Body:::" + String.valueOf(content)});
                IMetaCasTransaction imt = null;
                imt = (IMetaCasTransaction)XStreamUtils.unmarshall((String)content);
                MessageHandler.accumulateTimes((String)"Unmarshall", (long)post_stime);
                this.jdc.handleJpRequest(imt);
                long marshall_stime = System.nanoTime();
                imt.setDirection(IMetaCasTransaction.Direction.Response);
                response.setStatus(200);
                response.setHeader("content-type", "text/xml");
                String body = XStreamUtils.marshall((Object)imt);
                response.getWriter().write(body);
                MessageHandler.accumulateTimes((String)"Marshall", (long)marshall_stime);
                MessageHandler.accumulateTimes((String)"Post", (long)post_stime);
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
        }
    }

    public static class JobDriverProcessor
    implements Processor {
        private IJobDriverComponent jdc;

        private JobDriverProcessor(IJobDriverComponent jdc) {
            this.jdc = jdc;
        }

        public void process(Exchange exchange) throws Exception {
            IMetaCasTransaction imt = (IMetaCasTransaction)exchange.getIn().getBody(MetaCasTransaction.class);
            this.jdc.handleJpRequest(imt);
            imt.setDirection(IMetaCasTransaction.Direction.Response);
            exchange.getOut().setHeader("content-type", (Object)"text/xml");
            exchange.getOut().setBody((Object)imt);
        }
    }
}

