/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jd;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.cas.CasManagerStats;
import org.apache.uima.ducc.container.jd.mh.IMessageHandler;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.transport.configuration.jd.JobDriverConfiguration;
import org.apache.uima.ducc.transport.configuration.jd.JobDriverStateExchanger;
import org.apache.uima.ducc.transport.configuration.jd.iface.IJobDriverComponent;

public class JobDriverComponent
extends AbstractDuccComponent
implements IJobDriverComponent {
    private static DuccLogger logger = DuccLoggerComponents.getJdOut((String)JobDriverComponent.class.getName());
    private static DuccId jobid = null;
    private static String node = null;
    private static int port = 0;
    private static JobDriverStateExchanger jdse = null;
    private JobDriverConfiguration configuration;

    public JobDriverComponent(String componentName, CamelContext ctx, JobDriverConfiguration jdc) {
        super(componentName, ctx);
        this.configuration = jdc;
        this.verifySystemProperties();
        jdse = new JobDriverStateExchanger();
        jdse.setJobDriverComponent(this);
        jdse.start();
        this.createInstance();
    }

    private void verifySystemProperties() {
        String location = "verifySystemProperties";
        Properties properties = System.getProperties();
        ArrayList<String> missing = new ArrayList<String>();
        for (FlagsHelper.Name name : FlagsHelper.Name.values()) {
            String key = name.pname();
            if (properties.containsKey(key)) {
                String value = properties.getProperty(key);
                String text = key + "=" + value;
                logger.info(location, jobid, new Object[]{text});
                continue;
            }
            if (!name.isRequiredJd()) continue;
            missing.add(name.name());
            String text = key + " is missing.";
            logger.error(location, jobid, new Object[]{text});
        }
        if (missing.size() > 0) {
            throw new RuntimeException("Missing System Properties: " + missing.toString());
        }
    }

    private void createInstance() {
        String location = "createInstance";
        try {
            JobDriver jobDriver = JobDriver.getNewInstance();
            CasManager casManager = jobDriver.getCasManager();
            CasManagerStats casManagerStats = casManager.getCasManagerStats();
            int total = casManagerStats.getCrTotal();
            logger.info(location, jobid, new Object[]{"total: " + total});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public JobDriverConfiguration getJobDriverConfiguration() {
        return this.configuration;
    }

    public String getJmxUrl() {
        return this.getProcessJmxUrl();
    }

    public String getNode() {
        return node;
    }

    public void setNode(String value) {
        node = value;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int value) {
        port = value;
    }

    public DuccLogger getLogger() {
        return logger;
    }

    @Override
    public void handleJpRequest(IMetaCasTransaction metaCasTransaction) throws Exception {
        String location = "handleJpRequest";
        try {
            IMessageHandler mh = JobDriver.getInstance().getMessageHandler();
            mh.handleMetaCasTransation(metaCasTransaction);
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            throw e;
        }
    }
}

