/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.cmdline;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.transport.cmdline.ACommandLine;

public class JavaCommandLine
extends ACommandLine {
    private static final long serialVersionUID = 7377333447388157462L;
    private String className;
    private String classpath;
    protected List<String> options = new ArrayList<String>();

    public JavaCommandLine(String executable) {
        super(executable);
    }

    public JavaCommandLine copy() {
        JavaCommandLine jcl = new JavaCommandLine(this.executable);
        jcl.className = this.className;
        jcl.classpath = this.classpath;
        jcl.logDirectory = this.logDirectory;
        jcl.workingDirectory = this.workingDirectory;
        jcl.args = this.args;
        jcl.environment = this.environment;
        jcl.options = new ArrayList<String>(this.getOptions());
        return jcl;
    }

    @Override
    public void addOption(String option) {
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }

    @Override
    public String[] getCommandLine() {
        String[] result;
        String[] os = new String[this.options.size()];
        if (this.args == null || this.args.size() == 0) {
            result = this.concatAllArrays(this.options.toArray(os), new String[][]{{"-classpath", this.classpath, this.className}});
        } else {
            String[] arguments = new String[this.args.size()];
            result = this.concatAllArrays(this.options.toArray(os), {"-classpath", this.classpath, this.className}, this.args.toArray(arguments));
        }
        return result;
    }

    public String getCommand() {
        String retVal = "";
        for (String part : this.getCommandLine()) {
            retVal = retVal + " " + part;
        }
        return retVal;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void prependToClasspath(String cp) {
        if (!cp.trim().endsWith(System.getProperty("path.separator"))) {
            cp = cp.trim() + System.getProperty("path.separator");
        }
        this.classpath = cp + this.classpath;
    }

    public static void main(String[] args) {
        try {
            JavaCommandLine cmdLine = new JavaCommandLine("/share/jdk1.6/bin/java");
            cmdLine.addOption("-Xmx=200M");
            cmdLine.addOption("-Xms=100M");
            cmdLine.addOption("-DUIMA_HOME=$HOME/uima");
            cmdLine.setClasspath("$UIMA_HOME/lib/*;$UIMA_HOME/lib/optional/*");
            cmdLine.setClassName("org.apache.uima.ducc.agent.deploy.ManagedUimaService");
            cmdLine.addArgument("/tmp/UimaASDeploymentDescriptor.xml");
            for (String part : cmdLine.getCommandLine()) {
                System.out.println("-- " + part);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

