/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport;

import java.util.List;
import java.util.Properties;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.jms.pool.PooledConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.uima.ducc.common.authentication.BrokerCredentials;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@Scope(value="prototype")
public class DuccTransportConfiguration {
    @Value(value="#{ systemProperties['ducc.broker.url'] }")
    String brokerUrl;
    private static ActiveMQComponent duccAMQComponent = null;
    @Value(value="#{ systemProperties['ducc.broker.credentials.file'] }")
    String brokerCredentialsFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJMSTransport(DuccLogger logger, String endpoint, CamelContext context) throws Exception {
        BrokerCredentials.Credentials credentials = null;
        Class<ActiveMQComponent> clazz = ActiveMQComponent.class;
        synchronized (ActiveMQComponent.class) {
            if (duccAMQComponent == null) {
                String path;
                duccAMQComponent = new ActiveMQComponent(context);
                duccAMQComponent.setBrokerURL(this.brokerUrl);
                logger.info("configureJMSTransport", null, new Object[]{"Broker URL: " + this.brokerUrl});
                if (this.brokerCredentialsFile != null && (credentials = BrokerCredentials.get((String)(path = Utils.resolvePlaceholderIfExists((String)this.brokerCredentialsFile, (Properties)System.getProperties())))).getUsername() != null && credentials.getPassword() != null) {
                    duccAMQComponent.setUserName(credentials.getUsername());
                    duccAMQComponent.setPassword(credentials.getPassword());
                    System.out.println(">>>>>>>>>>>>>>> Running with AMQ Credentials");
                    logger.info("configureJMSTransport", null, new Object[]{">>>>>>>>>>>>>>> Running with AMQ Credentials"});
                }
                List cs = context.getComponentNames();
                for (String s : cs) {
                    logger.info("configureJMSTransport", null, new Object[]{"Componennt:" + s});
                }
                context.addComponent("activemq", (Component)duccAMQComponent);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.whiteListAllPkgs();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJMSTransport(String endpoint, CamelContext context) throws Exception {
        BrokerCredentials.Credentials credentials = null;
        Class<ActiveMQComponent> clazz = ActiveMQComponent.class;
        synchronized (ActiveMQComponent.class) {
            if (duccAMQComponent == null) {
                String path;
                duccAMQComponent = new ActiveMQComponent(context);
                duccAMQComponent.setBrokerURL(this.brokerUrl);
                if (this.brokerCredentialsFile != null && (credentials = BrokerCredentials.get((String)(path = Utils.resolvePlaceholderIfExists((String)this.brokerCredentialsFile, (Properties)System.getProperties())))).getUsername() != null && credentials.getPassword() != null) {
                    duccAMQComponent.setUserName(credentials.getUsername());
                    duccAMQComponent.setPassword(credentials.getPassword());
                    System.out.println(">>>>>>>>>>>>>>> Running with AMQ Credentials");
                }
                context.addComponent("activemq", (Component)duccAMQComponent);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.whiteListAllPkgs();
            return;
        }
    }

    public DuccEventDispatcher duccEventDispatcher(DuccLogger logger, String requestEndpoint, CamelContext context) throws Exception {
        this.configureJMSTransport(logger, requestEndpoint, context);
        return new DuccEventDispatcher(context, requestEndpoint);
    }

    public DuccEventDispatcher duccEventDispatcher(String requestEndpoint, CamelContext context) throws Exception {
        this.configureJMSTransport(requestEndpoint, context);
        return new DuccEventDispatcher(context, requestEndpoint);
    }

    private void whiteListAllPkgs() {
        System.out.println("Getting AMQ Factory");
        PooledConnectionFactory amqf = (PooledConnectionFactory)duccAMQComponent.getConfiguration().getConnectionFactory();
        ActiveMQConnectionFactory f = (ActiveMQConnectionFactory)amqf.getConnectionFactory();
        f.setTrustAllPackages(true);
        System.out.println("White Listed Packages for AMQ Exchanges");
    }
}

