/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.uima.dd.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.ducc.common.uima.UimaUtils;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.transport.event.common.IDuccUimaAggregate;
import org.apache.uima.ducc.transport.event.common.IDuccUimaAggregateComponent;
import org.apache.uima.ducc.transport.event.common.IDuccUimaDeployableConfiguration;
import org.apache.uima.ducc.transport.event.common.IDuccUimaDeploymentDescriptor;
import org.apache.uima.resourceSpecifier.factory.UimaASPrimitiveDeploymentDescriptor;
import org.apache.uima.util.XMLInputSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DeploymentDescriptorGenerator {
    private DuccLogger logger;
    private String duccComponentName;
    private String userLogDir;

    public DeploymentDescriptorGenerator(String componentName, DuccLogger logger, String userLogDir) {
        this.logger = logger;
        this.duccComponentName = componentName;
        this.userLogDir = userLogDir;
    }

    public String generate(String serializedDeployableConfiguration, String jobId) throws Exception {
        IDuccUimaDeployableConfiguration deployableConfiguration = (IDuccUimaDeployableConfiguration)XStreamUtils.unmarshall((String)serializedDeployableConfiguration);
        return this.generate(deployableConfiguration, jobId);
    }

    public String getComponentName() {
        return this.duccComponentName;
    }

    public String generate(IDuccUimaDeployableConfiguration configuration, String jobId) throws Exception {
        String methodName = "generate";
        if (configuration instanceof IDuccUimaDeploymentDescriptor) {
            this.logger.debug(methodName, null, new Object[]{"DUCC Service Wrapper Generates Deployment Descriptor Based on DD Provided by a User:" + ((IDuccUimaDeploymentDescriptor)configuration).getDeploymentDescriptorPath()});
            return this.generateDeploymentDescriptor((IDuccUimaDeploymentDescriptor)configuration, jobId);
        }
        if (configuration instanceof IDuccUimaAggregate) {
            this.logger.debug(methodName, null, new Object[]{"DUCC Service Wrapper Generating UIMA AS Deployment Descriptor"});
            return this.generateDeploymentDescriptor((IDuccUimaAggregate)configuration, jobId);
        }
        throw new Exception("Invalid IDuccUimaDeployableConfiguration. Expected IDuccUimaAggregate or IDuccUimaDeploymentDescriptor, but received " + configuration.getClass().getName());
    }

    private String writeDDFile(String content, String jobId) throws Exception {
        File dir = new File(this.userLogDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        BufferedWriter out = null;
        try {
            File file = new File(dir, jobId + "-uima-as-dd-" + Utils.getPID() + ".xml");
            out = new BufferedWriter(new FileWriter(file));
            out.write(content);
            out.flush();
            String string = file.getAbsolutePath();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String generateDeploymentDescriptor(IDuccUimaDeploymentDescriptor dd, String jobId) throws Exception {
        Document doc = this.parse(dd.getDeploymentDescriptorPath());
        NodeList nodes = doc.getElementsByTagName("inputQueue");
        if (nodes.getLength() <= 0) {
            throw new Exception("Invalid DD-" + dd.getDeploymentDescriptorPath() + ". Missing required element <inputQueue ...");
        }
        Element element = (Element)nodes.item(0);
        element.setAttribute("endpoint", "ducc.jd.queue." + jobId);
        element.setAttribute("brokerURL", System.getProperty("ducc.broker.url"));
        return this.writeDDFile(this.xml2String(doc), jobId);
    }

    private Document parse(String location) throws Exception {
        XMLInputSource xmlin = UimaUtils.getXMLInputSource((String)location);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return db.parse(xmlin.getInputStream());
    }

    private String xml2String(Document xmlDoc) throws Exception {
        StringWriter writer = null;
        DOMSource domSource = new DOMSource(xmlDoc.getDocumentElement());
        writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(domSource, streamResult);
        StringBuffer serializedDD = writer.getBuffer();
        return serializedDD.toString();
    }

    private String generateDeploymentDescriptor(IDuccUimaAggregate aggregateConfiguration, String jobId) throws Exception {
        ArrayList<String> descriptorPaths = new ArrayList<String>();
        ArrayList<List<String>> overrides = new ArrayList<List<String>>();
        for (IDuccUimaAggregateComponent component : aggregateConfiguration.getComponents()) {
            descriptorPaths.add(component.getDescriptor());
            overrides.add(component.getOverrides());
        }
        UimaASPrimitiveDeploymentDescriptor dd = UimaUtils.createUimaASDeploymentDescriptor((String)aggregateConfiguration.getName(), (String)aggregateConfiguration.getDescription(), (String)aggregateConfiguration.getBrokerURL(), (String)aggregateConfiguration.getEndpoint(), (int)aggregateConfiguration.getThreadCount(), (String)this.userLogDir, (String)(jobId + "-uima-ae-descriptor-" + Utils.getPID() + ".xml"), overrides, (String[])descriptorPaths.toArray(new String[descriptorPaths.size()]));
        return this.writeDDFile(dd.toXML(), jobId);
    }
}

