/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.jd;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.aae.monitor.statistics.AnalysisEnginePerformanceMetrics;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.jd.PerformanceMetricsSummaryItem;

public class PerformanceMetricsSummaryMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<String, PerformanceMetricsSummaryItem> map = new ConcurrentHashMap();
    private AtomicInteger casCount = new AtomicInteger(0);
    public static String delim_old = "Components,";
    public static String delim_new;
    public static String delim;

    private String getKey(AnalysisEnginePerformanceMetrics item) {
        String key = "?";
        try {
            String uniqueName = item.getUniqueName();
            key = uniqueName.contains(delim_old) ? uniqueName.split(delim_old, 2)[1] : (uniqueName.contains(delim_new) ? uniqueName.split(delim_new, 2)[1] : uniqueName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return key;
    }

    private String getDisplayName(AnalysisEnginePerformanceMetrics item) {
        String key = "?";
        try {
            String name = item.getName();
            key = name.contains(delim_old) ? name.split(delim_old, 2)[1] : (name.contains(delim_new) ? name.split(delim_new, 2)[1] : name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(String key, String displayName) {
        ConcurrentHashMap<String, PerformanceMetricsSummaryItem> concurrentHashMap = this.map;
        synchronized (concurrentHashMap) {
            if (!this.map.containsKey(key)) {
                PerformanceMetricsSummaryItem summaryItem = new PerformanceMetricsSummaryItem(displayName, key);
                this.map.put(key, summaryItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DuccLogger duccLogger, List<AnalysisEnginePerformanceMetrics> list) {
        String methodName = "update";
        int count = this.casCount.addAndGet(1);
        for (AnalysisEnginePerformanceMetrics item : list) {
            String key = this.getKey(item);
            String displayName = this.getDisplayName(item);
            this.addEntry(key, displayName);
            PerformanceMetricsSummaryItem summaryItem = this.map.get(key);
            ConcurrentHashMap<String, PerformanceMetricsSummaryItem> concurrentHashMap = this.map;
            synchronized (concurrentHashMap) {
                long timeBefore = summaryItem.getAnalysisTime();
                long timeItem = item.getAnalysisTime();
                long timeAfter = summaryItem.addAndGetAnalysisTime(item.getAnalysisTime());
                long numbBefore = summaryItem.getNumProcessed();
                long numbItem = item.getNumProcessed();
                long numbAfter = summaryItem.addAndGetNumProcessed(item.getNumProcessed());
                if (duccLogger != null) {
                    String t0 = "count:" + count;
                    String t1 = "Numb before:" + numbBefore + " item:" + numbItem + " after:" + numbAfter;
                    String t2 = "Time before:" + timeBefore + " item:" + timeItem + " after:" + timeAfter;
                    String text = t0 + " " + t1 + " " + t2;
                    duccLogger.debug(methodName, null, new Object[]{text});
                }
            }
        }
    }

    public void update(List<AnalysisEnginePerformanceMetrics> list) {
        this.update(null, list);
    }

    public Set<Map.Entry<String, PerformanceMetricsSummaryItem>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public int casCount() {
        return this.casCount.get();
    }

    protected void putItem(String key, PerformanceMetricsSummaryItem value) {
        this.map.put(key, value);
    }

    protected void putCasCount(int value) {
        this.casCount.set(value);
    }

    static {
        delim = delim_new = " Components ";
    }
}

