/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.jd;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.transport.event.jd.PerformanceMetricsSummaryMap;

public class PerformanceMetricsSummaryItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String uniqueName;
    private AtomicLong analysisTime = new AtomicLong(0L);
    private AtomicLong numProcessed = new AtomicLong(0L);
    private AtomicLong analysisTimeMin = new AtomicLong(-1L);
    private AtomicLong analysisTimeMax = new AtomicLong(-1L);
    public static String delim_old = PerformanceMetricsSummaryMap.delim_old;
    public static String delim_new = PerformanceMetricsSummaryMap.delim_new;

    public PerformanceMetricsSummaryItem(String name, String uniqueName) {
        this.name = name;
        this.uniqueName = uniqueName;
    }

    public PerformanceMetricsSummaryItem(String name, String uniqueName, long analysisTime, long numProcessed, long analysisTimeMin, long analysisTimeMax) {
        this.name = name;
        this.uniqueName = uniqueName;
        this.analysisTime.set(analysisTime);
        this.numProcessed.set(numProcessed);
        this.analysisTimeMin.set(analysisTimeMin);
        this.analysisTimeMax.set(analysisTimeMax);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        String itemName;
        String displayName = itemName = this.getName();
        try {
            displayName = itemName.contains(delim_old) ? itemName.split(delim_old, 2)[1] : (itemName.contains(delim_new) ? itemName.split(delim_new, 2)[1] : itemName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return displayName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public long getAnalysisTime() {
        return this.analysisTime.get();
    }

    public long getAnalysisTimeMin() {
        return this.analysisTimeMin.get();
    }

    public long getAnalysisTimeMax() {
        return this.analysisTimeMax.get();
    }

    public long getNumProcessed() {
        return this.numProcessed.get();
    }

    private void updateAnalysisTimeMin(long delta) {
        long currentValue = this.analysisTimeMin.get();
        if (currentValue < 0L) {
            this.analysisTimeMin.compareAndSet(currentValue, delta);
            currentValue = this.analysisTimeMin.get();
        }
        while (currentValue > delta) {
            this.analysisTimeMin.compareAndSet(currentValue, delta);
            currentValue = this.analysisTimeMin.get();
        }
    }

    private void updateAnalysisTimeMax(long delta) {
        long currentValue = this.analysisTimeMax.get();
        if (currentValue < 0L) {
            this.analysisTimeMax.compareAndSet(currentValue, delta);
            currentValue = this.analysisTimeMax.get();
        }
        while (currentValue < delta) {
            this.analysisTimeMax.compareAndSet(currentValue, delta);
            currentValue = this.analysisTimeMax.get();
        }
    }

    public long addAndGetAnalysisTime(long delta) {
        this.updateAnalysisTimeMin(delta);
        this.updateAnalysisTimeMax(delta);
        return this.analysisTime.addAndGet(delta);
    }

    public long addAndGetNumProcessed(long delta) {
        return this.numProcessed.addAndGet(delta);
    }
}

