/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.jd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.SerializationUtils;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccUimaDeploymentDescriptor;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.Rationale;
import org.apache.uima.ducc.transport.event.common.Util;
import org.apache.uima.ducc.transport.event.jd.DuccProcessWorkItemsMap;
import org.apache.uima.ducc.transport.event.jd.IDriverState;
import org.apache.uima.ducc.transport.event.jd.PerformanceMetricsSummaryMap;

public class DriverStatusReport
implements Serializable {
    private static DuccLogger duccOut = DuccLoggerComponents.getJdOut((String)DriverStatusReport.class.getName());
    private static DuccId jobid = null;
    private DuccId duccId = null;
    private String jdJmxUrl = null;
    private volatile IDriverState.DriverState driverState = IDriverState.DriverState.NotRunning;
    private IDuccCompletionType.JobCompletionType jobCompletionType = IDuccCompletionType.JobCompletionType.Undefined;
    private IRationale jobCompletionRationale = null;
    private long now = 0L;
    private long clientInitStart = 0L;
    private long clientInitEnd = 0L;
    private AtomicBoolean terminateDriver = new AtomicBoolean(false);
    private AtomicBoolean atLeastOneService = new AtomicBoolean(false);
    private AtomicBoolean workItemsPending = new AtomicBoolean(true);
    private AtomicLong workItemsTotal = new AtomicLong(-1L);
    private AtomicInteger workItemsFetched = new AtomicInteger(0);
    private AtomicInteger workItemsProcessingStarted = new AtomicInteger(0);
    private AtomicInteger workItemsProcessingCompleted = new AtomicInteger(0);
    private AtomicInteger workItemsProcessingError = new AtomicInteger(0);
    private AtomicInteger workItemsLost = new AtomicInteger(0);
    private AtomicInteger workItemsRetry = new AtomicInteger(0);
    private AtomicInteger workItemsPreempted = new AtomicInteger(0);
    private AtomicInteger threadCount = new AtomicInteger(0);
    private ConcurrentHashMap<String, DuccId> casQueuedMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DuccId> casDequeuedPendingMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HashMap<String, String>> casOperatingMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, DuccId> limboMap = new ConcurrentHashMap();
    private ConcurrentHashMap<DuccId, String> killProcessMap = new ConcurrentHashMap();
    private AtomicBoolean killJob = new AtomicBoolean(false);
    private AtomicLong mostRecentWorkItemStart = new AtomicLong(0L);
    private IDuccPerWorkItemStatistics perWorkItemStatistics = null;
    @Deprecated
    private PerformanceMetricsSummaryMap performanceMetricsSummaryMap = null;
    private ConcurrentHashMap<String, String> pendingProcessAssignmentMap = new ConcurrentHashMap();
    private IDuccUimaDeploymentDescriptor uimaDeploymentDescriptor = null;
    private DuccProcessWorkItemsMap duccProcessWorkItemsMap = new DuccProcessWorkItemsMap();
    private static final String keyNodeIP = "nodeIP";
    private static final String keyPID = "PID";

    public DriverStatusReport(DuccId duccId, String jdJmxUrl) {
        this.setJdJmxUrl(jdJmxUrl);
        this.setDuccId(duccId);
    }

    public void setDuccId(DuccId duccId) {
        this.duccId = duccId;
    }

    public DuccId getDuccId() {
        return this.duccId;
    }

    public String getId() {
        return this.duccId.toString();
    }

    public void setDuccProcessWorkItemsMap(DuccProcessWorkItemsMap duccProcessWorkItemsMap) {
        this.duccProcessWorkItemsMap = duccProcessWorkItemsMap;
    }

    public DuccProcessWorkItemsMap getDuccProcessWorkItemsMap() {
        return this.duccProcessWorkItemsMap;
    }

    public void setJdJmxUrl(String jdJmxUrl) {
        this.jdJmxUrl = jdJmxUrl;
    }

    public String getJdJmxUrl() {
        return this.jdJmxUrl;
    }

    public int getHashCode() {
        return this.duccId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDriverState(IDriverState.DriverState driverState) {
        String methodName = "setDriverState";
        DriverStatusReport driverStatusReport = this;
        synchronized (driverStatusReport) {
            String prev = this.getDriverState().toString();
            switch (this.driverState) {
                case Completed: {
                    break;
                }
                default: {
                    this.driverState = driverState;
                }
            }
            String curr = this.getDriverState().toString();
            duccOut.debug(methodName, this.duccId, new Object[]{"current:" + curr + " " + "previous:" + prev});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDriverState.DriverState getDriverState() {
        String methodName = "getDriverState";
        DriverStatusReport driverStatusReport = this;
        synchronized (driverStatusReport) {
            String curr = this.driverState.toString();
            duccOut.debug(methodName, this.duccId, new Object[]{"current:" + curr});
            return this.driverState;
        }
    }

    public boolean isTerminateDriver() {
        return this.terminateDriver.get();
    }

    public void setTerminateDriver() {
        this.terminateDriver.set(true);
        this.calculateState();
    }

    private void setJobCompletion(IDuccCompletionType.JobCompletionType jobCompletionType, IRationale rationale) {
        this.jobCompletionType = jobCompletionType;
        this.jobCompletionRationale = rationale;
    }

    public IDuccCompletionType.JobCompletionType getJobCompletionType() {
        return this.jobCompletionType;
    }

    public IRationale getJobCompletionRationale() {
        return this.jobCompletionRationale;
    }

    public void setClientInitStart(long time) {
        this.clientInitStart = time;
    }

    public long getClientInitStart() {
        return this.clientInitStart;
    }

    public void setClientInitEnd(long time) {
        this.clientInitEnd = time;
    }

    public long getClientInitEnd() {
        return this.clientInitEnd;
    }

    public void setNow() {
        this.now = System.currentTimeMillis();
    }

    public long getNow() {
        return this.now;
    }

    public void setInitializing() {
        this.setClientInitStart(System.currentTimeMillis());
        this.setClientInitEnd(0L);
        this.setDriverState(IDriverState.DriverState.Initializing);
        this.logReport();
    }

    public void setInitializingCompleted() {
        this.setClientInitEnd(System.currentTimeMillis());
        this.setDriverState(IDriverState.DriverState.Idle);
        this.logReport();
    }

    public void setInitializingFailed(IRationale rationale) {
        this.setClientInitEnd(System.currentTimeMillis());
        this.setDriverState(IDriverState.DriverState.Completed);
        this.setJobCompletion(IDuccCompletionType.JobCompletionType.DriverInitializationFailure, rationale);
        this.logReport();
    }

    public void setExcessiveInitializationFailures(IRationale rationale) {
        this.setClientInitEnd(System.currentTimeMillis());
        this.setDriverState(IDriverState.DriverState.Completed);
        this.setJobCompletion(IDuccCompletionType.JobCompletionType.ProcessInitializationFailure, rationale);
        this.logReport();
    }

    public boolean getAtLeastOneService() {
        String methodName = "getAtLeastOneService";
        boolean retVal = this.atLeastOneService.get();
        duccOut.debug(methodName, jobid, new Object[]{retVal});
        return retVal;
    }

    public void setAtLeastOneService() {
        String methodName = "setAtLeastOneService";
        if (!this.atLeastOneService.get()) {
            this.atLeastOneService.set(true);
            duccOut.debug(methodName, jobid, new Object[]{this.atLeastOneService.get()});
            this.calculateState();
            this.logReport();
        }
    }

    public void setWorkItemsPending() {
        String methodName = "setWorkItemsPending";
        if (!this.workItemsPending.getAndSet(true)) {
            duccOut.debug(methodName, jobid, new Object[]{true});
            this.calculateState();
            this.logReport();
        }
    }

    public void resetWorkItemsPending() {
        String methodName = "resetWorkItemsPending";
        if (this.workItemsPending.getAndSet(false)) {
            duccOut.debug(methodName, jobid, new Object[]{false});
            this.calculateState();
            this.logReport();
        }
    }

    public boolean isPending() {
        String methodName = "isPending";
        boolean retVal = this.workItemsPending.get();
        duccOut.debug(methodName, jobid, new Object[]{retVal});
        return retVal;
    }

    public void setWorkItemsTotal(long total) {
        this.workItemsTotal.set(total);
        this.logReport();
    }

    public long getWorkItemsTotal() {
        return this.workItemsTotal.get();
    }

    public void setWorkItemsFetched(int update) {
        int expect = this.workItemsFetched.get();
        while (expect < update) {
            this.workItemsFetched.compareAndSet(expect, update);
            expect = this.workItemsFetched.get();
        }
        this.logReport();
    }

    public int getWorkItemsFetched() {
        return this.workItemsFetched.get();
    }

    public void setMostRecentStart(long time) {
        this.mostRecentWorkItemStart.set(time);
    }

    public long getMostRecentStart() {
        return this.mostRecentWorkItemStart.get();
    }

    public void countWorkItemsProcessingStarted() {
        this.workItemsProcessingStarted.incrementAndGet();
        this.calculateState();
        this.logReport();
    }

    public int getWorkItemsProcessingStarted() {
        return this.workItemsProcessingStarted.get();
    }

    public void countWorkItemsProcessingCompleted() {
        this.workItemsProcessingCompleted.incrementAndGet();
        this.calculateState();
        this.logReport();
    }

    public int getWorkItemsProcessingCompleted() {
        return this.workItemsProcessingCompleted.get();
    }

    public int getWorkItemsOperating() {
        return this.casOperatingMap.size();
    }

    public void countWorkItemsProcessingError() {
        this.workItemsProcessingError.incrementAndGet();
        this.calculateState();
        this.logReport();
    }

    public int getWorkItemsProcessingError() {
        return this.workItemsProcessingError.get();
    }

    public void countWorkItemsLost() {
        this.workItemsLost.incrementAndGet();
        this.calculateState();
        this.logReport();
    }

    public int getWorkItemsLost() {
        return this.workItemsLost.get();
    }

    public void countWorkItemsRetry() {
        this.workItemsRetry.incrementAndGet();
        this.calculateState();
        this.logReport();
    }

    public int getWorkItemsRetry() {
        return this.workItemsRetry.get();
    }

    public void countWorkItemsPreempted() {
        this.workItemsPreempted.incrementAndGet();
        this.calculateState();
        this.logReport();
    }

    public int getWorkItemsPreempted() {
        return this.workItemsPreempted.get();
    }

    public long getWorkItemsToDo() {
        long total = this.getWorkItemsTotal();
        long done = this.getWorkItemsProcessingCompleted();
        long error = this.getWorkItemsProcessingError();
        long lost = this.getWorkItemsLost();
        long todo = total - (done + error + lost);
        return todo;
    }

    public int getThreadCount() {
        return this.threadCount.get();
    }

    public void setThreadCount(int threadCount) {
        this.threadCount.set(threadCount);
    }

    public void killProcess(DuccId processId, String casId) {
        this.killProcessMap.put(processId, casId);
    }

    public boolean isKillProcess(DuccId processId) {
        boolean retVal = false;
        if (this.killProcessMap.containsKey(processId)) {
            retVal = true;
        }
        return retVal;
    }

    public Iterator<DuccId> getKillDuccIds() {
        return this.killProcessMap.keySet().iterator();
    }

    public void killJob(IDuccCompletionType.JobCompletionType jobCompletionType, IRationale jobCompletionRationale) {
        this.killJob.getAndSet(true);
        this.setJobCompletion(jobCompletionType, jobCompletionRationale);
    }

    public boolean isKillJob() {
        return this.killJob.get();
    }

    public void limboAdd(int seqNo, DuccId pDuccId) {
        this.limboMap.put(new Integer(seqNo), pDuccId);
    }

    public void limboRemove(int seqNo, DuccId pDuccId) {
        this.limboMap.remove(new Integer(seqNo));
    }

    public ConcurrentHashMap<Integer, DuccId> getLimboMap() {
        return this.limboMap;
    }

    public ConcurrentHashMap<String, DuccId> getCasQueuedMap() {
        return this.casQueuedMap;
    }

    public int getWorkItemsQueued() {
        return this.casQueuedMap.size() + this.casDequeuedPendingMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workItemQueued(String casId, DuccId jobId) {
        String methodName = "workItemQueued";
        try {
            ConcurrentHashMap<String, DuccId> concurrentHashMap = this.casQueuedMap;
            synchronized (concurrentHashMap) {
                if (this.casQueuedMap.containsKey(casId)) {
                    duccOut.debug(methodName, this.duccId, new Object[]{casId + " already queued"});
                }
                if (this.casDequeuedPendingMap.containsKey(casId)) {
                    duccOut.debug(methodName, this.duccId, new Object[]{casId + " already dequeued"});
                    this.casDequeuedPendingMap.remove(casId);
                } else {
                    this.casQueuedMap.put(casId, jobId);
                }
            }
        }
        catch (Throwable t) {
            duccOut.debug(methodName, this.duccId, t, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workItemDequeued(String casId) {
        String methodName = "workItemDequeued";
        try {
            ConcurrentHashMap<String, DuccId> concurrentHashMap = this.casQueuedMap;
            synchronized (concurrentHashMap) {
                if (!this.casQueuedMap.containsKey(casId)) {
                    duccOut.debug(methodName, this.duccId, new Object[]{casId + " not found"});
                    this.casDequeuedPendingMap.put(casId, this.duccId);
                } else {
                    this.casQueuedMap.remove(casId);
                }
            }
        }
        catch (Throwable t) {
            duccOut.debug(methodName, this.duccId, t, new Object[0]);
        }
    }

    public int getWorkItemsDispatched() {
        String methodName = "getWorkItemsDispatched";
        int retVal = 0;
        try {
            DuccProcessWorkItemsMap pwiMap = this.getDuccProcessWorkItemsMap();
            for (DuccId processId : pwiMap.keySet()) {
                IDuccProcessWorkItems pwi = (IDuccProcessWorkItems)pwiMap.get((Object)processId);
                retVal = (int)((long)retVal + pwi.getCountDispatch());
            }
        }
        catch (Throwable t) {
            duccOut.debug(methodName, this.duccId, t, new Object[0]);
        }
        return retVal;
    }

    public void workItemPendingProcessAssignmentAdd(String casId) {
        this.pendingProcessAssignmentMap.put(casId, casId);
    }

    public void workItemPendingProcessAssignmentRemove(String casId) {
        this.pendingProcessAssignmentMap.remove(casId);
    }

    public int getWorkItemPendingProcessAssignmentCount() {
        int retVal = 0;
        retVal = this.pendingProcessAssignmentMap.size();
        return retVal;
    }

    public boolean isWorkItemPendingProcessAssignment() {
        boolean retVal = false;
        if (this.getWorkItemPendingProcessAssignmentCount() > 0) {
            retVal = true;
        }
        return retVal;
    }

    public void workItemOperatingStart(String casId, String nodeIP, String PID) {
        HashMap<String, String> operatingCAS = new HashMap<String, String>();
        operatingCAS.put(keyNodeIP, nodeIP);
        operatingCAS.put(keyPID, PID);
        this.casOperatingMap.put(casId, operatingCAS);
        this.workItemDequeued(casId);
        this.logReport();
    }

    public void workItemOperatingEnd(String casId) {
        this.casOperatingMap.remove(casId);
        this.logReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperating(String nodeIP, String PID) {
        boolean retVal = false;
        DriverStatusReport driverStatusReport = this;
        synchronized (driverStatusReport) {
            for (String casId : this.casOperatingMap.keySet()) {
                HashMap<String, String> casOperating = this.casOperatingMap.get(casId);
                if (!Util.compare(nodeIP, casOperating.get(keyNodeIP)) || !Util.compare(PID, casOperating.get(keyPID))) continue;
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean isStarted() {
        int started = this.getWorkItemsProcessingStarted();
        return started > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessing() {
        String methodName = "isProcessing";
        DriverStatusReport driverStatusReport = this;
        synchronized (driverStatusReport) {
            int fetched = this.getWorkItemsFetched();
            int completed = this.getWorkItemsProcessingCompleted();
            int error = this.getWorkItemsProcessingError();
            int lost = this.getWorkItemsLost();
            boolean retVal = fetched != completed + error + lost;
            duccOut.debug(methodName, jobid, new Object[]{"fetched:" + fetched + " " + "completed:" + completed + " " + "error:" + error + " " + "lost:" + lost});
            return retVal;
        }
    }

    public boolean isComplete() {
        boolean retVal = false;
        switch (this.getDriverState()) {
            case Completed: 
            case Completing: {
                retVal = true;
            }
        }
        return retVal;
    }

    private void calculateState() {
        String methodName = "calculateState";
        switch (this.getDriverState()) {
            case Initializing: {
                if (!this.getAtLeastOneService()) break;
                this.setDriverState(IDriverState.DriverState.Running);
                break;
            }
            case Idle: {
                if (this.isProcessing()) {
                    this.setDriverState(IDriverState.DriverState.Running);
                    break;
                }
                if (this.isPending()) {
                    this.setDriverState(IDriverState.DriverState.Idle);
                    break;
                }
                this.setDriverState(IDriverState.DriverState.Completing);
                break;
            }
            case Running: {
                if (this.isProcessing()) break;
                if (this.isPending()) {
                    this.setDriverState(IDriverState.DriverState.Idle);
                    break;
                }
                this.setDriverState(IDriverState.DriverState.Completing);
                break;
            }
            case Completing: {
                if (!this.isTerminateDriver()) break;
                this.setDriverState(IDriverState.DriverState.Completed);
                if (this.getWorkItemsProcessingError() != 0 || this.getWorkItemsLost() != 0) break;
                this.setJobCompletion(IDuccCompletionType.JobCompletionType.EndOfJob, new Rationale("job driver status reported as normal completion"));
                break;
            }
        }
        duccOut.debug(methodName, this.duccId, new Object[]{"state:" + (Object)((Object)this.getDriverState())});
    }

    public String getLogReport() {
        return "state:" + (Object)((Object)this.driverState) + " " + "threads:" + this.getThreadCount() + " " + "total:" + this.getWorkItemsTotal() + " " + "fetched:" + this.getWorkItemsFetched() + " " + "started:" + this.getWorkItemsProcessingStarted() + " " + "completed:" + this.getWorkItemsProcessingCompleted() + " " + "error:" + this.getWorkItemsProcessingError() + " " + "lost:" + this.getWorkItemsLost() + " " + "queued:" + this.getWorkItemsQueued() + " " + "in-progress:" + this.casOperatingMap.size() + " " + "pending:" + this.isPending() + " " + "unassigned:" + this.getWorkItemPendingProcessAssignmentCount() + " " + "retry:" + this.getWorkItemsRetry();
    }

    public void logReport() {
        String methodName = "logReport";
        duccOut.debug(methodName, this.duccId, new Object[]{this.getLogReport()});
    }

    public DriverStatusReport deepCopy() {
        return (DriverStatusReport)SerializationUtils.clone((Serializable)this);
    }

    public void setPerWorkItemStatistics(IDuccPerWorkItemStatistics perWorkItemStatistics) {
        this.perWorkItemStatistics = perWorkItemStatistics;
    }

    public IDuccPerWorkItemStatistics getPerWorkItemStatistics() {
        return this.perWorkItemStatistics;
    }

    @Deprecated
    public PerformanceMetricsSummaryMap getPerformanceMetricsSummaryMap() {
        return this.performanceMetricsSummaryMap;
    }

    public IDuccUimaDeploymentDescriptor getUimaDeploymentDescriptor() {
        return this.uimaDeploymentDescriptor;
    }

    public void setUimaDeploymentDescriptor(IDuccUimaDeploymentDescriptor uimaDeploymentDescriptor) {
        this.uimaDeploymentDescriptor = uimaDeploymentDescriptor;
    }
}

