/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common.history;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;

public class HistoryPersistenceManager
implements IHistoryPersistenceManager {
    private static HistoryPersistenceManager instance = new HistoryPersistenceManager();
    private static final DuccLogger logger = DuccLoggerComponents.getTrLogger((String)HistoryPersistenceManager.class.getName());
    private String historyDirectory_jobs = IDuccEnv.DUCC_HISTORY_JOBS_DIR;
    private String historyDirectory_reservations = IDuccEnv.DUCC_HISTORY_RESERVATIONS_DIR;
    private String historyDirectory_services = IDuccEnv.DUCC_HISTORY_SERVICES_DIR;
    private String dwj = "dwj";
    private String dwr = "dwr";
    private String dws = "dws";

    public static HistoryPersistenceManager getInstance() {
        return instance;
    }

    public HistoryPersistenceManager() {
        this.mkdirs();
    }

    private void mkdirs() {
        IOHelper.mkdirs((String)this.historyDirectory_jobs);
        IOHelper.mkdirs((String)this.historyDirectory_reservations);
        IOHelper.mkdirs((String)this.historyDirectory_services);
    }

    private String normalize(String id) {
        String retVal = id;
        return retVal;
    }

    @Override
    public void jobSaveConditional(IDuccWorkJob duccWorkJob) throws IOException {
        String id = this.normalize("" + duccWorkJob.getDuccId().getFriendly());
        String fileName = this.historyDirectory_jobs + File.separator + id + "." + this.dwj;
        File file = new File(fileName);
        if (!file.exists()) {
            this.jobSave(duccWorkJob);
        }
    }

    @Override
    public void jobSave(IDuccWorkJob duccWorkJob) throws IOException {
        String id = this.normalize("" + duccWorkJob.getDuccId().getFriendly());
        String fileName = this.historyDirectory_jobs + File.separator + id + "." + this.dwj;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkJob);
        out.close();
    }

    @Override
    public IDuccWorkJob jobRestore(String fileName) {
        return this.jobRestore(fileName, Verbosity.SPEAK);
    }

    private IDuccWorkJob jobRestore(String fileName, Verbosity level) {
        String methodName = "jobRestore";
        IDuccWorkJob job = null;
        try {
            logger.trace(methodName, null, new Object[]{"restore:" + fileName});
            FileInputStream fis = null;
            ObjectInputStream in = null;
            fis = new FileInputStream(this.historyDirectory_jobs + File.separator + fileName);
            in = new ObjectInputStream(fis);
            job = (IDuccWorkJob)in.readObject();
            in.close();
        }
        catch (Exception e) {
            switch (level) {
                case QUIET: {
                    break;
                }
                case SPEAK: {
                    logger.warn(methodName, null, new Object[]{"unable to restore:" + fileName, e});
                }
            }
        }
        return job;
    }

    @Override
    public IDuccWorkJob jobRestore(DuccId duccId) {
        String fileName = duccId.getFriendly() + "." + this.dwj;
        return this.jobRestore(fileName, Verbosity.QUIET);
    }

    @Override
    public ArrayList<String> jobList() {
        ArrayList<String> retVal = new ArrayList<String>();
        File folder = new File(this.historyDirectory_jobs);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dwj)) continue;
                retVal.add(name);
            }
        }
        return retVal;
    }

    @Override
    public ArrayList<IDuccWorkJob> jobRestore() throws IOException, ClassNotFoundException {
        ArrayList<IDuccWorkJob> retVal = new ArrayList<IDuccWorkJob>();
        ArrayList<String> jobFileNames = this.jobList();
        ListIterator<String> listIterator = jobFileNames.listIterator();
        while (listIterator.hasNext()) {
            String fileName = listIterator.next();
            IDuccWorkJob job = this.jobRestore(fileName);
            if (job == null) continue;
            retVal.add(job);
        }
        return retVal;
    }

    @Override
    public void reservationSaveConditional(IDuccWorkReservation duccWorkReservation) throws IOException {
        String id = this.normalize("" + duccWorkReservation.getDuccId().getFriendly());
        String fileName = this.historyDirectory_jobs + File.separator + id + "." + this.dwr;
        File file = new File(fileName);
        if (!file.exists()) {
            this.reservationSave(duccWorkReservation);
        }
    }

    @Override
    public void reservationSave(IDuccWorkReservation duccWorkReservation) throws IOException {
        String id = this.normalize("" + duccWorkReservation.getDuccId().getFriendly());
        String fileName = this.historyDirectory_reservations + File.separator + id + "." + this.dwr;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkReservation);
        out.close();
    }

    @Override
    public IDuccWorkReservation reservationRestore(String fileName) {
        return this.reservationRestore(fileName, Verbosity.SPEAK);
    }

    private IDuccWorkReservation reservationRestore(String fileName, Verbosity level) {
        String methodName = "reservationRestore";
        IDuccWorkReservation reservation = null;
        try {
            logger.trace(methodName, null, new Object[]{"restore:" + fileName});
            FileInputStream fis = null;
            ObjectInputStream in = null;
            fis = new FileInputStream(this.historyDirectory_reservations + File.separator + fileName);
            in = new ObjectInputStream(fis);
            reservation = (IDuccWorkReservation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            switch (level) {
                case QUIET: {
                    break;
                }
                case SPEAK: {
                    logger.warn(methodName, null, new Object[]{"unable to restore:" + fileName});
                }
            }
        }
        return reservation;
    }

    @Override
    public ArrayList<String> reservationList() {
        ArrayList<String> retVal = new ArrayList<String>();
        File folder = new File(this.historyDirectory_reservations);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dwr)) continue;
                retVal.add(name);
            }
        }
        return retVal;
    }

    @Override
    public ArrayList<IDuccWorkReservation> reservationRestore() throws IOException, ClassNotFoundException {
        ArrayList<IDuccWorkReservation> retVal = new ArrayList<IDuccWorkReservation>();
        ArrayList<String> reservationFileNames = this.reservationList();
        ListIterator<String> listIterator = reservationFileNames.listIterator();
        while (listIterator.hasNext()) {
            String fileName = listIterator.next();
            IDuccWorkReservation reservation = this.reservationRestore(fileName);
            if (reservation == null) continue;
            retVal.add(reservation);
        }
        return retVal;
    }

    @Override
    public IDuccWorkReservation reservationRestore(DuccId duccId) {
        String fileName = duccId.getFriendly() + "." + this.dwr;
        return this.reservationRestore(fileName, Verbosity.QUIET);
    }

    @Override
    public void serviceSaveConditional(IDuccWorkService duccWorkService) throws IOException {
        String id = this.normalize("" + duccWorkService.getDuccId().getFriendly());
        String fileName = this.historyDirectory_services + File.separator + id + "." + this.dws;
        File file = new File(fileName);
        if (!file.exists()) {
            this.serviceSave(duccWorkService);
        }
    }

    @Override
    public void serviceSave(IDuccWorkService duccWorkService) throws IOException {
        String id = this.normalize("" + duccWorkService.getDuccId().getFriendly());
        String fileName = this.historyDirectory_services + File.separator + id + "." + this.dws;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkService);
        out.close();
    }

    @Override
    public IDuccWorkService serviceRestore(String fileName) {
        return this.serviceRestore(fileName, Verbosity.SPEAK);
    }

    private IDuccWorkService serviceRestore(String fileName, Verbosity level) {
        String methodName = "serviceRestore";
        IDuccWorkService service = null;
        try {
            logger.trace(methodName, null, new Object[]{"restore:" + fileName});
            FileInputStream fis = null;
            ObjectInputStream in = null;
            fis = new FileInputStream(this.historyDirectory_services + File.separator + fileName);
            in = new ObjectInputStream(fis);
            service = (IDuccWorkService)in.readObject();
            in.close();
        }
        catch (Exception e) {
            switch (level) {
                case QUIET: {
                    break;
                }
                case SPEAK: {
                    logger.warn(methodName, null, new Object[]{"unable to restore:" + fileName});
                }
            }
        }
        return service;
    }

    @Override
    public ArrayList<String> serviceList() {
        ArrayList<String> retVal = new ArrayList<String>();
        File folder = new File(this.historyDirectory_services);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dws)) continue;
                retVal.add(name);
            }
        }
        return retVal;
    }

    @Override
    public ArrayList<IDuccWorkService> serviceRestore() throws IOException, ClassNotFoundException {
        ArrayList<IDuccWorkService> retVal = new ArrayList<IDuccWorkService>();
        ArrayList<String> serviceFileNames = this.serviceList();
        ListIterator<String> listIterator = serviceFileNames.listIterator();
        while (listIterator.hasNext()) {
            String fileName = listIterator.next();
            IDuccWorkService service = this.serviceRestore(fileName);
            if (service == null) continue;
            retVal.add(service);
        }
        return retVal;
    }

    @Override
    public IDuccWorkService serviceRestore(DuccId duccId) {
        String fileName = duccId.getFriendly() + "." + this.dws;
        return this.serviceRestore(fileName, Verbosity.QUIET);
    }

    private static int doJobs(HistoryPersistenceManager hpm) throws IOException, ClassNotFoundException {
        ArrayList<IDuccWorkJob> duccWorkJobs = hpm.jobRestore();
        ListIterator<IDuccWorkJob> listIterator = duccWorkJobs.listIterator();
        int acc = 0;
        while (listIterator.hasNext()) {
            IDuccWorkJob duccWorkJob = listIterator.next();
            System.out.println(duccWorkJob.getId());
            ++acc;
        }
        return acc;
    }

    private static int doReservations(HistoryPersistenceManager hpm) throws IOException, ClassNotFoundException {
        ArrayList<IDuccWorkReservation> duccWorkReservations = hpm.reservationRestore();
        ListIterator<IDuccWorkReservation> listIterator = duccWorkReservations.listIterator();
        int acc = 0;
        while (listIterator.hasNext()) {
            IDuccWorkReservation duccWorkReservation = listIterator.next();
            System.out.println(duccWorkReservation.getId());
            ++acc;
        }
        return acc;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String ducc_home = Utils.findDuccHome();
        if (ducc_home == null) {
            System.out.println("DUCC_HOME not set in environment");
            return;
        }
        if (ducc_home.trim() == "") {
            System.out.println("DUCC_HOME not set in environment");
            return;
        }
        HistoryPersistenceManager hpm = new HistoryPersistenceManager();
        int jobs = HistoryPersistenceManager.doJobs(hpm);
        System.out.println("jobs: " + jobs);
        int reservations = HistoryPersistenceManager.doReservations(hpm);
        System.out.println("reservations: " + reservations);
    }

    private static enum Verbosity {
        QUIET,
        SPEAK;

    }
}

