/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.io.Serializable;

public interface IResourceState
extends Serializable {
    public ResourceState getResourceState();

    public static enum ProcessDeallocationType {
        Voluntary,
        Forced,
        JobCanceled,
        JobFailure,
        JobCompleted,
        Exception,
        AutonomousStop,
        Stopped,
        Failed,
        FailedInitialization,
        InitializationTimeout,
        Killed,
        Purged,
        Canceled,
        Undefined;


        public static String getToolTip(ProcessDeallocationType type) {
            String retVal = null;
            switch (type) {
                case Voluntary: {
                    retVal = "No more work for process";
                    break;
                }
                case Forced: {
                    retVal = "Competition caused take away (preemption by RM)";
                    break;
                }
                case JobCanceled: {
                    retVal = "Job canceled by user (cancel command)";
                    break;
                }
                case JobFailure: {
                    retVal = "Job canceled by JD";
                    break;
                }
                case JobCompleted: {
                    retVal = "Process active prior to DUCC restart";
                    break;
                }
                case Exception: {
                    retVal = "Process killed by JD exception handler";
                    break;
                }
                case AutonomousStop: {
                    retVal = "Process unexpectedly vanished (not terminated by Agent)";
                    break;
                }
                case Stopped: {
                    retVal = "Process terminated normally";
                    break;
                }
                case Failed: {
                    retVal = "Process failure detected by Agent";
                    break;
                }
                case FailedInitialization: {
                    retVal = "Process terminated due to initialization failure";
                    break;
                }
                case InitializationTimeout: {
                    retVal = "Process terminated due to initialization timeout";
                    break;
                }
                case Killed: {
                    retVal = "Process terminated by Agent";
                    break;
                }
                case Purged: {
                    retVal = "Process purged (by RM)";
                }
            }
            return retVal;
        }
    }

    public static enum ResourceState {
        Allocated,
        Deallocated,
        Undefined;

    }
}

