/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.ADuccWork;
import org.apache.uima.ducc.transport.event.common.DuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.Rationale;

public class DuccWorkReservation
extends ADuccWork
implements IDuccWorkReservation {
    private static final long serialVersionUID = 1L;
    private static final DuccLogger logger = DuccLoggerComponents.getOrLogger((String)DuccWorkReservation.class.getName());
    private IDuccReservationMap duccReservationMap = new DuccReservationMap();
    private IRationale completionRationale = null;

    public DuccWorkReservation() {
        this.init(null);
    }

    public DuccWorkReservation(DuccId duccId) {
        this.init(duccId);
    }

    private void init(DuccId duccId) {
        this.setDuccType(IDuccTypes.DuccType.Reservation);
        this.setDuccId(duccId);
        this.setStateObject((Object)IDuccState.ReservationState.Undefined);
        this.setCompletionTypeObject((Object)IDuccCompletionType.ReservationCompletionType.Undefined);
    }

    @Override
    public IDuccReservationMap getReservationMap() {
        return this.duccReservationMap;
    }

    @Override
    public void setReservationMap(IDuccReservationMap reservationMap) {
        this.duccReservationMap = reservationMap;
    }

    @Override
    public IDuccState.ReservationState getReservationState() {
        return (IDuccState.ReservationState)((Object)this.getStateObject());
    }

    @Override
    public void setReservationState(IDuccState.ReservationState reservationState) {
        this.setStateObject((Object)reservationState);
    }

    @Override
    public void setCompletion(IDuccCompletionType.ReservationCompletionType completionType, IRationale completionRationale) {
        this.setCompletionType(completionType);
        this.setCompletionRationale(completionRationale);
    }

    @Override
    public IDuccCompletionType.ReservationCompletionType getCompletionType() {
        return (IDuccCompletionType.ReservationCompletionType)((Object)this.getCompletionTypeObject());
    }

    @Override
    public void setCompletionType(IDuccCompletionType.ReservationCompletionType completionType) {
        this.setCompletionTypeObject((Object)completionType);
    }

    @Override
    public IRationale getCompletionRationale() {
        IRationale retVal = null;
        try {
            retVal = this.completionRationale != null ? this.completionRationale : new Rationale();
        }
        catch (Exception e) {
            retVal = new Rationale();
        }
        return retVal;
    }

    @Override
    public void setCompletionRationale(IRationale completionRationale) {
        this.completionRationale = completionRationale;
    }

    @Override
    public boolean isActive() {
        boolean retVal = false;
        switch (this.getReservationState()) {
            case WaitingForResources: 
            case Assigned: {
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean isPending() {
        boolean retVal = false;
        switch (this.getReservationState()) {
            case WaitingForResources: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isSchedulable() {
        boolean retVal = false;
        switch (this.getReservationState()) {
            case WaitingForResources: 
            case Assigned: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isDispatchable() {
        boolean retVal = false;
        switch (this.getReservationState()) {
            case Assigned: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isCompleted() {
        boolean retVal = false;
        switch (this.getReservationState()) {
            case Completed: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isFinished() {
        return this.isCompleted();
    }

    @Override
    public boolean isOperational() {
        boolean retVal = true;
        switch (this.getReservationState()) {
            case Completed: {
                retVal = false;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromAssigned(IDuccState.ReservationState prev, IDuccState.ReservationState next) {
        boolean retVal = false;
        switch (next) {
            case Assigned: {
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Received: {
                break;
            }
            case Undefined: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromCompleted(IDuccState.ReservationState prev, IDuccState.ReservationState next) {
        boolean retVal = false;
        switch (next) {
            case Assigned: {
                break;
            }
            case Completed: {
                break;
            }
            case Received: {
                break;
            }
            case Undefined: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromReceived(IDuccState.ReservationState prev, IDuccState.ReservationState next) {
        boolean retVal = false;
        switch (next) {
            case Assigned: {
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Received: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForResources: {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromUndefined(IDuccState.ReservationState prev, IDuccState.ReservationState next) {
        boolean retVal = false;
        switch (next) {
            case Assigned: {
                break;
            }
            case Completed: {
                break;
            }
            case Received: {
                retVal = true;
                break;
            }
            case Undefined: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromWaitingForResources(IDuccState.ReservationState prev, IDuccState.ReservationState next) {
        boolean retVal = false;
        switch (next) {
            case Assigned: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Received: {
                break;
            }
            case Undefined: {
                break;
            }
        }
        return retVal;
    }

    @Override
    public boolean stateChange(IDuccState.ReservationState state) {
        String methodName = "stateChange";
        boolean retVal = false;
        IDuccState.ReservationState prev = this.getReservationState();
        IDuccState.ReservationState next = state;
        switch (prev) {
            case Assigned: {
                retVal = this.stateChangeFromAssigned(prev, next);
                break;
            }
            case Completed: {
                retVal = this.stateChangeFromCompleted(prev, next);
                break;
            }
            case Received: {
                retVal = this.stateChangeFromReceived(prev, next);
                break;
            }
            case Undefined: {
                retVal = this.stateChangeFromUndefined(prev, next);
                break;
            }
            case WaitingForResources: {
                retVal = this.stateChangeFromWaitingForResources(prev, next);
            }
        }
        if (retVal) {
            this.setReservationState(state);
            logger.info(methodName, this.getDuccId(), new Object[]{"current[" + (Object)((Object)next) + "] previous[" + (Object)((Object)prev) + "]"});
        } else {
            logger.error(methodName, this.getDuccId(), new Object[]{"current[" + (Object)((Object)prev) + "] requested[" + (Object)((Object)next) + "]" + " ignored"});
        }
        return retVal;
    }

    @Override
    public boolean complete(IDuccCompletionType.ReservationCompletionType completionType) {
        String methodName = "complete";
        boolean retVal = false;
        switch (this.getCompletionType()) {
            case Undefined: {
                retVal = true;
            }
        }
        if (retVal) {
            this.setCompletionType(completionType);
            logger.info(methodName, this.getDuccId(), new Object[]{completionType});
        } else {
            logger.info(methodName, this.getDuccId(), new Object[]{(Object)((Object)completionType) + " " + "ignored"});
        }
        return retVal;
    }

    @Override
    public void logState() {
        String methodName = "logState";
        logger.info(methodName, this.getDuccId(), new Object[]{this.getReservationState()});
    }

    public List<String> getNodes(boolean unique) {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.getReservationMap().isEmpty()) {
            IDuccReservationMap map = this.getReservationMap();
            for (DuccId key : map.keySet()) {
                IDuccReservation value = (IDuccReservation)this.getReservationMap().get(key);
                String node = value.getNodeIdentity().getName();
                if (unique) {
                    if (list.contains(node)) continue;
                    list.add(node);
                    continue;
                }
                list.add(node);
            }
        }
        return list;
    }

    public List<String> getNodes() {
        return this.getNodes(false);
    }

    @Override
    public List<String> getUniqueNodes() {
        return this.getNodes(true);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

