/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.SerializationUtils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;

public class DuccWorkMap
implements Serializable,
Map {
    private static final long serialVersionUID = 2L;
    private ConcurrentHashMap<DuccId, IDuccWork> concurrentWorkMap = new ConcurrentHashMap();
    private AtomicInteger atomicJobDriverNodeCount = new AtomicInteger(0);
    private AtomicInteger atomicJobCount = new AtomicInteger(0);
    private AtomicInteger atomicServiceCount = new AtomicInteger(0);
    private AtomicInteger atomicReservationCount = new AtomicInteger(0);
    private ConcurrentHashMap<String, DuccId> concurrentJobMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DuccId> concurrentServiceMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DuccId> concurrentReservationMap = new ConcurrentHashMap();

    private void init() {
        if (this.atomicJobDriverNodeCount == null) {
            this.atomicJobDriverNodeCount = new AtomicInteger(0);
        }
    }

    public boolean isJobDriverNodeAssigned() {
        this.init();
        return this.atomicJobDriverNodeCount.get() > 0;
    }

    public int getJobDriverNodeCount() {
        this.init();
        return this.atomicJobDriverNodeCount.get();
    }

    public void setJobDriverNodeCount(int count) {
        this.init();
        this.atomicJobDriverNodeCount.set(count);
    }

    public int getJobCount() {
        return this.atomicJobCount.get();
    }

    public Set<DuccId> getJobKeySet() {
        HashSet<DuccId> retVal = new HashSet<DuccId>();
        for (DuccId duccId : this.keySet()) {
            switch (this.concurrentWorkMap.get(duccId).getDuccType()) {
                case Job: {
                    retVal.add(duccId);
                    break;
                }
            }
        }
        return retVal;
    }

    public int getServiceCount() {
        return this.atomicServiceCount.get();
    }

    public Set<DuccId> getServiceKeySet() {
        HashSet<DuccId> retVal = new HashSet<DuccId>();
        for (DuccId duccId : this.keySet()) {
            switch (this.concurrentWorkMap.get(duccId).getDuccType()) {
                case Service: {
                    retVal.add(duccId);
                    break;
                }
            }
        }
        return retVal;
    }

    public Set<DuccId> getManagedReservationKeySet() {
        HashSet<DuccId> retVal = new HashSet<DuccId>();
        for (DuccId duccId : this.keySet()) {
            IDuccWork duccWork = this.concurrentWorkMap.get(duccId);
            if (duccWork == null) continue;
            block0 : switch (duccWork.getDuccType()) {
                case Service: {
                    DuccWorkJob service = (DuccWorkJob)duccWork;
                    IDuccWorkService.ServiceDeploymentType sdt = service.getServiceDeploymentType();
                    if (sdt == null) break;
                    switch (sdt) {
                        case other: {
                            retVal.add(duccId);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        return retVal;
    }

    public int getReservationCount() {
        return this.atomicReservationCount.get();
    }

    public Set<DuccId> getReservationKeySet() {
        HashSet<DuccId> retVal = new HashSet<DuccId>();
        for (DuccId duccId : this.keySet()) {
            switch (this.concurrentWorkMap.get(duccId).getDuccType()) {
                case Reservation: {
                    retVal.add(duccId);
                    break;
                }
            }
        }
        return retVal;
    }

    public ConcurrentHashMap<DuccId, IDuccWork> getMap() {
        return this.concurrentWorkMap;
    }

    public static String normalize(String id) {
        String normalizedId = String.valueOf(Integer.parseInt(id));
        return normalizedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDuccWork(IDuccWork duccWork) {
        DuccWorkMap duccWorkMap = this;
        synchronized (duccWorkMap) {
            duccWork.getDuccId();
            DuccId key = duccWork.getDuccId();
            this.concurrentWorkMap.put(key, duccWork);
            switch (duccWork.getDuccType()) {
                case Job: {
                    this.jobAddKey(duccWork.getId(), key);
                    break;
                }
                case Service: {
                    this.serviceAddKey(duccWork.getId(), key);
                    break;
                }
                case Reservation: {
                    this.reservationAddKey(duccWork.getId(), key);
                    break;
                }
            }
            switch (duccWork.getDuccType()) {
                case Job: {
                    this.atomicJobCount.incrementAndGet();
                    break;
                }
                case Service: {
                    this.atomicServiceCount.incrementAndGet();
                    break;
                }
                case Reservation: {
                    this.atomicReservationCount.incrementAndGet();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDuccWork(DuccId duccId) {
        DuccWorkMap duccWorkMap = this;
        synchronized (duccWorkMap) {
            IDuccWork duccWork = this.concurrentWorkMap.remove(duccId);
            if (duccWork != null) {
                switch (duccWork.getDuccType()) {
                    case Job: {
                        this.jobRemoveKey(duccWork.getId());
                        break;
                    }
                    case Service: {
                        this.serviceRemoveKey(duccWork.getId());
                        break;
                    }
                    case Reservation: {
                        this.reservationRemoveKey(duccWork.getId());
                        break;
                    }
                }
                switch (duccWork.getDuccType()) {
                    case Job: {
                        this.atomicJobCount.decrementAndGet();
                        break;
                    }
                    case Service: {
                        this.atomicServiceCount.decrementAndGet();
                        break;
                    }
                    case Reservation: {
                        this.atomicReservationCount.decrementAndGet();
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDuccWork findDuccWork(DuccId duccId) {
        DuccWorkMap duccWorkMap = this;
        synchronized (duccWorkMap) {
            return this.concurrentWorkMap.get(duccId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDuccWork findDuccWork(IDuccTypes.DuccType duccType, String id) {
        IDuccWork duccWork = null;
        String key = id;
        DuccWorkMap duccWorkMap = this;
        synchronized (duccWorkMap) {
            switch (duccType) {
                case Job: {
                    DuccId duccId = this.concurrentJobMap.get(DuccWorkMap.normalize(key));
                    if (duccId == null) break;
                    duccWork = this.concurrentWorkMap.get(duccId);
                    break;
                }
                case Service: {
                    DuccId duccId = this.concurrentServiceMap.get(DuccWorkMap.normalize(key));
                    if (duccId == null) break;
                    duccWork = this.concurrentWorkMap.get(duccId);
                    break;
                }
                case Reservation: {
                    DuccId duccId = this.concurrentReservationMap.get(DuccWorkMap.normalize(key));
                    if (duccId == null) break;
                    duccWork = this.concurrentWorkMap.get(duccId);
                    break;
                }
            }
            return duccWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDuccWork findDuccWork(IDuccTypes.DuccType duccType, Long id) {
        IDuccWork duccWork = null;
        String key = DuccWorkMap.normalize(String.valueOf(id));
        DuccWorkMap duccWorkMap = this;
        synchronized (duccWorkMap) {
            switch (duccType) {
                case Job: {
                    DuccId duccId = this.concurrentJobMap.get(DuccWorkMap.normalize(key));
                    if (duccId == null) break;
                    duccWork = this.concurrentWorkMap.get(duccId);
                    break;
                }
                case Service: {
                    DuccId duccId = this.concurrentServiceMap.get(DuccWorkMap.normalize(key));
                    if (duccId == null) break;
                    duccWork = this.concurrentWorkMap.get(duccId);
                    break;
                }
                case Reservation: {
                    DuccId duccId = this.concurrentReservationMap.get(DuccWorkMap.normalize(key));
                    if (duccId == null) break;
                    duccWork = this.concurrentWorkMap.get(duccId);
                    break;
                }
            }
            return duccWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DuccWorkMap deepCopy() {
        DuccWorkMap duccWorkMap = this;
        synchronized (duccWorkMap) {
            return (DuccWorkMap)SerializationUtils.clone((Serializable)this);
        }
    }

    private void jobAddKey(String id, DuccId duccId) {
        this.concurrentJobMap.put(DuccWorkMap.normalize(id), duccId);
    }

    private void jobRemoveKey(String id) {
        this.concurrentJobMap.remove(DuccWorkMap.normalize(id));
    }

    private void serviceAddKey(String id, DuccId duccId) {
        this.concurrentServiceMap.put(DuccWorkMap.normalize(id), duccId);
    }

    private void serviceRemoveKey(String id) {
        this.concurrentServiceMap.remove(DuccWorkMap.normalize(id));
    }

    private void reservationAddKey(String id, DuccId duccId) {
        this.concurrentReservationMap.put(DuccWorkMap.normalize(id), duccId);
    }

    private void reservationRemoveKey(String id) {
        this.concurrentReservationMap.remove(DuccWorkMap.normalize(id));
    }

    @Override
    public int size() {
        return this.concurrentWorkMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.concurrentWorkMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.concurrentWorkMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.concurrentWorkMap.containsValue((IDuccWork)value);
    }

    public Object get(Object key) {
        return this.concurrentWorkMap.get((DuccId)key);
    }

    public Object put(Object key, Object value) {
        return this.concurrentWorkMap.put((DuccId)key, (IDuccWork)value);
    }

    public Object remove(Object key) {
        return this.concurrentWorkMap.remove(key);
    }

    public void putAll(Map m) {
        this.concurrentWorkMap.putAll(m);
    }

    @Override
    public void clear() {
        this.concurrentWorkMap.clear();
    }

    public Set<DuccId> keySet() {
        return this.concurrentWorkMap.keySet();
    }

    public Collection<IDuccWork> values() {
        return this.concurrentWorkMap.values();
    }

    public Set entrySet() {
        return this.concurrentWorkMap.entrySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.atomicJobCount.get();
        result = 31 * result + (this.concurrentJobMap == null ? 0 : this.concurrentJobMap.hashCode());
        result = 31 * result + this.atomicServiceCount.get();
        result = 31 * result + (this.concurrentServiceMap == null ? 0 : this.concurrentServiceMap.hashCode());
        result = 31 * result + this.atomicReservationCount.get();
        result = 31 * result + (this.concurrentReservationMap == null ? 0 : this.concurrentReservationMap.hashCode());
        result = 31 * result + (this.concurrentWorkMap == null ? 0 : this.concurrentWorkMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DuccWorkMap other = (DuccWorkMap)obj;
        if (this.atomicJobCount.get() != other.atomicJobCount.get()) {
            return false;
        }
        if (this.concurrentJobMap == null ? other.concurrentJobMap != null : !this.concurrentJobMap.equals(other.concurrentJobMap)) {
            return false;
        }
        if (this.atomicServiceCount.get() != other.atomicServiceCount.get()) {
            return false;
        }
        if (this.concurrentServiceMap == null ? other.concurrentServiceMap != null : !this.concurrentServiceMap.equals(other.concurrentServiceMap)) {
            return false;
        }
        if (this.atomicReservationCount != other.atomicReservationCount) {
            return false;
        }
        if (this.concurrentReservationMap == null ? other.concurrentReservationMap != null : !this.concurrentReservationMap.equals(other.concurrentReservationMap)) {
            return false;
        }
        return !(this.concurrentWorkMap == null ? other.concurrentWorkMap != null : !this.concurrentWorkMap.equals(other.concurrentWorkMap));
    }
}

