/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.io.File;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.ADuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.Rationale;
import org.apache.uima.ducc.transport.event.common.Util;

public class DuccWorkJob
extends ADuccWorkExecutable
implements IDuccWorkJob {
    private static final long serialVersionUID = 1L;
    private DuccWorkPopDriver driver = null;
    private String jobBroker = null;
    private String jobQueue = null;
    private long defaultInitFailureLimit = 1L;
    private AtomicLong processInitFailureCap = new AtomicLong(0L);
    private AtomicLong processInitFailureLimit = new AtomicLong(this.defaultInitFailureLimit);
    private long defaultFailureLimit = 2L;
    private AtomicLong processFailureLimit = new AtomicLong(this.defaultFailureLimit);
    private AtomicLong debugPortDriver = new AtomicLong(-1L);
    private AtomicLong debugPortProcess = new AtomicLong(-1L);
    private IRationale completionRationale = null;

    public DuccWorkJob() {
        this.init(null);
    }

    public DuccWorkJob(DuccId duccId) {
        this.init(duccId);
    }

    private void init(DuccId duccId) {
        this.setDuccType(IDuccTypes.DuccType.Job);
        this.setDuccId(duccId);
        this.setStateObject((Object)IDuccState.JobState.Undefined);
        this.setCompletionTypeObject((Object)IDuccCompletionType.JobCompletionType.Undefined);
    }

    @Override
    public String getUserLogsDir() {
        String retVal = this.getLogDirectory();
        if (!retVal.endsWith(File.separator)) {
            retVal = retVal + File.separator;
        }
        return retVal;
    }

    @Override
    public DuccWorkPopDriver getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(DuccWorkPopDriver driver) {
        this.driver = driver;
    }

    @Override
    public String getjobBroker() {
        return this.jobBroker;
    }

    @Override
    public void setJobBroker(String broker) {
        this.jobBroker = broker;
    }

    @Override
    public String getjobQueue() {
        return this.jobQueue;
    }

    @Override
    public void setJobQueue(String queue) {
        this.jobQueue = queue;
    }

    @Override
    public IDuccState.JobState getJobState() {
        return (IDuccState.JobState)((Object)this.getStateObject());
    }

    @Override
    public void setJobState(IDuccState.JobState jobState) {
        this.setStateObject((Object)jobState);
    }

    @Override
    public void setCompletion(IDuccCompletionType.JobCompletionType completionType, IRationale completionRationale) {
        this.setCompletionType(completionType);
        this.setCompletionRationale(completionRationale);
    }

    @Override
    public IDuccCompletionType.JobCompletionType getCompletionType() {
        return (IDuccCompletionType.JobCompletionType)((Object)this.getCompletionTypeObject());
    }

    @Override
    public void setCompletionType(IDuccCompletionType.JobCompletionType completionType) {
        this.setCompletionTypeObject((Object)completionType);
    }

    @Override
    public IRationale getCompletionRationale() {
        IRationale retVal = null;
        try {
            retVal = this.completionRationale != null ? this.completionRationale : new Rationale();
        }
        catch (Exception e) {
            retVal = new Rationale();
        }
        return retVal;
    }

    @Override
    public void setCompletionRationale(IRationale completionRationale) {
        this.completionRationale = completionRationale;
    }

    @Override
    public boolean isActive() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case WaitingForDriver: 
            case WaitingForServices: 
            case WaitingForResources: 
            case Initializing: 
            case Running: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isSchedulable() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case WaitingForResources: 
            case Initializing: 
            case Running: 
            case Completing: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isInitialized() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case Running: 
            case Completing: 
            case Completed: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isRunnable() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case Running: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isCompleting() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case Completing: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isCompleted() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case Completed: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isFinished() {
        boolean retVal = false;
        switch (this.getJobState()) {
            case Completing: 
            case Completed: {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean isOperational() {
        boolean retVal = true;
        switch (this.getJobState()) {
            case Completed: {
                retVal = false;
            }
        }
        return retVal;
    }

    @Override
    public boolean isProcessReady() {
        IDuccProcessMap processMap = this.getProcessMap().deepCopy();
        return processMap.getReadyProcessCount() > 0;
    }

    @Override
    public int getFailedUnexpectedProcessCount() {
        IDuccProcessMap processMap = this.getProcessMap().deepCopy();
        return processMap.getFailedUnexpectedProcessCount();
    }

    @Override
    public String getLogDirectory() {
        String logDirectory;
        String retVal = System.getProperty("user.home");
        IDuccStandardInfo standardInfo = this.getStandardInfo();
        if (standardInfo != null && (logDirectory = standardInfo.getLogDirectory()) != null && logDirectory != "") {
            retVal = logDirectory;
        }
        if (!retVal.endsWith(File.separator)) {
            retVal = retVal + File.separator;
        }
        return retVal;
    }

    @Override
    public long getWorkItemCapacity() {
        long capacity = 0L;
        try {
            IDuccProcessMap processMap = this.getProcessMap();
            int threads_per_share = Integer.parseInt(this.getSchedulingInfo().getThreadsPerShare());
            capacity = processMap.getUsableProcessCount() * threads_per_share;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return capacity;
    }

    public IDuccProcess getProcess(String dpid) {
        IDuccProcess idp = null;
        try {
            long search = Long.parseLong(dpid.trim());
            IDuccProcessMap map = this.getProcessMap();
            Set keys = map.keySet();
            for (DuccId key : keys) {
                if (search != key.getFriendly()) continue;
                idp = (IDuccProcess)map.get(key);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idp;
    }

    @Override
    public long getProcessInitFailureCap() {
        long retVal = 0L;
        try {
            retVal = this.processInitFailureCap.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setProcessInitFailureCap(long value) {
        this.processInitFailureCap.set(value);
    }

    @Override
    public long getProcessInitFailureCount() {
        long retVal = this.getProcessMap().getFailedInitializationCount();
        return retVal;
    }

    @Override
    public long getProcessInitFailureLimit() {
        long retVal = this.defaultInitFailureLimit;
        try {
            retVal = this.processInitFailureLimit.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setProcessInitFailureLimit(long limit) {
        this.processInitFailureLimit.set(limit);
    }

    @Override
    public long getProcessFailureCount() {
        long retVal = this.getProcessMap().getFailedNotInitializationCount();
        return retVal;
    }

    @Override
    public long getProcessFailureLimit() {
        long retVal = this.defaultFailureLimit;
        try {
            retVal = this.processFailureLimit.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setProcessFailureLimit(long limit) {
        this.processFailureLimit.set(limit);
    }

    @Override
    public long getDebugPortDriver() {
        long retVal = -1L;
        try {
            retVal = this.debugPortDriver.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setDebugPortDriver(long port) {
        this.debugPortDriver.set(port);
    }

    @Override
    public long getDebugPortProcess() {
        long retVal = -1L;
        try {
            retVal = this.debugPortProcess.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setDebugPortProcess(long port) {
        this.debugPortProcess.set(port);
    }

    @Override
    public long getAliveProcessCount() {
        long retVal = 0L;
        IDuccProcessMap processMap = this.getProcessMap();
        if (processMap != null) {
            int count = processMap.getAliveProcessCount();
            retVal = count;
        }
        return retVal;
    }

    @Override
    public boolean hasAliveProcess() {
        return this.getAliveProcessCount() > 0L;
    }

    @Override
    public long getPgInCount() {
        DuccWorkPopDriver driver;
        long retVal = 0L;
        IDuccProcessMap map = this.getProcessMap();
        if (map != null) {
            retVal += map.getPgInCount();
        }
        if ((driver = this.getDriver()) != null) {
            map = driver.getProcessMap();
            retVal += map.getPgInCount();
        }
        return retVal;
    }

    @Override
    public double getSwapUsageGb() {
        DuccWorkPopDriver driver;
        double retVal = 0.0;
        IDuccProcessMap map = this.getProcessMap();
        if (map != null) {
            double swap = map.getSwapUsageGb();
            retVal += swap;
        }
        if ((driver = this.getDriver()) != null) {
            map = driver.getProcessMap();
            double swap = map.getSwapUsageGb();
            retVal += swap;
        }
        return retVal;
    }

    @Override
    public double getSwapUsageGbMax() {
        DuccWorkPopDriver driver;
        double retVal = 0.0;
        IDuccProcessMap map = this.getProcessMap();
        if (map != null) {
            double swap = map.getSwapUsageGbMax();
            retVal += swap;
        }
        if ((driver = this.getDriver()) != null) {
            map = driver.getProcessMap();
            double swap = map.getSwapUsageGbMax();
            retVal += swap;
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.driver == null || this.driver.getProcessMap() == null ? 0 : this.driver.getProcessMap().hashCode());
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            DuccWorkJob that = (DuccWorkJob)obj;
            if (this.driver == null && that.driver != null) {
                return false;
            }
            if (this.driver != null && that.driver == null) {
                return false;
            }
            if (this.driver == null && that.driver == null) {
                return super.equals(obj);
            }
            return Util.compare(this.driver.getProcessMap(), that.driver.getProcessMap()) && super.equals(obj);
        }
        System.out.println(">>>>>>>>>>>>>>>> What Class is it? " + obj.getClass().getName());
        return super.equals(obj);
    }
}

