/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccUnits;
import org.apache.uima.ducc.transport.event.jd.PerformanceMetricsSummaryMap;

public class DuccSchedulingInfo
implements IDuccSchedulingInfo {
    private static final long serialVersionUID = 1L;
    private String schedulingClass = "normal";
    private String schedulingPriority = "0";
    private String shareMemorySize = "13";
    private IDuccUnits.MemoryUnits shareMemoryUnits = defaultShareMemoryUnits;
    private String instancesCount = "1";
    @Deprecated
    private String machinesCount = "0";
    private String sharesMax = "0";
    private String sharesMin = "0";
    private String threadsPerShare = "1";
    private String workItemsTotal = "unknown";
    private String workItemsCompleted = "0";
    private String workItemsDispatched = "0";
    private String workItemsError = "0";
    private String workItemsRetry = "0";
    private String workItemsLost = "0";
    private String workItemsPreempt = "0";
    private ConcurrentHashMap<Integer, DuccId> limboMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DuccId> casQueuedMap = new ConcurrentHashMap();
    private IDuccPerWorkItemStatistics perWorkItemStatistics = null;
    private PerformanceMetricsSummaryMap performanceMetricsSummaryMap = null;
    private long mostRecentWorkItemStart = 0L;
    @Deprecated
    private String workItemsPending = "unknown";

    @Override
    public String getSchedulingClass() {
        return this.schedulingClass;
    }

    @Override
    public void setSchedulingClass(String schedulingClass) {
        if (schedulingClass != null) {
            this.schedulingClass = schedulingClass;
        }
    }

    @Override
    public String getSchedulingPriority() {
        return this.schedulingPriority;
    }

    @Override
    public void setSchedulingPriority(String schedulingPriority) {
        if (schedulingPriority != null) {
            this.schedulingPriority = schedulingPriority;
        }
    }

    @Override
    public String getInstancesCount() {
        return this.instancesCount;
    }

    @Override
    public void setInstancesCount(String instancesCount) {
        if (instancesCount != null) {
            this.instancesCount = instancesCount;
        }
    }

    @Override
    @Deprecated
    public String getMachinesCount() {
        return this.machinesCount;
    }

    @Override
    @Deprecated
    public void setMachinesCount(String machinesCount) {
        if (machinesCount != null) {
            this.machinesCount = machinesCount;
        }
    }

    @Override
    public String getShareMemorySize() {
        return this.shareMemorySize;
    }

    @Override
    public void setShareMemorySize(String size) {
        if (size != null) {
            this.shareMemorySize = size;
        }
    }

    @Override
    public IDuccUnits.MemoryUnits getShareMemoryUnits() {
        return this.shareMemoryUnits;
    }

    @Override
    public void setShareMemoryUnits(IDuccUnits.MemoryUnits units) {
        if (units != null) {
            this.shareMemoryUnits = units;
        }
    }

    @Override
    public long getLongSharesMax() {
        long retVal = -1L;
        try {
            retVal = Long.parseLong(this.sharesMax);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setLongSharesMax(long shares) {
        this.sharesMax = "" + shares;
    }

    @Override
    public String getSharesMax() {
        return this.sharesMax;
    }

    @Override
    public void setSharesMax(String shares) {
        if (shares != null) {
            this.sharesMax = shares.trim();
        }
    }

    @Override
    public String getSharesMin() {
        return this.sharesMin;
    }

    @Override
    public void setSharesMin(String shares) {
        if (shares != null) {
            this.sharesMin = shares;
        }
    }

    @Override
    public String getThreadsPerShare() {
        return this.threadsPerShare;
    }

    @Override
    public int getIntThreadsPerShare() {
        return Integer.parseInt(this.threadsPerShare);
    }

    @Override
    public void setThreadsPerShare(String number) {
        if (number != null) {
            this.threadsPerShare = number;
        }
    }

    @Override
    public String getWorkItemsTotal() {
        return this.workItemsTotal;
    }

    @Override
    public void setWorkItemsTotal(String number) {
        if (number != null) {
            this.workItemsTotal = number;
        }
    }

    @Override
    public int getIntWorkItemsTotal() {
        return Integer.parseInt(this.workItemsTotal);
    }

    @Override
    public String getWorkItemsCompleted() {
        return this.workItemsCompleted;
    }

    @Override
    public void setWorkItemsCompleted(String number) {
        if (number != null) {
            this.workItemsCompleted = number;
        }
    }

    @Override
    public int getIntWorkItemsCompleted() {
        return Integer.parseInt(this.workItemsCompleted);
    }

    @Override
    public String getWorkItemsDispatched() {
        return this.workItemsDispatched;
    }

    @Override
    public void setWorkItemsDispatched(String number) {
        if (number != null) {
            this.workItemsDispatched = number;
        }
    }

    @Override
    public ConcurrentHashMap<Integer, DuccId> getLimboMap() {
        if (this.limboMap == null) {
            return new ConcurrentHashMap<Integer, DuccId>();
        }
        return this.limboMap;
    }

    @Override
    public void setLimboMap(ConcurrentHashMap<Integer, DuccId> map) {
        if (map != null) {
            this.limboMap = map;
        }
    }

    @Override
    public ConcurrentHashMap<String, DuccId> getCasQueuedMap() {
        if (this.casQueuedMap == null) {
            return new ConcurrentHashMap<String, DuccId>();
        }
        return this.casQueuedMap;
    }

    @Override
    public void setCasQueuedMap(ConcurrentHashMap<String, DuccId> map) {
        if (map != null) {
            this.casQueuedMap = map;
        }
    }

    @Override
    public String getWorkItemsError() {
        return this.workItemsError;
    }

    @Override
    public void setWorkItemsError(String number) {
        if (number != null) {
            this.workItemsError = number;
        }
    }

    @Override
    public int getIntWorkItemsError() {
        return Integer.parseInt(this.workItemsError);
    }

    @Override
    public String getWorkItemsRetry() {
        return this.workItemsRetry;
    }

    @Override
    public void setWorkItemsRetry(String number) {
        if (number != null) {
            this.workItemsRetry = number;
        }
    }

    @Override
    public String getWorkItemsLost() {
        return this.workItemsLost;
    }

    @Override
    public void setWorkItemsLost(String number) {
        if (number != null) {
            this.workItemsLost = number;
        }
    }

    @Override
    public int getIntWorkItemsLost() {
        return Integer.parseInt(this.workItemsLost);
    }

    @Override
    public String getWorkItemsPreempt() {
        if (this.workItemsPreempt == null) {
            this.workItemsPreempt = "0";
        }
        return this.workItemsPreempt;
    }

    @Override
    public void setWorkItemsPreempt(String number) {
        if (number != null) {
            this.workItemsPreempt = number;
        }
    }

    @Override
    public IDuccPerWorkItemStatistics getPerWorkItemStatistics() {
        return this.perWorkItemStatistics;
    }

    @Override
    public void setPerWorkItemStatistics(IDuccPerWorkItemStatistics value) {
        this.perWorkItemStatistics = value;
    }

    @Override
    public PerformanceMetricsSummaryMap getPerformanceMetricsSummaryMap() {
        return this.performanceMetricsSummaryMap;
    }

    @Override
    public void setMostRecentWorkItemStart(long time) {
        this.mostRecentWorkItemStart = time;
    }

    @Override
    public long getMostRecentWorkItemStart() {
        return this.mostRecentWorkItemStart;
    }

    @Override
    @Deprecated
    public String getWorkItemsPending() {
        return this.workItemsPending;
    }

    @Override
    @Deprecated
    public void setWorkItemsPending(String number) {
        if (number != null) {
            this.workItemsPending = number;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instancesCount == null ? 0 : this.instancesCount.hashCode());
        result = 31 * result + (this.machinesCount == null ? 0 : this.machinesCount.hashCode());
        result = 31 * result + (this.schedulingClass == null ? 0 : this.schedulingClass.hashCode());
        result = 31 * result + (this.schedulingPriority == null ? 0 : this.schedulingPriority.hashCode());
        result = 31 * result + (this.shareMemorySize == null ? 0 : this.shareMemorySize.hashCode());
        result = 31 * result + (this.shareMemoryUnits == null ? 0 : this.shareMemoryUnits.hashCode());
        result = 31 * result + (this.sharesMax == null ? 0 : this.sharesMax.hashCode());
        result = 31 * result + (this.sharesMin == null ? 0 : this.sharesMin.hashCode());
        result = 31 * result + (this.threadsPerShare == null ? 0 : this.threadsPerShare.hashCode());
        result = 31 * result + (this.workItemsCompleted == null ? 0 : this.workItemsCompleted.hashCode());
        result = 31 * result + (this.workItemsDispatched == null ? 0 : this.workItemsDispatched.hashCode());
        result = 31 * result + (this.workItemsError == null ? 0 : this.workItemsError.hashCode());
        result = 31 * result + (this.workItemsPending == null ? 0 : this.workItemsPending.hashCode());
        result = 31 * result + (this.workItemsRetry == null ? 0 : this.workItemsRetry.hashCode());
        result = 31 * result + (this.workItemsTotal == null ? 0 : this.workItemsTotal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DuccSchedulingInfo other = (DuccSchedulingInfo)obj;
        if (this.instancesCount == null ? other.instancesCount != null : !this.instancesCount.equals(other.instancesCount)) {
            return false;
        }
        if (this.machinesCount == null ? other.machinesCount != null : !this.machinesCount.equals(other.machinesCount)) {
            return false;
        }
        if (this.schedulingClass == null ? other.schedulingClass != null : !this.schedulingClass.equals(other.schedulingClass)) {
            return false;
        }
        if (this.schedulingPriority == null ? other.schedulingPriority != null : !this.schedulingPriority.equals(other.schedulingPriority)) {
            return false;
        }
        if (this.shareMemorySize == null ? other.shareMemorySize != null : !this.shareMemorySize.equals(other.shareMemorySize)) {
            return false;
        }
        if (this.shareMemoryUnits != other.shareMemoryUnits) {
            return false;
        }
        if (this.sharesMax == null ? other.sharesMax != null : !this.sharesMax.equals(other.sharesMax)) {
            return false;
        }
        if (this.sharesMin == null ? other.sharesMin != null : !this.sharesMin.equals(other.sharesMin)) {
            return false;
        }
        if (this.threadsPerShare == null ? other.threadsPerShare != null : !this.threadsPerShare.equals(other.threadsPerShare)) {
            return false;
        }
        if (this.workItemsCompleted == null ? other.workItemsCompleted != null : !this.workItemsCompleted.equals(other.workItemsCompleted)) {
            return false;
        }
        if (this.workItemsDispatched == null ? other.workItemsDispatched != null : !this.workItemsDispatched.equals(other.workItemsDispatched)) {
            return false;
        }
        if (this.workItemsError == null ? other.workItemsError != null : !this.workItemsError.equals(other.workItemsError)) {
            return false;
        }
        if (this.workItemsPending == null ? other.workItemsPending != null : !this.workItemsPending.equals(other.workItemsPending)) {
            return false;
        }
        if (this.workItemsRetry == null ? other.workItemsRetry != null : !this.workItemsRetry.equals(other.workItemsRetry)) {
            return false;
        }
        if (this.workItemsTotal == null ? other.workItemsTotal != null : !this.workItemsTotal.equals(other.workItemsTotal)) {
            return false;
        }
        return this.mostRecentWorkItemStart == other.mostRecentWorkItemStart;
    }
}

