/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;

public class DuccProcessWorkItems
implements IDuccProcessWorkItems {
    private static final long serialVersionUID = 1L;
    private long unassigned = 0L;
    private AtomicLong dispatch = new AtomicLong(0L);
    private AtomicLong done = new AtomicLong(0L);
    private AtomicLong error = new AtomicLong(0L);
    private AtomicLong retry = new AtomicLong(0L);
    private AtomicLong lost = new AtomicLong(0L);
    private AtomicLong preempt = new AtomicLong(0L);
    private AtomicLong completedMillisTotal = new AtomicLong(0L);
    private AtomicLong completedMillisMax = new AtomicLong(0L);
    private AtomicLong completedMillisMin = new AtomicLong(0L);

    @Override
    public long getCountUnassigned() {
        return this.unassigned;
    }

    @Override
    public void setCountUnassigned(long count) {
        this.unassigned = count;
    }

    private void setMin(long update) {
        long min;
        this.completedMillisMin.compareAndSet(0L, update);
        while (update < (min = this.completedMillisMin.get())) {
            this.completedMillisMin.compareAndSet(min, update);
        }
    }

    private void setMax(long update) {
        long max;
        this.completedMillisMax.compareAndSet(0L, update);
        while (update > (max = this.completedMillisMax.get())) {
            this.completedMillisMax.compareAndSet(max, update);
        }
    }

    @Override
    public void done(long delta) {
        this.done.incrementAndGet();
        this.completedMillisTotal.addAndGet(delta);
        this.setMin(delta);
        this.setMax(delta);
        this.undispatch();
    }

    @Override
    public void error() {
        this.error.incrementAndGet();
        this.undispatch();
    }

    @Override
    public void retry() {
        this.retry.incrementAndGet();
        this.undispatch();
    }

    @Override
    public void lost() {
        this.lost.incrementAndGet();
    }

    @Override
    public void preempt() {
        this.preempt.incrementAndGet();
        this.undispatch();
    }

    @Override
    public void dispatch() {
        this.dispatch.incrementAndGet();
    }

    private void undispatch() {
        this.dispatch.decrementAndGet();
    }

    @Override
    public long getCountDispatch() {
        long retVal = 0L;
        try {
            retVal = this.dispatch.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountDone() {
        long retVal = 0L;
        try {
            retVal = this.done.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountError() {
        long retVal = 0L;
        try {
            retVal = this.error.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountRetry() {
        long retVal = 0L;
        try {
            retVal = this.retry.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountLost() {
        long retVal = 0L;
        try {
            retVal = this.lost.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getCountPreempt() {
        long retVal = 0L;
        try {
            retVal = this.preempt.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getSecsAvg() {
        long retVal = 0L;
        try {
            long count = this.done.get();
            if (count > 0L) {
                double msecs = (double)this.completedMillisTotal.get() / (double)count;
                retVal = (long)(msecs / 1000.0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getSecsMax() {
        long retVal = 0L;
        try {
            double msecs = this.completedMillisMax.get();
            retVal = (long)(msecs / 1000.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public long getSecsMin() {
        long retVal = 0L;
        try {
            double msecs = this.completedMillisMin.get();
            retVal = (long)(msecs / 1000.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }
}

