/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.SerializationUtils;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.Constants;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.Util;

public class DuccProcessMap
extends TreeMap<DuccId, IDuccProcess>
implements IDuccProcessMap {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcess(IDuccProcess process) {
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            this.put(process.getDuccId(), process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDuccProcess getProcess(DuccId duccId) {
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            return (IDuccProcess)this.get(duccId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcess(DuccId duccId) {
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            this.remove(duccId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDuccProcess findProcess(String nodeIP, String processId) {
        IDuccProcess retVal = null;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess duccProcess : this.values()) {
                String PID;
                String IP;
                NodeIdentity nodeIdentity = duccProcess.getNodeIdentity();
                if (nodeIdentity == null || (IP = nodeIdentity.getIp()) == null || (PID = duccProcess.getPID()) == null || !IP.equals(nodeIP) || !PID.equals(processId)) continue;
                retVal = duccProcess;
                break;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDuccProcess findProcess(DuccLogger duccLogger, String nodeIP, String processId) {
        String methodName = "findProcess";
        duccLogger.debug(methodName, null, new Object[]{"enter"});
        IDuccProcess retVal = null;
        duccLogger.debug(methodName, null, new Object[]{"input nodeIP:" + nodeIP + " " + "processId:" + processId});
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            Iterator iterator = this.values().iterator();
            duccLogger.debug(methodName, null, new Object[]{"iterator:" + iterator});
            while (iterator.hasNext()) {
                IDuccProcess duccProcess = (IDuccProcess)iterator.next();
                duccLogger.debug(methodName, null, new Object[]{"duccProcess:" + duccProcess});
                NodeIdentity nodeIdentity = duccProcess.getNodeIdentity();
                duccLogger.debug(methodName, null, new Object[]{"nodeIdentity:" + nodeIdentity});
                String IP = nodeIdentity.getIp();
                duccLogger.debug(methodName, null, new Object[]{"IP:" + IP});
                String PID = duccProcess.getPID();
                duccLogger.debug(methodName, null, new Object[]{"PID:" + PID});
                if (Util.compareNotNull(IP, nodeIP)) {
                    if (Util.compareNotNull(PID, processId)) {
                        retVal = duccProcess;
                        duccLogger.debug(methodName, null, new Object[]{"retVal:" + retVal});
                        break;
                    }
                    duccLogger.debug(methodName, null, new Object[]{">" + PID + "<"});
                    duccLogger.debug(methodName, null, new Object[]{">" + processId + "<"});
                    continue;
                }
                duccLogger.debug(methodName, null, new Object[]{">" + IP + "<"});
                duccLogger.debug(methodName, null, new Object[]{">" + nodeIP + "<"});
            }
        }
        duccLogger.debug(methodName, null, new Object[]{"exit"});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFailedUnexpectedProcessCount() {
        int retVal = 0;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            block6: for (IDuccProcess process : this.values()) {
                if (!process.isFailed()) continue;
                switch (process.getProcessDeallocationType()) {
                    case Forced: {
                        continue block6;
                    }
                }
                ++retVal;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReadyProcessCount() {
        int retVal = 0;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                if (!process.isReady()) continue;
                ++retVal;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUsableProcessCount() {
        int retVal = 0;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                if (process.isDeallocated() || !process.isReady()) continue;
                ++retVal;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAliveProcessCount() {
        int retVal = 0;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                if (process.isDefunct()) continue;
                ++retVal;
            }
        }
        return retVal;
    }

    @Override
    public Map<DuccId, IDuccProcess> getMap() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDuccProcessMap deepCopy() {
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            return (IDuccProcessMap)SerializationUtils.clone((Serializable)this);
        }
    }

    public static boolean isUserFailureReasonForStoppingProcess(String reason) {
        boolean retVal = false;
        if (reason != null) {
            if (reason.equals(IDuccProcess.ReasonForStoppingProcess.Croaked.name())) {
                retVal = true;
            } else if (reason.equals(IDuccProcess.ReasonForStoppingProcess.ExceededShareSize.name())) {
                retVal = true;
            } else if (reason.equals(IDuccProcess.ReasonForStoppingProcess.ExceededSwapThreshold.name())) {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean isFailedProcess(IDuccProcess process) {
        boolean retVal = false;
        IProcessState.ProcessState processState = process.getProcessState();
        String reason = process.getReasonForStoppingProcess();
        switch (processState) {
            case Failed: 
            case Stopped: 
            case Killed: {
                retVal = DuccProcessMap.isUserFailureReasonForStoppingProcess(reason);
            }
        }
        return retVal;
    }

    private boolean isFailedInitialization(IDuccProcess process) {
        boolean retVal = false;
        try {
            String reason = process.getReasonForStoppingProcess();
            if (IProcessState.ProcessState.FailedInitialization.name().equals(reason)) {
                retVal = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<DuccId> getFailedInitialization() {
        ArrayList<DuccId> list = new ArrayList<DuccId>();
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                if (process.isInitialized()) continue;
                if (this.isFailedInitialization(process)) {
                    list.add(process.getDuccId());
                    continue;
                }
                if (!this.isFailedProcess(process)) continue;
                list.add(process.getDuccId());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<DuccId> getFailedNotInitialization() {
        ArrayList<DuccId> list = new ArrayList<DuccId>();
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                if (!process.isInitialized() || !this.isFailedProcess(process)) continue;
                list.add(process.getDuccId());
            }
        }
        return list;
    }

    @Override
    public int getFailedInitializationCount() {
        ArrayList<DuccId> list = this.getFailedInitialization();
        return list.size();
    }

    @Override
    public int getFailedNotInitializationCount() {
        ArrayList<DuccId> list = this.getFailedNotInitialization();
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPgInCount() {
        long retVal = 0L;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                retVal += process.getMajorFaults();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSwapUsageGb() {
        double retVal = 0.0;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                double swap = process.getSwapUsage();
                retVal += swap / (double)Constants.GB;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getSwapUsageGbMax() {
        double retVal = 0.0;
        DuccProcessMap duccProcessMap = this;
        synchronized (duccProcessMap) {
            for (IDuccProcess process : this.values()) {
                double swap = process.getSwapUsageMax();
                retVal += swap / (double)Constants.GB;
            }
        }
        return retVal;
    }
}

