/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.rm.IResource;
import org.apache.uima.ducc.transport.event.rm.IRmJobState;
import org.apache.uima.ducc.transport.event.rm.IRmStateEvent;

public class RmStateDuccEvent
extends AbstractDuccEvent
implements IRmStateEvent {
    private static final long serialVersionUID = -5878153925779939796L;
    Map<DuccId, IRmJobState> rmJobState;

    public RmStateDuccEvent() {
        super(DuccEvent.EventType.RM_STATE);
    }

    public RmStateDuccEvent(Map<DuccId, IRmJobState> rmJobState) {
        super(DuccEvent.EventType.RM_STATE);
        this.rmJobState = rmJobState;
    }

    @Override
    public Map<DuccId, IRmJobState> getJobState() {
        return this.rmJobState;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("\n");
        ArrayList<IRmJobState> jobs = new ArrayList<IRmJobState>();
        jobs.addAll(this.rmJobState.values());
        Collections.sort(jobs, new JobByIdSorter());
        for (IRmJobState j : jobs) {
            int counter = 0;
            if (j.isRefused()) {
                buf.append(String.format("%s %s\n\tRefused: %s", new Object[]{j.getDuccType(), j.getId().getFriendly(), j.getReason()}));
                continue;
            }
            Map<DuccId, IResource> existing = j.getResources();
            if (existing == null) {
                buf.append(String.format("%s %s\n\tExisting[0]", new Object[]{j.getDuccType(), j.getId().getFriendly()}));
            } else {
                buf.append(String.format("%s %s\n\tExisting[%d]: ", new Object[]{j.getDuccType(), j.getId().getFriendly(), existing.size()}));
                for (IResource r : existing.values()) {
                    buf.append(r.toString());
                    buf.append(" ");
                    if (++counter % 10 != 0) continue;
                    buf.append("\n\t");
                }
                buf.append("\n");
            }
            counter = 0;
            Map<DuccId, IResource> additions = j.getPendingAdditions();
            if (additions == null) {
                buf.append(String.format("\tAdditions[0]", new Object[0]));
            } else {
                buf.append(String.format("\tAdditions[%d]: ", additions.size()));
                for (IResource r : additions.values()) {
                    buf.append(r.toString());
                    buf.append(" ");
                    if (++counter % 10 != 0) continue;
                    buf.append("\n\t");
                }
                buf.append("\n");
            }
            counter = 0;
            Map<DuccId, IResource> removals = j.getPendingRemovals();
            if (removals == null) {
                buf.append(String.format("\tRemovals[0]", new Object[0]));
                continue;
            }
            buf.append(String.format("\tRemovals[%d]: ", removals.size()));
            for (IResource r : removals.values()) {
                buf.append(r.toString());
                buf.append(" ");
                if (++counter % 10 != 0) continue;
                buf.append("\n\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private static class JobByIdSorter
    implements Comparator<IRmJobState> {
        private JobByIdSorter() {
        }

        @Override
        public int compare(IRmJobState j1, IRmJobState j2) {
            return (int)(j1.getId().getFriendly() - j2.getId().getFriendly());
        }
    }
}

