/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.dispatcher;

import java.io.BufferedInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobReplyDuccEvent;

public class DuccEventHttpDispatcher {
    private PostMethod method;
    private HttpClient httpclient = new HttpClient();
    static int socketTimeout = 0;

    public DuccEventHttpDispatcher(String targetEndpoint) throws Exception {
        this(targetEndpoint, socketTimeout);
    }

    public DuccEventHttpDispatcher(String targetEndpoint, int timeout) throws Exception {
        this.method = new PostMethod(targetEndpoint);
        this.httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.httpclient.getParams().setParameter("http.socket.timeout", (Object)timeout);
        this.httpclient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
    }

    public DuccEvent dispatchAndWaitForDuccReply(DuccEvent duccEvent) throws Exception {
        String serBody = XStreamUtils.marshall((Object)duccEvent);
        StringRequestEntity re = new StringRequestEntity(serBody, "application/xml", "UTF8");
        this.method.setRequestEntity((RequestEntity)re);
        this.method.setRequestHeader("Content-Type", "text/xml");
        this.httpclient.executeMethod((HttpMethod)this.method);
        if (this.method.getStatusLine().getStatusCode() == 200) {
            StringBuffer sb = new StringBuffer();
            byte[] slice = new byte[4096];
            int bytes_read = 0;
            BufferedInputStream bis = new BufferedInputStream(this.method.getResponseBodyAsStream());
            while ((bytes_read = bis.read(slice, 0, slice.length)) != -1) {
                sb.append(new String(slice, 0, bytes_read));
            }
            return (DuccEvent)XStreamUtils.unmarshall((String)sb.toString());
        }
        String body = this.method.getResponseBodyAsString();
        throw new DuccRuntimeException("Ducc Unable to Process Request. Http Response Code:" + this.method.getStatusLine().getStatusCode() + ". Ducc Service (OR) Returned Exception:", new Exception(body));
    }

    public void close() {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    public static void main(String[] args) {
        try {
            DuccEventHttpDispatcher dispatcher = new DuccEventHttpDispatcher("http://" + args[0] + ":19988/or", 4000);
            SubmitJobDuccEvent duccEvent = new SubmitJobDuccEvent(null);
            DuccEvent event = dispatcher.dispatchAndWaitForDuccReply(duccEvent);
            if (event instanceof SubmitJobReplyDuccEvent) {
                System.out.println("Client received SubmitJobReplyDuccEvent");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            String st = System.getProperty("ducc.cli.httpclient.sotimeout");
            if (st != null) {
                socketTimeout = Integer.parseInt(st);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

