/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.dispatcher;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.dataformat.xstream.XStreamDataFormat;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.transport.event.DuccEvent;

public class DuccEventDispatcher {
    private ProducerTemplate pt;
    private String targetEndpoint;
    CamelContext context;

    public DuccEventDispatcher(CamelContext context) {
        this.pt = context.createProducerTemplate();
    }

    public DuccEventDispatcher(CamelContext context, String targetEndpoint) {
        this.pt = context.createProducerTemplate();
        this.context = context;
        this.targetEndpoint = targetEndpoint;
    }

    private String marshallDuccEvent(DuccEvent duccEvent) throws Exception {
        XStreamDataFormat xStreamDataFormat = new XStreamDataFormat();
        XStream xStream = xStreamDataFormat.getXStream((ClassResolver)new DefaultClassResolver());
        return xStream.toXML((Object)duccEvent);
    }

    private DuccEvent unmarshallDuccEvent(Object targetToUnmarshall) throws Exception {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        String claz = targetToUnmarshall.getClass().getName();
        if (targetToUnmarshall instanceof byte[]) {
            Object reply = xStream.fromXML(new String((byte[])targetToUnmarshall));
            if (reply instanceof DuccEvent) {
                return (DuccEvent)reply;
            }
            claz = reply == null ? "NULL" : reply.getClass().getName();
        }
        throw new Exception("Unexpected Reply type received from Ducc Component. Expected DuccEvent, instead received:" + claz);
    }

    public void dispatch(int serviceSocketPort, DuccEvent duccEvent) throws Exception {
        this.pt.sendBody("mina:tcp://localhost:" + serviceSocketPort + "?transferExchange=true&sync=false", (Object)duccEvent);
    }

    public void dispatch(String targetEndpoint, DuccEvent duccEvent) throws Exception {
        this.dispatch(targetEndpoint, duccEvent, null);
    }

    public void dispatch(DuccEvent duccEvent, String nodeList) throws Exception {
        this.dispatch(this.targetEndpoint, duccEvent, nodeList);
    }

    public void dispatch(String endpoint, DuccEvent duccEvent, String nodeList) throws Exception {
        try {
            if (nodeList != null) {
                this.pt.sendBodyAndHeader(endpoint, (Object)duccEvent, "target-nodes", (Object)nodeList);
            } else {
                this.pt.asyncRequestBody(endpoint, (Object)duccEvent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispatch(String serializedEvent) throws Exception {
        this.pt.sendBody(this.targetEndpoint, (Object)serializedEvent);
    }

    public void dispatch(DuccEvent duccEvent) throws Exception {
        this.pt.asyncSendBody(this.targetEndpoint, (Object)duccEvent);
    }

    public void dispatch(DuccEvent duccEvent, Map<String, Object> headers) throws Exception {
        this.pt.sendBodyAndHeaders(this.targetEndpoint, (Object)duccEvent, headers);
    }

    public void dispatch(DuccEvent duccEvent, String serviceEndpoint, Map<String, Object> headers) throws Exception {
        this.pt.sendBodyAndHeaders(serviceEndpoint, (Object)duccEvent, headers);
    }

    public DuccEvent dispatchAndWaitForDuccReply(DuccEvent duccEvent) throws Exception {
        int i;
        int maxRetryCount = 20;
        Object reply = null;
        RuntimeExchangeException ree = null;
        for (i = 0; i < maxRetryCount; ++i) {
            try {
                reply = this.pt.sendBody(this.targetEndpoint, ExchangePattern.InOut, (Object)this.marshallDuccEvent(duccEvent));
                ree = null;
                break;
            }
            catch (RuntimeExchangeException e) {
                String msg = e.getMessage();
                if (msg == null || !msg.startsWith("Failed to resolve replyTo destination on the exchange")) {
                    throw new DuccRuntimeException("Ducc JMS Dispatcher is unable to deliver a request.", (Exception)((Object)e));
                }
                ree = e;
                continue;
            }
        }
        if (i == maxRetryCount) {
            throw new DuccRuntimeException("ActiveMQ failed to create temp reply queue. After 20 attempts to deliver request to the OR, Ducc JMS Dispatcher is giving up.", ree);
        }
        return this.unmarshallDuccEvent(reply);
    }

    public void stop() throws Exception {
        if (this.pt != null) {
            this.pt.stop();
        }
    }
}

