/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.cmdline;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.transport.cmdline.ACommandLine;

public class JavaCommandLine
extends ACommandLine {
    private String className;
    private String classpath;
    protected List<String> options = new ArrayList<String>();

    public JavaCommandLine(String executable) {
        super(executable);
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public List<String> getOptions() {
        return this.options;
    }

    @Override
    public String[] getCommandLine() {
        String[] os = new String[this.options.size()];
        String[] args = new String[this.args.size()];
        if (this.args == null || this.args.size() == 0) {
            return super.concatAllArrays(this.options.toArray(os), new String[][]{{"-classpath", this.classpath, this.className}});
        }
        return super.concatAllArrays(this.options.toArray(os), {"-classpath", this.classpath, this.className}, this.args.toArray(args));
    }

    public String getCommand() {
        String retVal = "";
        for (String part : this.getCommandLine()) {
            retVal = retVal + " " + part;
        }
        return retVal;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void prependToClasspath(String cp) {
        if (!cp.trim().endsWith(System.getProperty("path.separator"))) {
            cp = cp.trim() + System.getProperty("path.separator");
        }
        this.classpath = cp + this.classpath;
    }

    public static void main(String[] args) {
        try {
            JavaCommandLine cmdLine = new JavaCommandLine("/share/jdk1.6/bin/java");
            cmdLine.addOption("-Xmx=200M");
            cmdLine.addOption("-Xms=100M");
            cmdLine.addOption("-DUIMA_HOME=$HOME/uima");
            cmdLine.setClasspath("$UIMA_HOME/lib/*;$UIMA_HOME/lib/optional/*");
            cmdLine.setClassName("org.apache.uima.ducc.agent.deploy.ManagedUimaService");
            cmdLine.addArgument("/tmp/UimaASDeploymentDescriptor.xml");
            for (String part : cmdLine.getCommandLine()) {
                System.out.println("-- " + part);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

