/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.admin.event.RmAdminQLoadReply;
import org.apache.uima.ducc.common.admin.event.RmAdminQOccupancyReply;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.admin.event.RmAdminVaryReply;
import org.apache.uima.ducc.common.admin.event.RmQueriedClass;
import org.apache.uima.ducc.common.admin.event.RmQueriedMachine;
import org.apache.uima.ducc.common.admin.event.RmQueriedNodepool;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.persistence.rm.IDbJob;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.RmPersistenceFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.rm.scheduler.IJobManager;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.IScheduler;
import org.apache.uima.ducc.rm.scheduler.ISchedulerMain;
import org.apache.uima.ducc.rm.scheduler.JobManagerUpdate;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.RmJob;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedInternalError;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.SchedulingUpdate;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.rm.scheduler.User;

public class Scheduler
implements ISchedulerMain,
SchedConstants {
    IJobManager jobManager;
    static DuccLogger logger = DuccLogger.getLogger(Scheduler.class, (String)"RM");
    boolean done = false;
    String ducc_home;
    NodeConfiguration configuration = null;
    String defaultDomain = null;
    boolean needRecovery = false;
    AbstractDuccComponent baseComponent;
    NodePool[] nodepools;
    int max_order = 0;
    Map<DuccId, Share> busyShares = new HashMap<DuccId, Share>();
    Map<DuccId, Pair<IRmJob, Share>> vacatedShares = new HashMap<DuccId, Pair<IRmJob, Share>>();
    List<IRmJob> incomingJobs = new ArrayList<IRmJob>();
    List<IRmJob> recoveredJobs = new ArrayList<IRmJob>();
    List<IRmJob> completedJobs = new ArrayList<IRmJob>();
    List<IRmJob> initializedJobs = new ArrayList<IRmJob>();
    Map<Node, Node> deadNodes = new HashMap<Node, Node>();
    Map<Node, Integer> illNodes = new HashMap<Node, Integer>();
    Map<String, NodePool> nodepoolsByNode = new HashMap<String, NodePool>();
    Map<String, String> shortToLongNode = new HashMap<String, String>();
    Map<String, User> users = new HashMap<String, User>();
    Map<DuccId, IRmJob> allJobs = new HashMap<DuccId, IRmJob>();
    Map<ResourceClass, ResourceClass> resourceClasses = new HashMap<ResourceClass, ResourceClass>();
    Map<String, ResourceClass> resourceClassesByName = new HashMap<String, ResourceClass>();
    String defaultFairShareName = null;
    String defaultReserveName = null;
    int defaultNThreads = 1;
    int defaultNTasks = 10;
    int defaultMemory = 15;
    String schedImplName;
    IScheduler[] schedulers;
    long share_free_dram = 0L;
    long dramOverride = 0L;
    int pending_evictions = 0;
    int pending_expansions = 0;
    SchedConstants.EvictionPolicy evictionPolicy = SchedConstants.EvictionPolicy.SHRINK_BY_MACHINE;
    int nodeStability = 3;
    boolean stability = false;
    private static DuccIdFactory idFactory;
    IRmPersistence persistence = null;
    static final int rmversion_major = 2;
    static final int rmversion_minor = 0;
    static final int rmversion_ptf = 0;
    static final String rmversion_string;
    boolean initialized = false;
    private int total_arrivals = 0;

    public Scheduler(AbstractDuccComponent baseComponent) {
        this.baseComponent = baseComponent;
    }

    @Override
    public synchronized void init() throws Exception {
        String methodName = "init";
        DuccLogger.setUnthreaded();
        String ep = SystemPropertyResolver.getStringProperty((String)"ducc.rm.eviction.policy", (String)"SHRINK_BY_MACHINE");
        this.evictionPolicy = SchedConstants.EvictionPolicy.valueOf(ep);
        this.share_free_dram = SystemPropertyResolver.getLongProperty((String)"ducc.rm.reserved.dram", (long)this.share_free_dram) * 1024L * 1024L;
        this.ducc_home = SystemPropertyResolver.getStringProperty((String)"DUCC_HOME");
        this.defaultNTasks = SystemPropertyResolver.getIntProperty((String)"ducc.rm.default.tasks", (int)10);
        this.defaultNThreads = SystemPropertyResolver.getIntProperty((String)"ducc.rm.default.threads", (int)1);
        this.defaultMemory = SystemPropertyResolver.getIntProperty((String)"ducc.rm.default.memory", (int)15);
        this.nodeStability = SystemPropertyResolver.getIntProperty((String)"ducc.rm.node.stability", (int)3);
        this.dramOverride = SystemPropertyResolver.getLongProperty((String)"ducc.rm.override.dram", (long)0L);
        if (this.dramOverride > 0L) {
            this.dramOverride *= 0x100000L;
        }
        if (idFactory == null) {
            idFactory = new DuccIdFactory(1L);
        }
        String class_definitions = SystemPropertyResolver.getStringProperty((String)"ducc.rm.class.definitions", (String)"scheduler.classes");
        class_definitions = System.getProperty("DUCC_HOME") + "/resources/" + class_definitions;
        try {
            this.initClasses();
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
            throw e;
        }
        logger.info(methodName, null, new Object[]{"                       reserved DRAM           : ", this.share_free_dram / 0x100000L, " GB"});
        logger.info(methodName, null, new Object[]{"                       DRAM override           : ", this.dramOverride / 0x100000L, " GB"});
        logger.info(methodName, null, new Object[]{"                       scheduler               : ", this.schedImplName});
        logger.info(methodName, null, new Object[]{"                       default threads         : ", this.defaultNThreads});
        logger.info(methodName, null, new Object[]{"                       default tasks           : ", this.defaultNTasks});
        logger.info(methodName, null, new Object[]{"                       default memory          : ", this.defaultMemory});
        logger.info(methodName, null, new Object[]{"                       default fairshare class : ", this.defaultFairShareName});
        logger.info(methodName, null, new Object[]{"                       default reserve         : ", this.defaultReserveName});
        logger.info(methodName, null, new Object[]{"                       reserve overage         : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.reserve_overage", (int)0), " GB"});
        logger.info(methodName, null, new Object[]{"                       class definition file   : ", class_definitions});
        logger.info(methodName, null, new Object[]{"                       default domain          : ", this.defaultDomain});
        logger.info(methodName, null, new Object[]{"                       eviction policy         : ", this.evictionPolicy});
        logger.info(methodName, null, new Object[]{"                       database enabled        : ", !System.getProperty("ducc.database.host").equals("--disabled--")});
        logger.info(methodName, null, new Object[]{"                       database implementation : ", System.getProperty("ducc.rm.persistence.impl")});
        logger.info(methodName, null, new Object[]{"                       use prediction          : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.prediction", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       prediction fudge factor : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.prediction.fudge", (int)10000)});
        logger.info(methodName, null, new Object[]{"                       node stability          : ", this.nodeStability});
        logger.info(methodName, null, new Object[]{"                       init stability          : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.init.stability")});
        logger.info(methodName, null, new Object[]{"                       fast recovery           : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.fast.recovery", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       metrics update rate     : ", SystemPropertyResolver.getIntProperty((String)"ducc.agent.node.metrics.publish.rate", (int)60000)});
        logger.info(methodName, null, new Object[]{"                       initialization cap      : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.initialization.cap")});
        logger.info(methodName, null, new Object[]{"                       expand by doubling      : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.expand.by.doubling", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       fragmentation threshold : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.fragmentation.threshold", (int)2)});
        logger.info(methodName, null, new Object[]{"                       do defragmentation      : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.defragmentation", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       DUCC home               : ", System.getProperty("DUCC_HOME")});
        logger.info(methodName, null, new Object[]{"                       ActiveMQ URL            : ", SystemPropertyResolver.getStringProperty((String)"ducc.broker.url")});
        logger.info(methodName, null, new Object[]{"                       JVM                     : ", System.getProperty("java.vendor") + " " + System.getProperty("java.version")});
        logger.info(methodName, null, new Object[]{"                       JAVA_HOME               : ", System.getProperty("java.home")});
        logger.info(methodName, null, new Object[]{"                       JVM Path                : ", System.getProperty("ducc.jvm")});
        logger.info(methodName, null, new Object[]{"                       JMX URL                 : ", System.getProperty("ducc.jmx.url")});
        logger.info(methodName, null, new Object[]{"                       OS Architecture         : ", System.getProperty("os.arch")});
        logger.info(methodName, null, new Object[]{"                       OS Name                 : ", System.getProperty("os.name")});
        logger.info(methodName, null, new Object[]{"                       DUCC Version            : ", Version.version()});
        logger.info(methodName, null, new Object[]{"                       RM Version              : ", "2.0.0"});
        this.persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)"RM");
        this.persistence.clear();
        this.initialized = true;
    }

    @Override
    public RmAdminReply reconfigure() {
        String methodName = "reconfigure";
        RmAdminReply ret = new RmAdminReply();
        logger.info(methodName, null, new Object[]{"Reconfiguration starts."});
        this.setInitialized(false);
        try {
            this.readConfiguration();
        }
        catch (Throwable e) {
            this.setInitialized(true);
            logger.warn(methodName, null, new Object[]{"Reconfiguration aborted:", e.toString()});
            ret.setRc(false);
            ret.setMessage("Reconfiguration failed: " + e.toString());
            return ret;
        }
        HashMap<Node, Machine> offlineMachines = new HashMap<Node, Machine>();
        for (NodePool np : this.nodepools) {
            offlineMachines.putAll(np.getOfflineMachines());
        }
        ArrayList<String> offlineHostnames = new ArrayList<String>();
        for (Machine m : offlineMachines.values()) {
            logger.info(methodName, null, new Object[]{"Saving offline status of", m.getId()});
            offlineHostnames.add(m.getId());
        }
        offlineMachines = null;
        this.configuration = null;
        this.defaultDomain = null;
        this.nodepools = null;
        this.max_order = 0;
        this.busyShares.clear();
        this.vacatedShares.clear();
        this.incomingJobs.clear();
        this.recoveredJobs.clear();
        this.initializedJobs.clear();
        this.deadNodes.clear();
        this.nodepoolsByNode.clear();
        this.shortToLongNode.clear();
        this.users.clear();
        this.allJobs.clear();
        this.resourceClasses.clear();
        this.resourceClassesByName.clear();
        try {
            this.baseComponent.reloadProperties("ducc.deploy.configuration");
            this.init();
            if (offlineHostnames.size() > 0) {
                String[] offline = offlineHostnames.toArray(new String[offlineHostnames.size()]);
                this.varyoff(offline);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setRecovery(true);
        this.setInitialized(true);
        logger.info(methodName, null, new Object[]{"Reconfiguration complete."});
        ret.setMessage("Reconfiguration complete.");
        return ret;
    }

    @Override
    public synchronized void setRecovery(boolean v) {
        this.needRecovery = v;
    }

    @Override
    public synchronized boolean mustRecover() {
        return this.needRecovery;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void setInitialized(boolean v) {
        this.initialized = v;
    }

    public Machine getMachine(Node n) {
        return this.getMachine(n.getNodeIdentity());
    }

    @Override
    public Machine getMachine(NodeIdentity ni) {
        NodePool nodepool = this.getNodepoolByName(ni);
        return nodepool.getMachine(ni);
    }

    public void setJobManager(IJobManager jobmanager) {
        this.jobManager = jobmanager;
    }

    @Override
    public String getDefaultFairShareName() {
        return this.defaultFairShareName;
    }

    @Override
    public String getDefaultReserveName() {
        return this.defaultReserveName;
    }

    @Override
    public int getDefaultNThreads() {
        return this.defaultNThreads;
    }

    @Override
    public int getDefaultNTasks() {
        return this.defaultNTasks;
    }

    @Override
    public int getDefaultMemory() {
        return this.defaultMemory;
    }

    @Override
    public ResourceClass getResourceClass(String name) {
        return this.resourceClassesByName.get(name);
    }

    @Override
    public IRmJob getJob(DuccId id) {
        return this.allJobs.get(id);
    }

    @Override
    public Share getShare(DuccId id) {
        return this.busyShares.get(id);
    }

    @Override
    public int calcShareOrder(IRmJob j) {
        long mem = j.getMemory() << 20;
        int share_quantum = j.getShareQuantum();
        int share_order = (int)(mem / (long)share_quantum);
        if (mem % (long)share_quantum > 0L) {
            ++share_order;
        }
        return share_order;
    }

    void getClassesForNodepool(DuccProperties dp, Map<ResourceClass, ResourceClass> ret) {
        List children;
        List class_set = (List)dp.get((Object)"classes");
        if (class_set != null) {
            for (DuccProperties cl : class_set) {
                ResourceClass rc = this.resourceClassesByName.get(cl.getStringProperty("name"));
                ret.put(rc, rc);
            }
        }
        if ((children = (List)dp.get((Object)"children")) != null) {
            for (DuccProperties child : children) {
                this.getClassesForNodepool(child, ret);
            }
        }
    }

    void mapNodesToNodepool(Map<String, String> nodes, NodePool pool) {
        if (nodes == null) {
            return;
        }
        for (String s : nodes.keySet()) {
            this.updateNodepoolsByNode(s, pool);
        }
    }

    void createSubpools(NodePool parent, List<DuccProperties> children) {
        if (children == null) {
            return;
        }
        for (DuccProperties dp : children) {
            String id = dp.getStringProperty("name");
            Map nodes = (Map)dp.get((Object)"nodes");
            int search_order = dp.getIntProperty("search-order", 100);
            NodePool child = parent.createSubpool(id, nodes, search_order);
            this.mapNodesToNodepool(nodes, child);
            List grandkids = (List)dp.get((Object)"children");
            this.createSubpools(child, grandkids);
        }
    }

    NodeConfiguration readConfiguration() throws Exception {
        String class_definitions = SystemPropertyResolver.getStringProperty((String)"ducc.rm.class.definitions", (String)"scheduler.classes");
        String user_registry = SystemPropertyResolver.getStringProperty((String)"ducc.rm.user.registry", (String)"ducc.users");
        class_definitions = System.getProperty("DUCC_HOME") + "/resources/" + class_definitions;
        String me = Scheduler.class.getName() + ".Config";
        DuccLogger initLogger = new DuccLogger(me, "RM");
        NodeConfiguration nc = new NodeConfiguration(class_definitions, null, user_registry, initLogger);
        nc.readConfiguration();
        return nc;
    }

    void initClasses() {
        String methodName = "initClasses";
        try {
            this.configuration = this.readConfiguration();
        }
        catch (Throwable e) {
            logger.error(methodName, null, e, new Object[0]);
            logger.error(methodName, null, new Object[]{"Scheduler exits: unable to read configuration."});
            System.out.println("Scheduler exits: unable to read configuration.");
            e.printStackTrace();
            System.exit(1);
        }
        this.defaultDomain = this.configuration.getDefaultDomain();
        this.configuration.printConfiguration();
        DuccProperties[] nps = this.configuration.getToplevelNodepools();
        Map cls = this.configuration.getClasses();
        this.nodepools = new NodePool[nps.length];
        this.schedulers = new IScheduler[nps.length];
        logger.info(methodName, null, new Object[]{"Classes:"});
        logger.info(methodName, null, new Object[]{ResourceClass.getHeader()});
        logger.info(methodName, null, new Object[]{ResourceClass.getDashes()});
        for (DuccProperties props : cls.values()) {
            ResourceClass rc = new ResourceClass(props);
            this.resourceClasses.put(rc, rc);
            this.resourceClassesByName.put(rc.getName(), rc);
            logger.info(methodName, null, new Object[]{rc.toString()});
        }
        DuccProperties dc = this.configuration.getDefaultFairShareClass();
        if (dc != null) {
            this.defaultFairShareName = dc.getProperty("name");
        }
        if ((dc = this.configuration.getDefaultReserveClass()) != null) {
            this.defaultReserveName = dc.getProperty("name");
        }
        try {
            this.schedImplName = SystemPropertyResolver.getStringProperty((String)"ducc.rm.scheduler", (String)"org.apache.uima.ducc.rm.ClassBasedScheduler");
            Class<?> cl = Class.forName(this.schedImplName);
            for (int i = 0; i < nps.length; ++i) {
                logger.info(methodName, null, new Object[]{"Rebuilding", this.schedImplName, "for top level nodepool", nps[i].get((Object)"name")});
                this.schedulers[i] = (IScheduler)cl.newInstance();
                this.schedulers[i].setEvictionPolicy(this.evictionPolicy);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SchedulingException(null, "Cannot find class " + this.schedImplName);
        }
        catch (InstantiationException e) {
            throw new SchedulingException(null, "Cannot instantiate class " + this.schedImplName);
        }
        catch (IllegalAccessException e) {
            throw new SchedulingException(null, "Cannot instantiate class " + this.schedImplName + ": can't access constructor.");
        }
        for (int i = 0; i < nps.length; ++i) {
            DuccProperties np = nps[i];
            String id = np.getStringProperty("name");
            Map nodes = (Map)np.get((Object)"nodes");
            int search_order = np.getIntProperty("search-order", 100);
            int q = np.getIntProperty("share-quantum", 15) << 20;
            this.nodepools[i] = new NodePool(null, id, nodes, this.evictionPolicy, 0, search_order, q);
            this.schedulers[i].setNodePool(this.nodepools[i]);
            this.mapNodesToNodepool(nodes, this.nodepools[i]);
            logger.info(methodName, null, new Object[]{"Created top-level nodepool", id});
            List children = (List)np.get((Object)"children");
            this.createSubpools(this.nodepools[i], children);
            HashMap<ResourceClass, ResourceClass> classesForNp = new HashMap<ResourceClass, ResourceClass>();
            this.getClassesForNodepool(np, classesForNp);
            for (ResourceClass rc : classesForNp.values()) {
                String rcid = rc.getNodepoolName();
                if (rcid == null) continue;
                NodePool subpool = this.nodepools[i].getSubpool(rcid);
                rc.setNodepool(subpool);
                logger.info(methodName, null, new Object[]{"Assign rc", rc.getName(), "to np", subpool.getId()});
                subpool.addResourceClass(rc);
            }
            this.schedulers[i].setClasses(classesForNp);
        }
        Map usrs = this.configuration.getUsers();
        for (Object o : usrs.keySet()) {
            String n = (String)o;
            DuccProperties dp = (DuccProperties)usrs.get(n);
            for (Object l : dp.keySet()) {
                if (!((String)l).startsWith("max-allotment")) continue;
                String val = ((String)dp.get(l)).trim();
                int lim = Integer.parseInt(val);
                User user = this.users.get(n);
                if (user == null) {
                    user = new User(n);
                    this.users.put(n, user);
                }
                if (val.contains(".")) {
                    String[] tmp = ((String)l).split("\\.");
                    ResourceClass rc = this.resourceClassesByName.get(tmp[1]);
                    user.overrideLimit(rc, lim);
                    continue;
                }
                user.overrideGlobalLimit(lim);
            }
        }
    }

    private JobManagerUpdate dispatch(SchedulingUpdate upd, JobManagerUpdate jmu) {
        HashMap<Share, Share> sharesN;
        HashMap<Share, Share> sharesE;
        String methodName = "dispatch";
        this.pending_evictions = 0;
        this.pending_expansions = 0;
        HashMap<IRmJob, IRmJob> jobs = upd.getShrunkenJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{">>>>>>>>>> SHRINK"});
            sharesE = j.getAssignedShares();
            HashMap<Share, Share> sharesR = j.getPendingRemoves();
            logger.trace(methodName, j.getId(), new Object[]{"removing", sharesR.size(), "of existing", sharesE.size(), "shares."});
            this.pending_evictions += sharesR.size() * j.getShareOrder();
            for (Share s : sharesE.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    current", s.toString()});
            }
            for (Share s : sharesR.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    remove ", s.toString()});
            }
            logger.trace(methodName, j.getId(), new Object[]{">>>>>>>>>>"});
            jmu.removeShares(j, sharesR);
        }
        jobs = upd.getExpandedJobs();
        for (IRmJob j : jobs.values()) {
            sharesE = j.getAssignedShares();
            sharesN = j.getPendingShares();
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<  EXPAND"});
            logger.trace(methodName, j.getId(), new Object[]{"adding", sharesN.size(), "new shares to existing", sharesE.size(), "shares."});
            this.pending_expansions += sharesN.size() * j.getShareOrder();
            for (Share s : sharesE.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    existing ", s.toString()});
            }
            for (Share s : sharesN.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    expanding", s.toString()});
            }
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<"});
            sharesN = j.promoteShares();
            if (sharesN.size() == 0) {
                throw new SchedulingException(j.getId(), "Trying to execute expanded job but no pending machines.");
            }
            for (Share s : sharesN.values()) {
                this.busyShares.put(s.getId(), s);
            }
            jmu.addShares(j, sharesN);
        }
        jobs = upd.getStableJobs();
        for (IRmJob j : jobs.values()) {
            if (j.countNShares() < 0) {
                throw new SchedulingException(j.getId(), "Share count went negative " + j.countNShares());
            }
            logger.trace(methodName, j.getId(), new Object[]{".......... STABLE with ", j.countNShares(), " shares."});
        }
        jobs = upd.getDormantJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{".......... DORMANT"});
        }
        jobs = upd.getReservedJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<  RESERVE"});
            sharesE = j.getAssignedShares();
            sharesN = j.getPendingShares();
            if (sharesE.size() == j.getMaxShares()) {
                logger.trace(methodName, j.getId(), new Object[]{"reserve_stable", sharesE.size(), "machines"});
            } else if (sharesN.size() == j.getMaxShares()) {
                logger.trace(methodName, j.getId(), new Object[]{"reserve_adding", sharesN.size(), "machines"});
                for (Share s : sharesN.values()) {
                    logger.trace(methodName, j.getId(), new Object[]{"    reserve_expanding ", s.toString()});
                }
                jmu.addShares(j, sharesN);
                j.promoteShares();
            } else {
                logger.trace(methodName, j.getId(), new Object[]{"reserve_pending", j.getMaxShares(), "machines"});
            }
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<"});
        }
        jmu.setAllJobs((HashMap)this.allJobs);
        jobs = upd.getRefusedJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{".......... REFUSED"});
        }
        return jmu;
    }

    @Override
    public synchronized boolean ready() {
        return this.stability;
    }

    @Override
    public synchronized void start() {
        this.stability = true;
    }

    @Override
    public void stop() {
        this.persistence.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIllNodes() {
        String methodName = "handleIllNodes";
        if (!this.isInitialized()) {
            logger.info(methodName, null, new Object[]{"Waiting for (re)initialization."});
            return;
        }
        HashMap<Node, Integer> nodeUpdates = new HashMap<Node, Integer>();
        Object object = this.illNodes;
        synchronized (object) {
            nodeUpdates.putAll(this.illNodes);
            this.illNodes.clear();
        }
        object = this;
        synchronized (object) {
            for (Node n : nodeUpdates.keySet()) {
                Machine m = this.getMachine(n);
                if (m == null) {
                    logger.warn(methodName, null, new Object[]{"Cannot find any record of machine", n.getNodeIdentity().getName()});
                    continue;
                }
                int count = (Integer)nodeUpdates.get(n);
                if (count == 0) {
                    m.heartbeatArrives();
                    continue;
                }
                m.heartbeatMissed(count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeadNodes() {
        String methodName = "handleDeadNodes";
        if (!this.isInitialized()) {
            logger.info(methodName, null, new Object[]{"Waiting for (re)initialization."});
            return;
        }
        HashMap<Node, Node> nodeUpdates = new HashMap<Node, Node>();
        Object object = this.deadNodes;
        synchronized (object) {
            nodeUpdates.putAll(this.deadNodes);
            this.deadNodes.clear();
        }
        object = this;
        synchronized (object) {
            for (Node n : nodeUpdates.values()) {
                Machine m = this.getMachine(n);
                if (m == null) continue;
                logger.warn(methodName, null, new Object[]{"***Purging machine***", m.getId(), "due to missed heartbeats. THreshold:", this.nodeStability});
                NodePool np = m.getNodepool();
                np.nodeLeaves(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public JobManagerUpdate schedule() {
        String methodName = "schedule";
        if (!this.ready()) {
            return null;
        }
        if (!this.isInitialized()) {
            logger.info(methodName, null, new Object[]{"Waiting for (re)initialization."});
            return null;
        }
        logger.info("nodeArrives", null, new Object[]{"Total arrivals:", this.total_arrivals});
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.handleIllNodes();
            this.handleDeadNodes();
            this.resetNodepools();
        }
        SchedulingUpdate upd = new SchedulingUpdate();
        JobManagerUpdate jmu = new JobManagerUpdate();
        ArrayList<IRmJob> jobsToRecover = new ArrayList<IRmJob>();
        List<IRmJob> list = this.recoveredJobs;
        synchronized (list) {
            jobsToRecover.addAll(this.recoveredJobs);
            this.recoveredJobs.clear();
        }
        ArrayList<IRmJob> newJobs = new ArrayList<IRmJob>();
        List<IRmJob> list2 = this.incomingJobs;
        synchronized (list2) {
            newJobs.addAll(this.incomingJobs);
            this.incomingJobs.clear();
        }
        ArrayList<IRmJob> doneJobs = new ArrayList<IRmJob>();
        List<IRmJob> list3 = this.completedJobs;
        synchronized (list3) {
            doneJobs.addAll(this.completedJobs);
            this.completedJobs.clear();
        }
        ArrayList<Pair<IRmJob, Share>> doneShares = new ArrayList<Pair<IRmJob, Share>>();
        Object object = this.vacatedShares;
        synchronized (object) {
            doneShares.addAll(this.vacatedShares.values());
            this.vacatedShares.clear();
        }
        object = this;
        synchronized (object) {
            void var10_23;
            for (IRmJob iRmJob : jobsToRecover) {
                this.processRecovery(iRmJob);
            }
            for (Pair pair : doneShares) {
                this.processCompletion((IRmJob)pair.first(), (Share)pair.second());
            }
            for (IRmJob iRmJob : doneJobs) {
                this.processCompletion(iRmJob);
            }
            if (newJobs.size() > 0) {
                logger.info(methodName, null, new Object[]{"Jobs arrive:"});
                logger.info(methodName, null, new Object[]{"submit", RmJob.getHeader()});
            }
            for (IRmJob iRmJob : newJobs) {
                String user;
                User u;
                if (iRmJob.isRefused()) {
                    logger.info(methodName, iRmJob.getId(), new Object[]{"Bypassing previously refused job."});
                    upd.refuse(iRmJob, iRmJob.getRefusalReason());
                }
                if ((u = this.users.get(user = iRmJob.getUserName())) == null) {
                    u = new User(user);
                    this.users.put(user, u);
                }
                iRmJob.setUser(u);
                int share_order = this.calcShareOrder(iRmJob);
                iRmJob.setShareOrder(share_order);
                String clid = iRmJob.getClassName();
                ResourceClass prclass = this.resourceClassesByName.get(clid);
                u.addJob(iRmJob);
                this.allJobs.put(iRmJob.getId(), iRmJob);
                if (prclass == null) {
                    upd.refuse(iRmJob, "Cannot find priority class " + clid + " for job");
                    continue;
                }
                if (prclass.getPolicy() != SchedConstants.Policy.RESERVE && prclass.getPolicy() != SchedConstants.Policy.FIXED_SHARE && iRmJob.isReservation()) {
                    upd.refuse(iRmJob, "Class " + prclass.getName() + " is policy " + (Object)((Object)prclass.getPolicy()) + " but the work is submitted as a reservation.");
                    continue;
                }
                prclass.addJob(iRmJob);
                iRmJob.setResourceClass(prclass);
                try {
                    this.persistence.addJob((IDbJob)iRmJob);
                }
                catch (Exception e) {
                    logger.warn(methodName, iRmJob.getId(), new Object[]{"Cannot persist new job in database:", e});
                }
                logger.info(methodName, iRmJob.getId(), new Object[]{"submit", iRmJob.toString()});
            }
            logger.info(methodName, null, new Object[]{"Scheduling " + newJobs.size(), " new jobs.  Existing jobs: " + this.allJobs.size()});
            boolean bl = false;
            while (var10_23 < this.schedulers.length) {
                logger.info(methodName, null, new Object[]{"Run scheduler", (int)var10_23, "with top-level nodepool", this.nodepools[var10_23].getId()});
                this.schedulers[var10_23].schedule(upd);
                ++var10_23;
            }
            for (IRmJob j : this.allJobs.values()) {
                try {
                    this.persistence.updateDemand((IDbJob)j);
                }
                catch (Exception e) {
                    logger.warn(methodName, j.getId(), new Object[]{"Cannot update demand in database:", e});
                }
            }
            logger.debug(methodName, null, new Object[]{"--------------- Scheduler returns ---------------"});
            logger.debug(methodName, null, new Object[]{"\n", upd.toString()});
            logger.debug(methodName, null, new Object[]{"------------------------------------------------"});
            this.dispatch(upd, jmu);
            return jmu;
        }
    }

    public synchronized void shutdown() {
        this.done = true;
    }

    void updateNodepoolsByNode(String longname, NodePool np) {
        String methodName = "updateNodepoolsByNode";
        String shortname = longname;
        int ndx = longname.indexOf(".");
        logger.info(methodName, null, new Object[]{"Map", longname, "to", np.getId()});
        this.nodepoolsByNode.put(longname, np);
        if (ndx >= 0) {
            shortname = longname.substring(0, ndx);
            this.nodepoolsByNode.put(shortname, np);
            this.shortToLongNode.put(shortname, longname);
            logger.info(methodName, null, new Object[]{"Map", shortname, "to", np.getId()});
        }
    }

    NodePool getNodepoolByName(NodeIdentity ni) {
        NodePool np = this.nodepoolsByNode.get(ni.getName());
        if (np == null) {
            np = this.nodepoolsByNode.get(ni.getIp());
        }
        if (np == null) {
            np = this.nodepools[0];
            this.updateNodepoolsByNode(ni.getName(), np);
        }
        return np;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void nodeArrives(Node node) {
        String methodName = "nodeArrives";
        if (!this.isInitialized()) {
            logger.info(methodName, null, new Object[]{"Waiting for (re)initialization; node = " + node.getNodeIdentity().getName()});
            return;
        }
        Map<Node, Integer> map = this.illNodes;
        synchronized (map) {
            this.illNodes.remove(node);
        }
        ++this.total_arrivals;
        NodePool np = this.getNodepoolByName(node.getNodeIdentity());
        Machine m = np.getMachine(node);
        int share_order = 0;
        long allocatable_mem = node.getNodeMetrics().getNodeMemory().getMemFree() - this.share_free_dram;
        if (this.dramOverride > 0L) {
            allocatable_mem = this.dramOverride;
        }
        share_order = (int)(allocatable_mem / (long)np.getShareQuantum());
        this.max_order = Math.max(share_order, this.max_order);
        m = np.nodeArrives(node, share_order);
        m.heartbeatArrives();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeHb(Node n, int count) {
        Map<Node, Integer> map = this.illNodes;
        synchronized (map) {
            this.illNodes.put(n, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDeath(Map<Node, Node> nodes) {
        Map<Node, Node> map = this.deadNodes;
        synchronized (map) {
            this.deadNodes.putAll(nodes);
        }
    }

    synchronized String resolve(String node) {
        NodePool np = this.nodepoolsByNode.get(node);
        if (np == null) {
            return null;
        }
        if (np.hasNode(node)) {
            return node;
        }
        int ndx = node.indexOf(".");
        if (ndx > 0) {
            return node.substring(0, ndx);
        }
        return this.shortToLongNode.get(node);
    }

    @Override
    public synchronized RmAdminReply varyon(String[] nodes) {
        String methodName = "varyon";
        RmAdminVaryReply ret = new RmAdminVaryReply();
        StringBuffer sb = new StringBuffer();
        for (String n : nodes) {
            String rn = this.resolve(n);
            if (rn == null) {
                ret.setRc(false);
                ret.addFailedHost(n);
                sb.append("VaryOn: " + n + " cannot be found in the RM.\n");
                continue;
            }
            NodePool np = this.nodepoolsByNode.get(rn);
            if (np == null) {
                ret.setRc(false);
                ret.addFailedHost(rn);
                sb.append("VaryOn: " + n + " cannot find associated nodepool.\n");
                continue;
            }
            String repl = np.varyon(rn);
            logger.info(methodName, null, new Object[]{repl});
            sb.append(repl);
            sb.append("\n");
        }
        ret.setMessage(sb.toString());
        return ret;
    }

    @Override
    public synchronized RmAdminReply varyoff(String[] nodes) {
        String methodName = "varyoff";
        RmAdminVaryReply ret = new RmAdminVaryReply();
        StringBuffer sb = new StringBuffer();
        for (String n : nodes) {
            String rn = this.resolve(n);
            if (rn == null) {
                ret.setRc(false);
                ret.addFailedHost(n);
                sb.append("VaryOff: " + n + " cannot be found in the RM.\n");
                continue;
            }
            NodePool np = this.nodepoolsByNode.get(rn);
            if (np == null) {
                ret.setRc(false);
                ret.addFailedHost(rn);
                continue;
            }
            String repl = np.varyoff(rn);
            logger.info(methodName, null, new Object[]{repl});
            sb.append(repl);
            sb.append("\n");
        }
        ret.setMessage(sb.toString());
        return ret;
    }

    RmQueriedNodepool getNpStats(NodePool np) {
        RmQueriedNodepool ret = new RmQueriedNodepool();
        ret.setName(np.getId());
        ret.setOnline(np.countLocalMachines());
        ret.setDead(np.countLocalUnresponsiveMachines());
        ret.setOffline(np.countLocalOfflineMachines());
        ret.setSharesAvailable(np.countLocalShares());
        ret.setSharesFree(np.countLocalQShares());
        ret.setAllMachines(np.countAllLocalMachines());
        int[] onlineMachines = np.makeArray();
        int[] freeMachines = np.makeArray();
        for (int i = 1; i < freeMachines.length; ++i) {
            int n = i;
            freeMachines[n] = freeMachines[n] + np.countFreeMachines(i);
        }
        ret.setOnlineMachines(onlineMachines);
        ret.setFreeMachines(freeMachines);
        ret.setVirtualMachines(np.countLocalVMachinesByOrder());
        return ret;
    }

    void calculateLoad(RmAdminQLoadReply reply) {
        for (ResourceClass cl : this.resourceClasses.values()) {
            RmQueriedClass qcl = new RmQueriedClass();
            switch (cl.getPolicy()) {
                case FAIR_SHARE: {
                    qcl.setPolicy("FAIR_SHARE");
                    break;
                }
                case FIXED_SHARE: {
                    qcl.setPolicy("FIXED_SHARE");
                    break;
                }
                case RESERVE: {
                    qcl.setPolicy("RESERVE");
                }
            }
        }
    }

    void listAllNodepools(NodePool parent, ArrayList<NodePool> list) {
        list.add(parent);
        for (NodePool np : parent.getChildren().values()) {
            this.listAllNodepools(np, list);
        }
    }

    @Override
    public synchronized RmAdminQLoadReply queryLoad() {
        RmAdminQLoadReply ret = new RmAdminQLoadReply();
        if (!this.ready()) {
            ret.notReady();
            return ret;
        }
        this.calculateLoad(ret);
        ArrayList<NodePool> allpools = new ArrayList<NodePool>();
        for (NodePool np : this.nodepools) {
            this.listAllNodepools(np, allpools);
        }
        for (NodePool np : allpools) {
            ret.addNodepool(this.getNpStats(np));
        }
        return ret;
    }

    @Override
    public synchronized RmAdminQOccupancyReply queryOccupancy() {
        RmAdminQOccupancyReply ret = new RmAdminQOccupancyReply();
        if (!this.ready()) {
            ret.notReady();
            return ret;
        }
        for (NodePool np : this.nodepools) {
            RmQueriedMachine qm;
            Machine m;
            HashMap<Node, Machine> allMachs = np.getAllMachines();
            Map<Node, Machine> offline = np.getOfflineMachines();
            Map<Node, Machine> unresponsive = np.getUnresponsiveMachines();
            for (Node n : offline.keySet()) {
                m = offline.get(n);
                qm = m.queryMachine();
                qm.setOffline();
                if (unresponsive.containsKey(n)) {
                    unresponsive.remove(n);
                    qm.setUnresponsive();
                }
                ret.addMachine(qm);
                allMachs.remove(n);
            }
            for (Node n : unresponsive.keySet()) {
                m = unresponsive.get(n);
                qm = m.queryMachine();
                qm.setUnresponsive();
                ret.addMachine(qm);
                allMachs.remove(n);
            }
            for (Node n : allMachs.keySet()) {
                m = (Machine)allMachs.get(n);
                ret.addMachine(m.queryMachine());
            }
        }
        return ret;
    }

    @Override
    public synchronized void signalState(DuccId jobid, String state) {
        IRmJob j = this.allJobs.get(jobid);
        if (j != null) {
            j.setState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalNewWork(IRmJob job) {
        List<IRmJob> list = this.incomingJobs;
        synchronized (list) {
            this.incomingJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalInitialized(IRmJob job) {
        List<IRmJob> list = this.initializedJobs;
        synchronized (list) {
            this.initializedJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalRecovery(IRmJob job) {
        List<IRmJob> list = this.recoveredJobs;
        synchronized (list) {
            this.recoveredJobs.add(job);
        }
    }

    public void jobCancelled(DuccId id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalCompletion(DuccId id) {
        String methodName = "signalCompletion";
        List<IRmJob> list = this.completedJobs;
        synchronized (list) {
            try {
                IRmJob job = this.allJobs.get(id);
                if (job == null) {
                    logger.warn(methodName, id, new Object[]{"Job completion signal: early termination; nothing to complete."});
                    return;
                }
                logger.info(methodName, id, new Object[]{"Job completion signal."});
                this.completedJobs.add(job);
            }
            catch (Throwable t) {
                logger.warn(methodName, id, t, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalCompletion(IRmJob job, Share share) {
        String methodName = "signalCompletion";
        Map<DuccId, Pair<IRmJob, Share>> map = this.vacatedShares;
        synchronized (map) {
            logger.info(methodName, job.getId(), new Object[]{"Job vacate signal share: ", share.toString()});
            this.vacatedShares.put(share.getId(), (Pair<IRmJob, Share>)new Pair((Object)job, (Object)share));
        }
    }

    private synchronized void processCompletion(IRmJob job) {
        String methodName = "processCompletion";
        logger.info(methodName, job.getId(), new Object[]{"Job completes."});
        try {
            this.persistence.deleteJob((IDbJob)job);
        }
        catch (Exception e) {
            logger.warn(methodName, job.getId(), new Object[]{"Cannot delete job from database:", e});
        }
        IRmJob j = this.allJobs.remove(job.getId());
        if (j == null) {
            logger.info(methodName, job.getId(), new Object[]{"Job is not in run list!"});
            return;
        }
        j.markComplete();
        User user = this.users.get(j.getUserName());
        user.remove(job);
        ResourceClass rc = job.getResourceClass();
        if (rc != null) {
            rc.removeJob(j);
        } else if (!j.isRefused()) {
            throw new SchedInternalError(j.getId(), "Job exits from class " + job.getClassName() + " but we cannot find the priority class definition.");
        }
        HashMap<Share, Share> shares = job.getAssignedShares();
        for (Share s : shares.values()) {
            this.purgeShare(s, job);
        }
        job.removeAllShares();
    }

    private synchronized void processCompletion(IRmJob job, Share share) {
        String methodName = "processCompletion";
        logger.debug(methodName, job.getId(), new Object[]{"Job vacates share ", share.toString()});
        job.removeShare(share);
        this.purgeShare(share, job);
    }

    public void resetNodepools() {
        for (NodePool np : this.nodepools) {
            np.reset(np.getMaxOrder());
        }
    }

    boolean compatibleNodepool(Share s, IRmJob j) {
        NodePool np = s.getNodepool();
        ResourceClass rc = j.getResourceClass();
        SchedConstants.Policy p = rc.getPolicy();
        return np.compatibleNodepool(p, rc);
    }

    public synchronized void processRecovery(IRmJob j) {
        String methodName = "processRecovery";
        ResourceClass rc = this.resourceClassesByName.get(j.getClassName());
        j.setResourceClass(rc);
        int share_order = this.calcShareOrder(j);
        j.setShareOrder(share_order);
        HashMap<Share, Share> shares = j.getRecoveredShares();
        ArrayList<Share> sharesToShrink = new ArrayList<Share>();
        StringBuffer sharenames = new StringBuffer();
        for (Share s : shares.values()) {
            sharenames.append(s.toString());
            sharenames.append(" ");
            switch (rc.getPolicy()) {
                case FAIR_SHARE: {
                    s.setShareOrder(share_order);
                    if (this.compatibleNodepool(s, j)) break;
                    sharesToShrink.add(s);
                    break;
                }
                case FIXED_SHARE: {
                    logger.info(methodName, j.getId(), new Object[]{"Set fixed bit for FIXED job"});
                    s.setShareOrder(share_order);
                    s.setFixed();
                    if (this.compatibleNodepool(s, j)) break;
                    if (j.isService()) {
                        sharesToShrink.add(s);
                        break;
                    }
                    logger.warn(methodName, j.getId(), new Object[]{"Share is in incompatible nodepool but cannot be evicted:", s});
                    break;
                }
                case RESERVE: {
                    logger.info(methodName, j.getId(), new Object[]{"Set fixed bit for RESERVE job"});
                    s.setFixed();
                    share_order = s.getMachineOrder();
                    s.setShareOrder(share_order);
                    if (share_order > j.getShareOrder()) {
                        logger.info(methodName, j.getId(), new Object[]{"Increased order of RESERVE job to", share_order});
                    }
                    j.upgradeShareOrder(share_order);
                    if (!j.isService() || this.compatibleNodepool(s, j)) break;
                    sharesToShrink.add(s);
                }
            }
            Machine m = s.getMachine();
            NodePool np = m.getNodepool();
            np.connectShare(s, m, j, share_order);
            this.busyShares.put(s.getId(), s);
        }
        String username = j.getUserName();
        User user = this.users.get(username);
        if (user == null) {
            user = new User(username);
            this.users.put(username, user);
            logger.info(methodName, j.getId(), new Object[]{"&&&&&&&&&&&&&&&& new user", user.toString(), "-------------------"});
        }
        j.setUser(user);
        user.addJob(j);
        j.promoteShares();
        j.clearRecoveredShares();
        String clid = j.getClassName();
        ResourceClass prclass = this.resourceClassesByName.get(clid);
        this.allJobs.put(j.getId(), j);
        prclass.addJob(j);
        j.setResourceClass(prclass);
        logger.info(methodName, j.getId(), new Object[]{"Recovered job:", j.toString()});
        logger.info(methodName, j.getId(), new Object[]{"Recovered shares:", sharenames.toString()});
        try {
            this.persistence.addJob((IDbJob)j);
        }
        catch (Exception e) {
            logger.warn(methodName, j.getId(), new Object[]{"Cannot persist recovered job in database:", j});
        }
        for (Share s : sharesToShrink) {
            logger.info(methodName, j.getId(), new Object[]{"Recovery - Removing share from wrong nodepool after reconfiguration:", s});
            j.shrinkByOne(s);
        }
    }

    private void purgeShare(Share s, IRmJob j) {
        this.busyShares.remove(s.getId());
        Machine m = s.getMachine();
        m.removeShare(s);
    }

    public static synchronized DuccId newId() {
        return idFactory.next();
    }

    public static synchronized DuccId newId(long id) {
        return idFactory.next(id);
    }

    @Override
    public void queryMachines() {
        for (NodePool np : this.nodepools) {
            np.queryMachines();
        }
    }

    static {
        rmversion_string = null;
    }

    class MachineByOrderSorter
    implements Comparator<Machine> {
        MachineByOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            if (m1.equals(m2)) {
                return 0;
            }
            if (m1.getShareOrder() == m2.getShareOrder()) {
                return m1.getId().compareTo(m2.getId());
            }
            return m1.getShareOrder() - m2.getShareOrder();
        }
    }
}

