/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.randomsleep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class FixedSleepAE
extends CasAnnotator_ImplBase {
    Random r;
    Logger logger;
    static boolean initComplete = false;
    Marker marker;
    String AE_Identifier = "*^^^^^^^^^ AE ";
    ArrayList<long[]> bloated_space = new ArrayList();

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        int i_irange;
        int i_itime;
        super.initialize(uimaContext);
        long tid = Thread.currentThread().getId();
        Map<String, String> env = System.getenv();
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        String pid = rmxb.getName();
        long seed = System.currentTimeMillis();
        this.r = new Random(seed);
        this.logger = UIMAFramework.getLogger(FixedSleepAE.class);
        if (this.logger == null) {
            System.out.println("Is this nuts or what, no logger!");
        }
        if (initComplete) {
            this.logger.log(Level.INFO, "Init bypassed in PID:TID " + pid + ":" + tid + ", already completed. ");
            return;
        }
        this.logger.log(Level.INFO, "Init procedes in PID:TIDs " + pid + ":" + tid + " Environment:");
        for (String k : env.keySet()) {
            this.logger.log(Level.INFO, String.format("Environment[%s] = %s", k, env.get(k)));
        }
        File workingdir = new File(System.getProperty("user.dir"));
        File[] files = workingdir.listFiles();
        this.logger.log(Level.INFO, "Working directory is " + workingdir.toString());
        for (File f : files) {
            this.logger.log(Level.INFO, "File: " + f.toString());
        }
        if (System.getenv("FAST_INIT_FAIL") != null) {
            String jobid = System.getProperty("ducc.job.id");
            String wd = System.getProperty("user.dir");
            String markerdir = wd + "/" + jobid + ".output";
            System.out.println("LOOK IN " + markerdir);
            File marker = new File(markerdir);
            String[] outputs = marker.list();
            int count = 0;
            for (String s : outputs) {
                if (s.endsWith(".die")) {
                    ++count;
                }
                System.out.println("COUNT " + s + " count = " + count);
                if (count <= 2) continue;
                throw new IllegalStateException("foo foo and foo");
            }
            File init_death = new File(markerdir + "/" + tid + ".die");
            System.out.println("CREATE " + init_death);
            try {
                init_death.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (!initComplete) {
            initComplete = true;
        }
        String itime = System.getenv("AE_INIT_TIME");
        String irange = System.getenv("AE_INIT_RANGE");
        String ierror = System.getenv("INIT_ERROR");
        if (itime == null) {
            throw new IllegalArgumentException("Missing AE_INIT_TIME");
        }
        if (irange == null) {
            throw new IllegalArgumentException("Missing AE_INIT_RANGE");
        }
        try {
            i_itime = Integer.parseInt(itime);
            i_irange = Integer.parseInt(irange);
        }
        catch (NumberFormatException e) {
            this.logger.log(Level.INFO, "Invalid AE_INIT_TIME[" + itime + "] or AE_INIT_RANGE[" + irange + "] - must be numbers.");
            throw e;
        }
        if (i_itime < 0) {
            throw new IllegalArgumentException("Invalid AE_INIT_TIME, must be >= 0");
        }
        if (i_irange <= 0) {
            throw new IllegalArgumentException("Invalid AE_INIT_RANGE, must be > 0");
        }
        if (ierror != null) {
            int probability = Integer.parseInt(ierror);
            int toss = this.nextrand(100);
            this.logger.log(Level.INFO, "Init errors: probability[" + probability + "] toss[" + toss + "]");
            if (probability > toss) {
                this.throwAnException("Random Error in Initialization");
            }
        }
        long sleep = i_itime + this.nextrand(i_irange);
        this.logger.log(Level.INFO, "^^--------> Initialization sleep time is " + sleep + " milliseconds");
        String bloat = System.getenv("INIT_BLOAT");
        if (bloat != null) {
            this.logger.log(Level.INFO, "INIT_BLOAT is set to " + bloat + "; starting bloat in init");
            this.runBloater(bloat);
        }
        String ok = "INTERRUPTED";
        this.logger.log(Level.INFO, "^^-------> AE process " + pid + " TID " + tid + " initialization starts: sleep " + sleep + "MS");
        try {
            Thread.sleep(sleep);
            ok = "OK";
        }
        catch (InterruptedException e) {
            this.logger.log(Level.INFO, "^^-------> AE process " + pid + " TID " + tid + " my sleep has been disturbed!");
        }
        this.logger.log(Level.INFO, "^^-------> AE process " + pid + " TID " + tid + " initialization " + ok);
    }

    void runBloater(String gb) {
        HashMap<Integer, long[]> bloat = new HashMap<Integer, long[]>();
        int ndx = 0;
        long total = 0L;
        long limit = Long.parseLong(gb);
        limit *= 0x40000000L;
        do {
            long[] waste = new long[4096];
            for (int i = 0; i < waste.length; ++i) {
                waste[i] = i;
            }
            bloat.put(new Integer(ndx++), waste);
            total += (long)waste.length * 8L;
            if (ndx % 1000 != 0) continue;
            System.out.println("Total " + total + " limit " + limit);
        } while (total <= limit);
        System.out.println("Stopping allocation at " + "" + total / 0x100000L + " just hanging around now.");
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Throwable t) {
            return;
        }
    }

    void throwAnException(String msgheader) {
        int MAX_EXCEPTIONS = 7;
        int whichmessage = this.nextrand(MAX_EXCEPTIONS);
        Object[] arguments = new Object[3];
        for (int i = 0; i < 5; ++i) {
            arguments[0] = "Fake AEPE Argument number " + i;
        }
        try {
            switch (whichmessage) {
                case 2: {
                    throw new AnalysisEngineProcessException();
                }
                case 3: {
                    throw new AnalysisEngineProcessException("A deliberate error", arguments);
                }
                case 4: {
                    throw new AnalysisEngineProcessException("A deliberate error with a cause", arguments, (Throwable)new IllegalStateException("Fake ISE"));
                }
                case 5: {
                    throw new AnalysisEngineProcessException((Throwable)new IllegalStateException("Fake ISE"));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        switch (whichmessage) {
            case 0: {
                throw new IllegalStateException(msgheader + " test message.");
            }
            case 1: {
                Thread notAThread = null;
                long xx = notAThread.getId();
                break;
            }
            default: {
                throw new IllegalStateException(msgheader + " -- Message " + whichmessage + " seems to blow the case statment in the test!");
            }
        }
    }

    int nextrand(int max) {
        return ((int)this.r.nextLong() & Integer.MAX_VALUE) % max;
    }

    void randomError(double error_rate, String msgheader) {
        int RANGE = 10000;
        if (error_rate == 0.0) {
            this.dolog(msgheader, "Error rate is 0, bypassing random error");
            return;
        }
        long cointoss = this.nextrand(10000);
        String msg = msgheader + " simulated error.";
        int check = (int)Math.round(10000.0 * (error_rate / 100.0));
        this.dolog("**-------> AE Error Coin toss " + cointoss + " vs " + check + ": " + (cointoss < (long)check));
        if (cointoss < (long)check) {
            this.throwAnException(msg);
        }
    }

    void dolog(Object ... args) {
        StringBuffer sb = new StringBuffer();
        for (Object s : args) {
            sb.append(s);
            sb.append(" ");
        }
        String s = sb.toString();
        System.out.println("FROM PRINTLN: " + s);
        this.logger.log(Level.INFO, "FROM LOGGER:" + s);
        if (this.marker != null) {
            this.marker.write(s);
        }
    }

    public void destroy() {
        System.out.println(this.AE_Identifier + " Destroy is called (0)");
        this.dolog("Destroy is called (1) !");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.marker != null) {
            this.marker.flush();
            this.marker.close();
        }
        System.out.println(this.AE_Identifier + " Destroy exits");
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        String data = cas.getSofaDataString();
        StringTokenizer tok = new StringTokenizer(data);
        long elapsed = Long.parseLong(tok.nextToken());
        int qid = Integer.parseInt(tok.nextToken());
        int total = Integer.parseInt(tok.nextToken());
        double error_rate = Double.parseDouble(tok.nextToken());
        String logid = tok.nextToken();
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        String pid = rmxb.getName();
        String completion = "INTERRUPTED";
        long tid = Thread.currentThread().getId();
        String msgheader = "**-------> AE process " + pid + " TID " + tid + " task " + qid + " of " + total;
        if (System.getenv("FAST_INIT_FAIL") != null) {
            System.out.println("Croakamundo.");
            System.exit(1);
        }
        if (this.marker == null) {
            if (!logid.equals("None")) {
                this.marker = new Marker(logid, pid, tid);
            }
        } else {
            this.marker.flush();
        }
        try {
            this.dolog(msgheader + " sleeping " + elapsed + " MS.");
            String bloat = System.getenv("PROCESS_BLOAT");
            if (bloat != null) {
                long gb = Long.parseLong(bloat) * 1024L * 1024L * 1024L;
                Bloat bl = new Bloat(msgheader, gb, elapsed);
                bl.start();
            }
            this.randomError(error_rate, msgheader);
            Thread.sleep(elapsed);
            completion = "OK";
            this.dolog(msgheader + " returns after " + elapsed + " MS completion " + completion);
        }
        catch (InterruptedException e) {
            this.dolog(msgheader + " my sleep has been rudely interrupted!");
        }
    }

    class Bloat
    extends Thread {
        int NUM_UPDATES = 10;
        long howmuch;
        long elapsed;
        String msgheader;

        Bloat(String msgheader, long howmuch, long elapsed) {
            this.msgheader = msgheader;
            this.howmuch = howmuch;
            this.elapsed = elapsed;
        }

        void increase() {
            long amount = this.howmuch / (long)this.NUM_UPDATES;
            long current = 0L;
            long increment = 0x8000000L;
            while (current < amount) {
                FixedSleepAE.this.dolog(this.msgheader + " ====> Allocating " + increment * 8L + " bytes.");
                long[] longs = new long[(int)increment];
                FixedSleepAE.this.bloated_space.add(longs);
                FixedSleepAE.this.dolog(this.msgheader + " ====> Current " + (current += increment * 8L));
            }
            FixedSleepAE.this.dolog(this.msgheader + " ====> Allocated " + current + " bytes.");
        }

        @Override
        public void run() {
            long bloat_target = this.elapsed / 2L;
            long sleep_time = bloat_target / (long)this.NUM_UPDATES;
            FixedSleepAE.this.dolog(this.msgheader + " Starting bloater: " + this.howmuch + " bytes over " + bloat_target + " ms.");
            for (long total = 0L; total < bloat_target; total += sleep_time) {
                this.increase();
                try {
                    FixedSleepAE.this.dolog(this.msgheader + " Sleeping " + sleep_time + "ms");
                    Thread.sleep(sleep_time);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    class Marker {
        PrintWriter writer = null;
        ArrayList<String> lines = new ArrayList();

        Marker(String filestem, String pid, long tid) {
            String filename = filestem + "/AE." + pid + "." + tid + ".marker";
            try {
                this.writer = new PrintWriter(filename);
                this.writer.println(this.now() + " AE starts marker. Pid[" + pid + "] + tid[" + tid + "]");
            }
            catch (FileNotFoundException e) {
                System.out.println(" !!!!!! Can't open file: " + filename + ". user.dir = " + System.getProperty("user.dir"));
                this.writer = null;
            }
        }

        String now() {
            return "" + System.currentTimeMillis();
        }

        void write(String line) {
            if (this.writer != null) {
                this.lines.add(line);
            }
        }

        void flush() {
            if (this.writer != null) {
                this.writer.println("------------------------------------------------------------------------------------------");
                for (String s : this.lines) {
                    this.writer.println(this.now() + " " + s);
                }
                this.writer.println("------------------------------------------------------------------------------------------");
                this.writer.flush();
                this.lines.clear();
            }
        }

        void close() {
            if (this.writer != null) {
                this.flush();
                this.writer.close();
            }
        }
    }
}

