/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.Collection;

public class DbAlive {
    String dburl;
    String adminid = null;
    String adminpw = null;
    private Cluster cluster;

    public DbAlive(String dburl, String adminid, String adminpw) {
        this.dburl = dburl;
        this.adminid = adminid;
        this.adminpw = adminpw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RC connect() throws Exception {
        RC ret = RC.OK;
        try {
            PlainTextAuthProvider auth = new PlainTextAuthProvider(this.adminid, this.adminpw);
            this.cluster = Cluster.builder().withAuthProvider((AuthProvider)auth).addContactPoint(this.dburl).build();
            Metadata metadata = this.cluster.getMetadata();
            System.out.println("Connected to cluster: " + metadata.getClusterName());
            KeyspaceMetadata duccKs = metadata.getKeyspace("ducc");
            if (duccKs == null) {
                System.out.println("DUCC keyspace not found.");
                ret = RC.NOT_INITIALIZED;
            } else {
                String tables = "";
                Collection tableset = duccKs.getTables();
                for (TableMetadata tmd : tableset) {
                    tables = tables + tmd.getName() + " ";
                }
                System.out.println("Tables found: " + tables);
            }
            for (Host host : metadata.getAllHosts()) {
                System.out.println(String.format("Datatacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack()));
            }
        }
        catch (NoHostAvailableException e) {
            System.out.println("Waiting for DB to start ...");
            ret = RC.CANT_CONNECT;
        }
        catch (AuthenticationException e) {
            System.out.println("Waiting for authentication ...");
            ret = RC.NOT_AUTHORIZED;
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = RC.UNKNOWN;
        }
        finally {
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        return ret;
    }

    public void close() {
        this.cluster.close();
    }

    static void usage() {
        System.out.println("Usage: DbAlive database_url id pw retry-count");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            DbAlive.usage();
        }
        int max = 0;
        try {
            max = Integer.parseInt(args[3]);
        }
        catch (NumberFormatException e) {
            System.out.println("Retry count must be numeric.");
            System.exit(1);
        }
        DbAlive client = null;
        RC rc = RC.OK;
        try {
            client = new DbAlive(args[0], args[1], args[2]);
            for (int i = 0; i < max; ++i) {
                rc = client.connect();
                System.out.println(rc.message());
                if (rc != RC.OK) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.out.println("Errors contacting database");
            e.printStackTrace();
            System.exit(rc.rc());
        }
        System.exit(rc.rc());
    }

    static enum RC {
        OK{

            @Override
            public String message() {
                return "OK";
            }

            @Override
            public int rc() {
                return 0;
            }
        }
        ,
        NOT_INITIALIZED{

            @Override
            public String message() {
                return "DB Not Initialized";
            }

            @Override
            public int rc() {
                return 1;
            }
        }
        ,
        CANT_CONNECT{

            @Override
            public String message() {
                return "DB Cannot Connect";
            }

            @Override
            public int rc() {
                return 2;
            }
        }
        ,
        NOT_AUTHORIZED{

            @Override
            public String message() {
                return "DB Not Authorized";
            }

            @Override
            public int rc() {
                return 3;
            }
        }
        ,
        UNKNOWN{

            @Override
            public String message() {
                return "DB Unknown Error";
            }

            @Override
            public int rc() {
                return 4;
            }
        };


        public abstract String message();

        public abstract int rc();
    }
}

