/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.persistence.IDbProperty;
import org.apache.uima.ducc.common.persistence.rm.IDbJob;
import org.apache.uima.ducc.common.persistence.rm.IDbShare;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;

public class RmStatePersistence
implements IRmPersistence {
    DbManager dbManager = null;
    DuccLogger logger = null;
    static final String RM_NODE_TABLE = IRmPersistence.RmNodes.TABLE_NAME.pname();
    static final String RM_SHARE_TABLE = IRmPersistence.RmShares.TABLE_NAME.pname();
    static final String RM_LOAD_TABLE = IRmPersistence.RmLoad.TABLE_NAME.pname();
    PreparedStatement shareAddPrepare = null;
    PreparedStatement shareDelPrepare = null;
    PreparedStatement updateFixedPrepare = null;
    PreparedStatement updatePurgedPrepare = null;
    PreparedStatement updateEvictedPrepare = null;
    PreparedStatement updateSharePrepare = null;
    PreparedStatement addJobPrepare = null;
    PreparedStatement deleteJobPrepare = null;
    PreparedStatement updateDemandPrepare = null;

    private boolean init(String dburl) throws Exception {
        String methodName = "init";
        boolean ret = false;
        while (true) {
            try {
                this.dbManager = new DbManager(dburl, this.logger);
                this.dbManager.init();
                ret = true;
            }
            catch (NoHostAvailableException e) {
                this.logger.error(methodName, null, new Object[]{"Cannot contact database.  Retrying in 5 seconds."});
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error(methodName, null, new Object[]{"Errors contacting database.  No connetion made."});
                this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                ret = false;
            }
            break;
        }
        return ret;
    }

    public void init(DuccLogger logger) throws Exception {
        this.logger = logger;
        String stateUrl = System.getProperty("ducc.database.host");
        this.init(stateUrl);
        DbHandle h = this.dbManager.open();
        this.shareAddPrepare = h.prepare("UPDATE " + RM_SHARE_TABLE + " SET  uuid=?, share_order=?, blacklisted=?, evicted=?, fixed=?, purged=?, quantum=?, jobtype=? WHERE node=? AND ducc_dbid=? and job_id=?");
        this.shareDelPrepare = h.prepare("DELETE FROM " + RM_SHARE_TABLE + " WHERE node = ? and ducc_dbid = ? and job_id = ?;");
        this.updateFixedPrepare = h.prepare("UPDATE " + RM_SHARE_TABLE + " SET fixed = ? WHERE node = ? AND ducc_dbid = ? and job_id = ?");
        this.updatePurgedPrepare = h.prepare("UPDATE " + RM_SHARE_TABLE + " SET purged = ? WHERE node = ? AND ducc_dbid = ? and job_id = ?");
        this.updateEvictedPrepare = h.prepare("UPDATE " + RM_SHARE_TABLE + " SET evicted = ? WHERE node = ? AND ducc_dbid = ? and job_id = ?");
        this.updateSharePrepare = h.prepare("UPDATE " + RM_SHARE_TABLE + " SET investment = ?, state = ?, init_time = ?, pid = ?  WHERE node = ? AND ducc_dbid = ? and job_id = ?");
        this.addJobPrepare = h.prepare("UPDATE " + RM_LOAD_TABLE + " SET class = ?, user = ?, memory = ?, jobtype = ? WHERE job_id = ?");
        this.deleteJobPrepare = h.prepare("DELETE FROM " + RM_LOAD_TABLE + " WHERE job_id=?");
        this.updateDemandPrepare = h.prepare("UPDATE " + RM_LOAD_TABLE + " SET demand = ?, occupancy = ?, state = ? WHERE job_id=?");
    }

    public void close() {
        if (this.dbManager != null) {
            this.dbManager.shutdown();
        }
        this.dbManager = null;
    }

    public void clear() throws Exception {
        String methodName = "clear";
        DbHandle h = null;
        try {
            h = this.dbManager.open();
            h.execute("TRUNCATE " + RM_NODE_TABLE);
            h.execute("TRUNCATE " + RM_SHARE_TABLE);
            h.execute("TRUNCATE " + RM_LOAD_TABLE);
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Cannot clear the database.", e});
        }
    }

    static List<SimpleStatement> mkSchema() throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + RM_NODE_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IRmPersistence.RmNodes.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        List<String> indexes = DbUtil.mkIndices((IDbProperty[])IRmPersistence.RmNodes.values(), RM_NODE_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + RM_SHARE_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IRmPersistence.RmShares.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        indexes = DbUtil.mkIndices((IDbProperty[])IRmPersistence.RmShares.values(), RM_SHARE_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + RM_LOAD_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IRmPersistence.RmLoad.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        indexes = DbUtil.mkIndices((IDbProperty[])IRmPersistence.RmShares.values(), RM_LOAD_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    public void createMachine(String m, Map<IRmPersistence.RmNodes, Object> props) throws Exception {
        String methodName = "createMachine";
        DbHandle h = this.dbManager.open();
        try {
            String cql = DbUtil.mkInsert(RM_NODE_TABLE, props);
            h.execute(cql);
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Error creating new record:", e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeProperties(String node, Object ... props) throws Exception {
        String methodName = "setProperties";
        long now = System.currentTimeMillis();
        if (props.length % 2 != 0) {
            throw new IllegalStateException("Set properties: number of properties must be even, instead was " + props.length);
        }
        DbHandle h = this.dbManager.open();
        try {
            h.updateProperties(RM_NODE_TABLE, "name='" + node + "'", props);
        }
        catch (Exception e) {
            try {
                this.logger.error(methodName, null, new Object[]{"Problem setting properties", e});
            }
            catch (Throwable throwable) {
                this.logger.debug(methodName, null, new Object[]{"Total time to update properties on", System.currentTimeMillis() - now});
                throw throwable;
            }
            this.logger.debug(methodName, null, new Object[]{"Total time to update properties on", System.currentTimeMillis() - now});
        }
        this.logger.debug(methodName, null, new Object[]{"Total time to update properties on", System.currentTimeMillis() - now});
    }

    public void setNodeProperty(String node, IRmPersistence.RmNodes k, Object v) throws Exception {
        String methodName = "setProperty";
        DbHandle h = this.dbManager.open();
        try {
            h.updateProperty(RM_NODE_TABLE, "name='" + node + "'", k.columnName(), v);
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Problem setting properties:", e});
        }
    }

    public void addAssignment(String node, DuccId jobid, IDbShare s, int quantum, String type) throws Exception {
        DbHandle h = this.dbManager.open();
        h.saveObject(this.shareAddPrepare, s.getId().getUUID(), s.getShareOrder(), s.isBlacklisted(), s.isEvicted(), s.isFixed(), s.isPurged(), quantum, type, node, s.getId().getFriendly(), jobid.getFriendly());
    }

    public void removeAssignment(String node, DuccId jobid, IDbShare s) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.shareDelPrepare, node, s.getId().getFriendly(), jobid.getFriendly());
    }

    public void setFixed(String node, DuccId shareId, DuccId jobId, boolean val) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.updateFixedPrepare, val, node, shareId.getFriendly(), jobId.getFriendly());
    }

    public void setPurged(String node, DuccId shareId, DuccId jobId, boolean val) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.updatePurgedPrepare, val, node, shareId.getFriendly(), jobId.getFriendly());
    }

    public void setEvicted(String node, DuccId shareId, DuccId jobId, boolean val) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.updateEvictedPrepare, val, node, shareId.getFriendly(), jobId.getFriendly());
    }

    public void updateShare(String node, DuccId shareid, DuccId jobid, long investment, String state, long init_time, long pid) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.updateSharePrepare, investment, state, init_time, pid, node, shareid.getFriendly(), jobid.getFriendly());
    }

    public Properties getMachine(String m) throws Exception {
        return null;
    }

    public Map<String, Map<String, Object>> getAllMachines() throws Exception {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
        String cql = "SELECT * FROM " + RM_NODE_TABLE;
        DbHandle h = this.dbManager.open();
        ResultSet rs = h.execute(cql);
        for (Row r : rs) {
            Map<String, Object> mach = DbUtil.getProperties((IDbProperty[])IRmPersistence.RmNodes.values(), r);
            ret.put((String)mach.get(IRmPersistence.RmNodes.Name.pname()), mach);
        }
        return ret;
    }

    public Map<String, Map<String, Object>> getAllShares() throws Exception {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
        String cql = "SELECT * FROM " + RM_SHARE_TABLE;
        DbHandle h = this.dbManager.open();
        ResultSet rs = h.execute(cql);
        for (Row r : rs) {
            Map<String, Object> share = DbUtil.getProperties((IDbProperty[])IRmPersistence.RmShares.values(), r);
            String key = share.get(IRmPersistence.RmShares.Node.pname()) + ":" + share.get(IRmPersistence.RmShares.DuccDbid.pname()) + ":" + share.get(IRmPersistence.RmShares.JobId.pname());
            ret.put(key, share);
        }
        return ret;
    }

    public List<Map<String, Object>> getLoad() throws Exception {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        String cql = "SELECT * FROM " + RM_LOAD_TABLE;
        DbHandle h = this.dbManager.open();
        ResultSet rs = h.execute(cql);
        for (Row r : rs) {
            Map<String, Object> job = DbUtil.getProperties((IDbProperty[])IRmPersistence.RmLoad.values(), r);
            ret.add(job);
        }
        return ret;
    }

    public void addJob(IDbJob j) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.addJobPrepare, j.getClassName(), j.getUserName(), j.getMemory(), j.getShortType(), j.getFriendlyId());
    }

    public void deleteJob(IDbJob j) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.deleteJobPrepare, j.getFriendlyId());
    }

    public void updateDemand(IDbJob j) throws Exception {
        DbHandle h = this.dbManager.open();
        h.execute(this.updateDemandPrepare, j.queryDemand(), j.countOccupancy() / j.getShareOrder(), j.getState(), j.getFriendlyId());
    }

    public static void main(String[] args) {
    }
}

