/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.sd.task;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.jd.fsm.wi.IMetaMetaCas;
import org.apache.uima.ducc.container.jd.fsm.wi.MetaMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.container.net.iface.IPerformanceMetrics;
import org.apache.uima.ducc.container.net.impl.MetaCas;
import org.apache.uima.ducc.container.sd.DuccServiceDriver;
import org.apache.uima.ducc.container.sd.task.WiTaskConsumer;
import org.apache.uima.ducc.container.sd.task.error.TaskProtocolException;
import org.apache.uima.ducc.container.sd.task.iface.TaskAllocatorCallbackListener;
import org.apache.uima.ducc.container.sd.task.iface.TaskConsumer;
import org.apache.uima.ducc.container.sd.task.iface.TaskProtocolHandler;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class DuccServiceTaskProtocolHandler
implements TaskProtocolHandler {
    Logger logger = UIMAFramework.getLogger(DuccServiceTaskProtocolHandler.class);
    private static AtomicInteger atomicCounter = new AtomicInteger(0);

    public DuccServiceTaskProtocolHandler(TaskAllocatorCallbackListener taskAllocator) {
    }

    @Override
    public String initialize(Properties props) throws TaskProtocolException {
        return null;
    }

    @Override
    public void handle(IMetaCasTransaction wi) throws TaskProtocolException {
        this.handleMetaCasTransation(wi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMetaCasTransation(IMetaCasTransaction trans) {
        try {
            trans.setResponseHints(new ArrayList<IMetaCasTransaction.Hint>());
            WiTaskConsumer taskConsumer = new WiTaskConsumer(trans);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.remote.get() + ((Object)taskConsumer).toString());
            mb.append(Standardize.Label.type.get() + (Object)((Object)trans.getType()));
            IMetaCasTransaction.Type type = trans.getType();
            switch (type) {
                case Get: {
                    this.logger.log(Level.INFO, "---- Driver handling GET Request - Requestor:" + ((Object)taskConsumer).toString());
                    this.handleMetaCasTransationGet(trans, taskConsumer);
                    break;
                }
                case Ack: {
                    this.logger.log(Level.INFO, "---- Driver handling ACK Request - Requestor:" + ((Object)taskConsumer).toString());
                    this.handleMetaCasTransationAck(trans, taskConsumer);
                    break;
                }
                case End: {
                    this.logger.log(Level.INFO, "---- Driver handling END Request - Requestor:" + ((Object)taskConsumer).toString());
                    this.handleMetaCasTransationEnd(trans, taskConsumer);
                    break;
                }
                case InvestmentReset: {
                    break;
                }
            }
            IMetaCas metaCas = trans.getMetaCas();
            if (metaCas != null) {
                metaCas.setPerformanceMetrics(null);
                metaCas.setUserSpaceException(null);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error", (Throwable)e);
        }
    }

    @Override
    public String start() throws Exception {
        return null;
    }

    @Override
    public void stop() throws Exception {
    }

    private void handleMetaCasTransationGet(IMetaCasTransaction trans, TaskConsumer taskConsumer) {
        IMetaMetaCas mmc = this.getMetaMetaCas(taskConsumer);
        trans.setMetaCas(mmc.getMetaCas());
    }

    private IMetaCas getMetaCas(String serializedCas) {
        if (serializedCas == null) {
            return null;
        }
        return new MetaCas(atomicCounter.incrementAndGet(), "", serializedCas);
    }

    private synchronized IMetaMetaCas getMetaMetaCas(TaskConsumer taskConsumer) {
        MetaMetaCas mmc = new MetaMetaCas();
        DuccServiceDriver sd = DuccServiceDriver.getInstance();
        TaskAllocatorCallbackListener taskAllocator = sd.getTaskAllocator();
        String serializedCas = taskAllocator.getSerializedCAS(taskConsumer);
        IMetaCas metaCas = this.getMetaCas(serializedCas);
        mmc.setMetaCas(metaCas);
        return mmc;
    }

    private void handleMetaCasTransationAck(IMetaCasTransaction trans, TaskConsumer taskConsumer) {
    }

    private Throwable deserialize(Object byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream((byte[])byteArray);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Throwable t = (Throwable)ois.readObject();
        return t;
    }

    private void handleMetaCasTransationEnd(IMetaCasTransaction trans, TaskConsumer taskConsumer) {
        DuccServiceDriver sd = DuccServiceDriver.getInstance();
        TaskAllocatorCallbackListener taskAllocator = sd.getTaskAllocator();
        if (trans.getMetaCas().getUserSpaceException() != null) {
            Object serializedException = trans.getMetaCas().getUserSpaceException();
            String exceptionAsString = "";
            try {
                Throwable t = this.deserialize(serializedException);
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                exceptionAsString = sw.toString();
            }
            catch (Exception ee) {
                this.logger.log(Level.WARNING, "Error", (Throwable)ee);
            }
            taskAllocator.onTaskFailure(taskConsumer, exceptionAsString);
        } else {
            IPerformanceMetrics m = trans.getMetaCas().getPerformanceMetrics();
            taskAllocator.onTaskSuccess(taskConsumer, m);
        }
    }

    public static void main(String[] args) {
    }
}

