/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.classload;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.container.common.classloader.ContextSwitch;
import org.apache.uima.ducc.container.common.classloader.ProxyHelper;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverDirective;
import org.apache.uima.ducc.user.common.PrivateClassLoader;

public class ProxyJobDriverErrorHandler {
    private static Logger logger = Logger.getLogger(ProxyJobDriverErrorHandler.class, IComponent.Id.JD.name());
    private URLClassLoader classLoader = null;
    private Object objectInstance = null;
    private Method methodInstanceHandle = null;
    private Object[] nullObjectArray = null;
    private Method methodInstanceIsKillJob = null;
    private Method methodInstanceIsKillProcess = null;
    private Method methodInstanceIsKillWorkItem = null;
    private static String packageName = "org.apache.uima.ducc.";
    private static String defaultClassName = packageName + "ErrorHandler";
    private static String directiveInterfaceName = packageName + "IErrorHandlerDirective";

    public ProxyJobDriverErrorHandler() throws JobDriverException {
        try {
            this.initialize();
        }
        catch (Exception e) {
            ProxyHelper.loggifyUserException(logger, e);
            throw new JobDriverException();
        }
    }

    private String getErrorHandlerClassname() {
        String location = "getErrorHandlerClassname";
        String retVal = null;
        try {
            FlagsHelper fh = FlagsHelper.getInstance();
            retVal = fh.getUserErrorHandlerClassname();
            String type = null;
            if (retVal != null) {
                type = "user";
            } else {
                String key;
                DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
                retVal = dpr.getProperty(key = "ducc.jd.error.handler.class");
                if (retVal != null) {
                    type = "system";
                } else {
                    type = "default";
                    retVal = defaultClassName;
                }
            }
            logger.info(location, ILogger.null_id, "type=" + type + " " + "value=" + retVal);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    private String getErrorHandlerInitArgs() {
        String location = "getErrorHandlerInitArgs";
        String retVal = null;
        try {
            String valueUser;
            FlagsHelper fh = FlagsHelper.getInstance();
            StringBuffer sb = new StringBuffer();
            DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
            String key = "ducc.jd.error.handler.args";
            String valueSystem = dpr.getFileProperty(key);
            if (valueSystem != null) {
                sb.append(valueSystem);
                sb.append(" ");
                String type = "system";
                logger.debug(location, ILogger.null_id, "type=" + type + " " + "value=" + valueSystem);
            }
            if ((valueUser = fh.getUserErrorHandlerCfg()) != null) {
                sb.append(valueUser);
                sb.append(" ");
                String type = "user";
                logger.debug(location, ILogger.null_id, "type=" + type + " " + "value=" + valueUser);
            }
            String value = sb.toString().trim();
            if (sb.length() > 0) {
                retVal = value;
                logger.trace(location, ILogger.null_id, "retVal=" + retVal);
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    private void initialize() throws Exception {
        Method[] directiveMethods;
        Method[] classMethods;
        String userClasspath;
        String location = "initialize";
        FlagsHelper fh = FlagsHelper.getInstance();
        String[] classpath = fh.stringToArray(userClasspath = fh.getUserClasspath());
        if (classpath != null) {
            for (String item : classpath) {
                logger.trace(location, ILogger.null_id, item);
            }
        }
        String className = this.getErrorHandlerClassname();
        String initializationData = this.getErrorHandlerInitArgs();
        this.classLoader = this.createClassLoader(userClasspath);
        Class<?> clazz = this.classLoader.loadClass(className);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object[] c_args = new Object[]{};
        this.objectInstance = ContextSwitch.construct(this.classLoader, constructor, c_args);
        String methodNameInitialize = "initialize";
        Method methodInstanceInitialize = clazz.getMethod(methodNameInitialize, String.class);
        Object[] plist = new Object[]{initializationData};
        ContextSwitch.call(this.classLoader, methodInstanceInitialize, this.objectInstance, plist);
        for (Method method : classMethods = clazz.getMethods()) {
            Class<?>[] types;
            if (!method.getName().equals("handle") || (types = method.getParameterTypes()).length != 2 || !((Object)types[0]).toString().contains("String") || !((Object)types[1]).toString().contains("Object")) continue;
            this.methodInstanceHandle = method;
            break;
        }
        Class<?> directiveAnchor = this.classLoader.loadClass(directiveInterfaceName);
        for (Method method : directiveMethods = directiveAnchor.getMethods()) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 0) continue;
            if (method.getName().equals("isKillJob")) {
                this.methodInstanceIsKillJob = method;
                continue;
            }
            if (method.getName().equals("isKillProcess")) {
                this.methodInstanceIsKillProcess = method;
                continue;
            }
            if (!method.getName().equals("isKillWorkItem")) continue;
            this.methodInstanceIsKillWorkItem = method;
        }
    }

    private URLClassLoader createClassLoader(String userClasspath) throws Exception {
        URLClassLoader retVal = null;
        retVal = PrivateClassLoader.create((String)userClasspath);
        return retVal;
    }

    public ProxyJobDriverDirective handle(String serializedCAS, Object userException) throws JobDriverException {
        String location = "handle";
        ProxyJobDriverDirective retVal = new ProxyJobDriverDirective();
        try {
            Object[] plist = new Object[]{serializedCAS, userException};
            Object directive = ContextSwitch.call(this.classLoader, this.methodInstanceHandle, this.objectInstance, plist);
            boolean isKillJob = (Boolean)ContextSwitch.call(this.classLoader, this.methodInstanceIsKillJob, directive, this.nullObjectArray);
            boolean isKillProcess = (Boolean)ContextSwitch.call(this.classLoader, this.methodInstanceIsKillProcess, directive, this.nullObjectArray);
            boolean isKillWorkItem = (Boolean)ContextSwitch.call(this.classLoader, this.methodInstanceIsKillWorkItem, directive, this.nullObjectArray);
            retVal = new ProxyJobDriverDirective(isKillJob, isKillProcess, isKillWorkItem);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    public ProxyJobDriverDirective handle(String serializedCAS) throws JobDriverException {
        String location = "handle";
        ProxyJobDriverDirective retVal = new ProxyJobDriverDirective();
        try {
            boolean isKillJob = false;
            boolean isKillProcess = false;
            boolean isKillWorkItem = false;
            retVal = new ProxyJobDriverDirective(isKillJob, isKillProcess, isKillWorkItem);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }
}

