/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.MetaCasHelper;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.cas.CasManagerStats;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverDirective;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverErrorHandler;
import org.apache.uima.ducc.container.jd.fsm.wi.Action;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.ErrorLogger;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.RemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.timeout.TimeoutManager;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;

public abstract class ActionEndAbstract
extends Action
implements IAction {
    private Logger logger = Logger.getLogger(ActionEndAbstract.class, IComponent.Id.JD.name());

    protected ActionEndAbstract(Logger logger) {
        this.logger = logger;
    }

    private void jdExhausted(IActionData actionData) {
        String location = "jdExhausted";
        JobDriver jd = JobDriver.getInstance();
        switch (jd.getJdState()) {
            case Ended: {
                break;
            }
            default: {
                jd.advanceJdState(IMetaCasTransaction.JdState.Ended);
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append(Standardize.Label.jdState.get() + (Object)((Object)JobDriver.getInstance().getJdState()));
                this.logger.info(location, ILogger.null_id, mb.toString());
                JobDriverHelper.getInstance().summarize();
            }
        }
    }

    protected void checkEnded(IActionData actionData, CasManager cm) {
        String location = "checkEnded";
        int remainder = cm.getCasManagerStats().getUnfinishedWorkCount();
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        mb.append(Standardize.Label.remainder.get() + remainder);
        this.logger.debug(location, ILogger.null_id, mb.toString());
        if (remainder <= 0) {
            this.jdExhausted(actionData);
        }
    }

    private void retryWorkItem(IActionData actionData, CasManager cm, IMetaCas metaCas) {
        String location = "retryWorkItem";
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        this.logger.info(location, ILogger.null_id, mb.toString());
        TimeoutManager.getInstance().cancelTimer(actionData);
        cm.putMetaCas(metaCas, CasManagerStats.RetryReason.UserErrorRetry);
        cm.getCasManagerStats().incEndRetry();
    }

    private void killWorkItem(IActionData actionData, CasManager cm) {
        String location = "killWorkItem";
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        this.logger.info(location, ILogger.null_id, mb.toString());
        cm.getCasManagerStats().incEndFailure();
        this.checkEnded(actionData, cm);
    }

    private void killJob(IActionData actionData, CasManager cm) {
        String location = "killJob";
        cm.getCasManagerStats().setKillJob();
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        this.logger.info(location, ILogger.null_id, mb.toString());
    }

    private void toJdErrLog(String text) {
        ErrorLogger.record(text);
    }

    protected void handleException(IActionData actionData, Object userException, String printableException) throws JobDriverException {
        MessageBuffer mb;
        String location = "handleException";
        MessageBuffer mb2 = LoggerHelper.getMessageBuffer(actionData);
        mb2.append((Object)((Object)Standardize.Label.enter) + "");
        this.logger.debug(location, ILogger.null_id, mb2.toString());
        IWorkItem wi = actionData.getWorkItem();
        IMetaCasTransaction trans = actionData.getMetaCasTransaction();
        RemoteWorkerProcess rwp = new RemoteWorkerProcess(trans);
        IMetaCas metaCas = wi.getMetaCas();
        JobDriver jd = JobDriver.getInstance();
        JobDriverHelper jdh = JobDriverHelper.getInstance();
        CasManager cm = jd.getCasManager();
        IWorkItemStateKeeper wisk = jd.getWorkItemStateKeeper();
        MetaCasHelper metaCasHelper = new MetaCasHelper(metaCas);
        IProcessStatistics pStats = jdh.getProcessStatistics(rwp);
        int seqNo = metaCasHelper.getSystemKey();
        try {
            if (printableException != null) {
                this.toJdErrLog(Standardize.Label.seqNo.get() + seqNo + " ***** EXCEPTION *****\n" + printableException);
            } else {
                this.toJdErrLog(Standardize.Label.seqNo.get() + seqNo + " ***** TIMEOUT *****\n" + userException.toString() + "\n");
            }
        }
        catch (Exception e) {
            this.logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        ProxyJobDriverDirective pjdd = null;
        try {
            String serializedCas = (String)metaCas.getUserSpaceCas();
            ProxyJobDriverErrorHandler pjdeh = jd.getProxyJobDriverErrorHandler();
            pjdd = pjdeh.handle(serializedCas, userException);
        }
        catch (Exception e) {
            this.logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        if (pjdd != null) {
            mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append(Standardize.Label.isKillJob.get() + pjdd.isKillJob());
            mb.append(Standardize.Label.isKillProcess.get() + pjdd.isKillProcess());
            mb.append(Standardize.Label.isKillWorkItem.get() + pjdd.isKillWorkItem());
            this.logger.info(location, ILogger.null_id, mb.toString());
            if (pjdd.isKillJob()) {
                wisk.error(seqNo);
                pStats.error(wi);
                this.killJob(actionData, cm);
                this.killWorkItem(actionData, cm);
            } else if (pjdd.isKillWorkItem()) {
                wisk.error(seqNo);
                pStats.error(wi);
                this.killWorkItem(actionData, cm);
            } else {
                wisk.retry(seqNo);
                pStats.retry(wi);
                this.retryWorkItem(actionData, cm, metaCas);
            }
        } else {
            wisk.error(seqNo);
            pStats.error(wi);
            this.killWorkItem(actionData, cm);
        }
        mb = LoggerHelper.getMessageBuffer(actionData);
        mb.append((Object)((Object)Standardize.Label.exit) + "");
        this.logger.debug(location, ILogger.null_id, mb.toString());
    }
}

