/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.jd.files.workitem.IRemoteLocation;
import org.apache.uima.ducc.common.jd.files.workitem.IWorkItemStateKeeper;
import org.apache.uima.ducc.common.jd.files.workitem.WorkItemStateKeeper;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.container.common.FlagsExtendedHelper;
import org.apache.uima.ducc.container.common.IJdConstants;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.dgen.DgenManager;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverErrorHandler;
import org.apache.uima.ducc.container.jd.mh.IMessageHandler;
import org.apache.uima.ducc.container.jd.mh.MessageHandler;
import org.apache.uima.ducc.container.jd.mh.iface.IOperatingInfo;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemotePid;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.IWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.WorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceSummaryKeeper;
import org.apache.uima.ducc.container.jd.wi.perf.WorkItemPerformanceSummaryKeeper;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;

public class JobDriver {
    private static Logger logger = Logger.getLogger(JobDriver.class, IComponent.Id.JD.name());
    private static JobDriver instance = null;
    private String jobId = null;
    private String logDir = null;
    private long workItemTimeoutMillis = 86400000L;
    private ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> remoteWorkerThreadMap = null;
    private ConcurrentHashMap<IRemotePid, IProcessStatistics> remoteProcessMap = null;
    private Map<IRemoteLocation, IJdConstants.DeallocateReason> killProcessMap = null;
    private IWorkItemStatistics wis = null;
    private CasManager cm = null;
    private ProxyJobDriverErrorHandler pjdeh = null;
    private IMessageHandler mh = null;
    private DgenManager ddManager = null;
    private IWorkItemStateKeeper wisk = null;
    private IWorkItemPerformanceSummaryKeeper wipsk = null;
    private IMetaCasTransaction.JdState jdState = IMetaCasTransaction.JdState.Prelaunch;
    private boolean killJob = false;
    private IOperatingInfo.CompletionType completionType = IOperatingInfo.CompletionType.Normal;
    private String completionText = null;

    public static synchronized JobDriver getInstance() {
        String location = "getInstance";
        if (instance == null) {
            try {
                instance = new JobDriver();
            }
            catch (JobDriverException e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        }
        return instance;
    }

    public static synchronized JobDriver getNewInstance() {
        instance = null;
        return JobDriver.getInstance();
    }

    private JobDriver() throws JobDriverException {
        this.initialize();
    }

    private void initialize() throws JobDriverException {
        String location = "initialize";
        try {
            this.advanceJdState(IMetaCasTransaction.JdState.Initializing);
            FlagsExtendedHelper feh = FlagsExtendedHelper.getInstance();
            this.jobId = feh.getJobId();
            this.logDir = feh.getLogDirectory();
            this.setWorkItemTimeout();
            this.remoteWorkerThreadMap = new ConcurrentHashMap();
            this.remoteProcessMap = new ConcurrentHashMap();
            this.killProcessMap = new ConcurrentHashMap<IRemoteLocation, IJdConstants.DeallocateReason>();
            this.wis = new WorkItemStatistics();
            this.wisk = new WorkItemStateKeeper(IComponent.Id.JD.name(), this.logDir);
            this.wipsk = new WorkItemPerformanceSummaryKeeper(this.logDir);
            this.cm = new CasManager();
            this.pjdeh = new ProxyJobDriverErrorHandler();
            this.ddManager = new DgenManager();
            this.mh = new MessageHandler();
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new JobDriverException();
        }
    }

    private void setWorkItemTimeout() {
        String location = "setWorkItemTimeout";
        try {
            String workItemTimeout;
            FlagsExtendedHelper feh = FlagsExtendedHelper.getInstance();
            String value = workItemTimeout = feh.getWorkItemTimeout();
            if (value != null) {
                this.workItemTimeoutMillis = Long.parseLong(workItemTimeout) * 60000L;
                MessageBuffer mb = new MessageBuffer();
                mb.append(Standardize.Label.value.get() + this.workItemTimeoutMillis);
                logger.trace(location, ILogger.null_id, mb.toString());
            } else {
                MessageBuffer mb = new MessageBuffer();
                mb.append(Standardize.Label.value.get() + this.workItemTimeoutMillis);
                logger.trace(location, ILogger.null_id, mb.toString());
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public ConcurrentHashMap<IRemoteWorkerThread, IWorkItem> getRemoteWorkerThreadMap() {
        return this.remoteWorkerThreadMap;
    }

    public ConcurrentHashMap<IRemotePid, IProcessStatistics> getRemoteProcessMap() {
        return this.remoteProcessMap;
    }

    public IWorkItemStatistics getWorkItemStatistics() {
        return this.wis;
    }

    public CasManager getCasManager() {
        return this.cm;
    }

    public ProxyJobDriverErrorHandler getProxyJobDriverErrorHandler() {
        return this.pjdeh;
    }

    public IMessageHandler getMessageHandler() {
        return this.mh;
    }

    public DgenManager getDdManager() {
        return this.ddManager;
    }

    public long getWorkItemTimeoutMillis() {
        return this.workItemTimeoutMillis;
    }

    public IWorkItemStateKeeper getWorkItemStateKeeper() {
        return this.wisk;
    }

    public IWorkItemPerformanceSummaryKeeper getWorkItemPerformanceSummaryKeeper() {
        return this.wipsk;
    }

    public Map<IRemoteLocation, IJdConstants.DeallocateReason> getkillProcessMap() {
        return this.killProcessMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetaCasTransaction.JdState getJdState() {
        IMetaCasTransaction.JdState jdState = this.jdState;
        synchronized (jdState) {
            return this.jdState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceJdState(IMetaCasTransaction.JdState value) {
        String location = "advanceJdState";
        String request = value.name();
        String current = null;
        String result = null;
        IMetaCasTransaction.JdState jdState = this.jdState;
        synchronized (jdState) {
            current = this.jdState.name();
            switch (this.jdState) {
                case Ended: {
                    break;
                }
                case Active: {
                    switch (value) {
                        case Ended: {
                            this.jdState = value;
                            this.wipsk.publish();
                        }
                    }
                    break;
                }
                case Initializing: {
                    switch (value) {
                        case Ended: {
                            this.jdState = value;
                            break;
                        }
                        case Active: {
                            this.jdState = value;
                        }
                    }
                    break;
                }
                case Prelaunch: {
                    switch (value) {
                        case Initializing: {
                            this.jdState = value;
                        }
                    }
                }
            }
            result = this.jdState.name();
        }
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.current.get() + current);
        mb.append(Standardize.Label.request.get() + request);
        mb.append(Standardize.Label.result.get() + result);
        if (current.equals(result)) {
            logger.trace(location, ILogger.null_id, mb.toString());
        } else {
            logger.info(location, ILogger.null_id, mb.toString());
        }
    }

    public void killProcess(IRemoteLocation remoteLocation, IJdConstants.DeallocateReason reason) {
        String location = "killProcess";
        if (remoteLocation != null && reason != null && !this.killProcessMap.containsKey(remoteLocation)) {
            this.killProcessMap.put(remoteLocation, reason);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.id.get() + remoteLocation.toString());
            mb.append(Standardize.Label.reason.get() + reason.toString());
            logger.info(location, ILogger.null_id, mb.toString());
        }
    }

    public void killJob(IOperatingInfo.CompletionType value) {
        this.killJob(value, null);
    }

    public void killJob(IOperatingInfo.CompletionType value, String text) {
        if (!this.killJob) {
            this.killJob = true;
            this.completionType = value;
            this.completionText = text;
        }
    }

    public boolean isKillJob() {
        return this.killJob;
    }

    public boolean isFinito() {
        boolean retVal = false;
        if (this.cm.getCasManagerStats().isKillJob()) {
            retVal = true;
        } else if (this.cm.getCasManagerStats().isExhausted()) {
            retVal = true;
        }
        return retVal;
    }

    public IOperatingInfo.CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getCompletionText() {
        return this.completionText;
    }

    public int getStartupInitializationErrorLimit() {
        int startup_initialization_error_limit = DuccPropertiesResolver.get((String)"ducc.jd.startup.initialization.error.limit", (int)1);
        return startup_initialization_error_limit;
    }
}

