/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.dgen.classload;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.container.common.FlagsExtendedHelper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.classloader.PrivateClassLoader;
import org.apache.uima.ducc.container.common.classloader.ProxyException;
import org.apache.uima.ducc.container.common.classloader.ProxyLogger;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.dgen.classload.ProxyDeployableGenerationException;

public class ProxyDeployableGeneration {
    private static Logger logger = Logger.getLogger(ProxyDeployableGeneration.class, IComponent.Id.JD.name());
    private URLClassLoader urlClassLoader = null;
    private String[] requiredClasses = new String[]{"org.apache.uima.ducc.user.dgen.iface.DeployableGeneration", "org.apache.uima.ducc.user.dgen.iface.IDeployableGeneration"};

    public ProxyDeployableGeneration() throws ProxyDeployableGenerationException {
        this.initialize();
    }

    private void show(String text) {
        String location = "show";
        logger.info(location, ILogger.null_id, text);
        System.out.println(text);
    }

    private void show(String name, String value) {
        this.show(name + "=" + value);
    }

    private void show(String name, Integer value) {
        this.show(name + "=" + value.toString());
    }

    private void show(String name, List<String> value) {
        if (value == null) {
            this.show(name + "=" + value);
        } else {
            this.show(name + "=" + value.toString());
        }
    }

    public String generate(String directory, String id, String dgenName, String dgenDescription, Integer dgenThreadCount, String dgenBrokerURL, String dgenEndpoint, String dgenFlowController, String cmDescriptor, List<String> cmOverrides, String aeDescriptor, List<String> aeOverrides, String ccDescriptor, List<String> ccOverrides) throws ProxyDeployableGenerationException, ProxyException {
        String retVal = null;
        try {
            this.show("directory", directory);
            this.show("id", id);
            this.show("dgenName", dgenName);
            this.show("dgenDescription", dgenDescription);
            this.show("dgenThreadCount", dgenThreadCount);
            this.show("dgenBrokerURL", dgenBrokerURL);
            this.show("dgenEndpoint", dgenEndpoint);
            this.show("degnFlowController", dgenFlowController);
            this.show("cmDescriptor", cmDescriptor);
            this.show("cmOverrides", cmOverrides);
            this.show("aeDescriptor", aeDescriptor);
            this.show("aeOverrides", aeOverrides);
            this.show("ccDescriptor", ccDescriptor);
            this.show("ccOverrides", ccOverrides);
            Class<?> clazz = this.urlClassLoader.loadClass("org.apache.uima.ducc.user.dgen.iface.DeployableGeneration");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            Class[] parameterTypes = new Class[]{String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, List.class, String.class, List.class, String.class, List.class};
            Method method = clazz.getMethod("generate", parameterTypes);
            Object[] args = new Object[]{directory, id, dgenName, dgenDescription, dgenThreadCount, dgenBrokerURL, dgenEndpoint, dgenFlowController, cmDescriptor, cmOverrides, aeDescriptor, aeOverrides, ccDescriptor, ccOverrides};
            String dgen = (String)method.invoke(instance, args);
            this.show("generated deployment descriptor", dgen);
            retVal = dgen;
        }
        catch (Exception e) {
            ProxyLogger.loggifyUserException(e);
            throw new ProxyException();
        }
        return retVal;
    }

    public String generate(String directory, String id, String dgenName, String dgenDescription, Integer dgenThreadCount, String dgenBrokerURL, String dgenEndpoint, String dgenFlowController, String referenceByName) throws ProxyException {
        String retVal = null;
        try {
            this.show("directory", directory);
            this.show("id", id);
            this.show("dgenName", dgenName);
            this.show("dgenDescription", dgenDescription);
            this.show("dgenThreadCount", dgenThreadCount);
            this.show("dgenBrokerURL", dgenBrokerURL);
            this.show("dgenEndpoint", dgenEndpoint);
            this.show("degnFlowController", dgenFlowController);
            this.show("referenceByName", referenceByName);
            Class<?> clazz = this.urlClassLoader.loadClass("org.apache.uima.ducc.user.dgen.iface.DeployableGeneration");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            Class[] parameterTypes = new Class[]{String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, String.class, String.class};
            Method method = clazz.getMethod("generate", parameterTypes);
            Object[] args = new Object[]{directory, id, dgenName, dgenDescription, dgenThreadCount, dgenBrokerURL, dgenEndpoint, dgenFlowController, referenceByName};
            String dgen = (String)method.invoke(instance, args);
            this.show("generated deployment descriptor", dgen);
            retVal = dgen;
        }
        catch (Exception e) {
            ProxyLogger.loggifyUserException(e);
            throw new ProxyException();
        }
        return retVal;
    }

    private String getUimaAsDirectory() throws Exception {
        String location = "getUimaAsDirectory";
        try {
            StringBuffer sb = new StringBuffer();
            String duccHome = Utils.findDuccHome();
            sb.append(duccHome);
            if (!duccHome.endsWith(File.separator)) {
                sb.append(File.separator);
            }
            sb.append("apache-uima");
            sb.append(File.separator);
            sb.append("lib");
            sb.append(File.separator);
            sb.append("*");
            String retVal = sb.toString();
            logger.info(location, ILogger.null_id, retVal);
            return retVal;
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw e;
        }
    }

    private String augmentUserClasspath() throws ProxyDeployableGenerationException {
        String location = "augmentUserClasspath";
        try {
            StringBuffer sb = new StringBuffer();
            FlagsExtendedHelper feh = FlagsExtendedHelper.getInstance();
            String userClasspath = feh.getUserClasspath();
            sb.append(userClasspath);
            if (!userClasspath.endsWith(File.pathSeparator)) {
                sb.append(File.pathSeparator);
            }
            sb.append(this.getUimaAsDirectory());
            String retVal = sb.toString();
            logger.info(location, ILogger.null_id, retVal);
            return retVal;
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new ProxyDeployableGenerationException(e);
        }
    }

    private void initialize() throws ProxyDeployableGenerationException {
        String userClasspath = this.augmentUserClasspath();
        this.urlClassLoader = this.createClassLoader(userClasspath);
        this.validate();
    }

    private URLClassLoader createClassLoader(String userClasspath) {
        String location = "createClassLoader";
        URLClassLoader retVal = null;
        try {
            retVal = PrivateClassLoader.create(userClasspath);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    private void validate() throws ProxyDeployableGenerationException {
        for (String className : this.requiredClasses) {
            this.loadClass(className);
        }
    }

    private void loadClass(String className) throws ProxyDeployableGenerationException {
        String location = "loadClass";
        try {
            URL[] urls;
            MessageBuffer mb1 = new MessageBuffer();
            mb1.append(Standardize.Label.loading.get() + className);
            logger.debug(location, ILogger.null_id, mb1.toString());
            for (URL url : urls = this.urlClassLoader.getURLs()) {
                logger.trace(location, ILogger.null_id, url);
            }
            Class<?> loadedClass = this.urlClassLoader.loadClass(className);
            MessageBuffer mb2 = new MessageBuffer();
            mb2.append(Standardize.Label.loaded.get() + loadedClass.getName());
            logger.trace(location, ILogger.null_id, mb2.toString());
        }
        catch (Exception e) {
            DuccLogger duccLogger = DuccLogger.getLogger(ProxyDeployableGeneration.class, (String)"JD");
            duccLogger.error(location, null, (Throwable)e, new Object[0]);
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new ProxyDeployableGenerationException(e);
        }
    }
}

