/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.admin.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.admin.event.RmQueriedClass;
import org.apache.uima.ducc.common.admin.event.RmQueriedNodepool;

public class RmAdminQLoadReply
extends RmAdminReply {
    private static final long serialVersionUID = 1L;
    private boolean ready = true;
    private long shareQuantum;
    private List<RmQueriedNodepool> nodepools = new ArrayList<RmQueriedNodepool>();
    private List<RmQueriedClass> classes = new ArrayList<RmQueriedClass>();

    public void setShareQuantum(long q) {
        this.shareQuantum = q / 0x100000L;
    }

    public void addNodepool(RmQueriedNodepool np) {
        this.nodepools.add(np);
    }

    public void addClass(RmQueriedClass cl) {
        this.classes.add(cl);
    }

    public long getShareQuantum() {
        return this.shareQuantum;
    }

    public List<RmQueriedNodepool> getNodepools() {
        return this.nodepools;
    }

    public List<RmQueriedClass> getClasses() {
        return this.classes;
    }

    @Override
    public void notReady() {
        this.ready = false;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    public String toString() {
        if (!this.ready) {
            return "RM is not yet initialized.";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{\n'quantum':");
        sb.append(Long.toString(this.shareQuantum));
        sb.append(",\n'classes': [\n");
        for (RmQueriedClass cl : this.classes) {
            sb.append(cl.toString());
            sb.append("\n,");
        }
        sb.append("],\n'nodepools': [\n");
        for (RmQueriedNodepool np : this.nodepools) {
            sb.append(np.toString());
            sb.append("\n,");
        }
        sb.append("],\n}");
        return sb.toString();
    }
}

