/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common;

import java.io.Serializable;

public class SizeBytes
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static long KB = 1024L;
    public static long MB = 1024L * KB;
    public static long GB = 1024L * MB;
    public static long TB = 1024L * MB;
    private long value;

    public static Type getType(String value) {
        Type retVal = Type.Bytes;
        if (value != null) {
            if (value.equalsIgnoreCase("TB")) {
                retVal = Type.TBytes;
            } else if (value.equalsIgnoreCase("GB")) {
                retVal = Type.GBytes;
            } else if (value.equalsIgnoreCase("MB")) {
                retVal = Type.MBytes;
            } else if (value.equalsIgnoreCase("KB")) {
                retVal = Type.KBytes;
            }
        }
        return retVal;
    }

    public SizeBytes(Type type, long value) {
        this.initialize(type, value);
    }

    public SizeBytes(String units, long value) {
        this.initialize(SizeBytes.getType(units), value);
    }

    private void initialize(Type type, long value) {
        switch (type) {
            case TBytes: {
                this.setValue(TB * value);
                break;
            }
            case GBytes: {
                this.setValue(GB * value);
                break;
            }
            case MBytes: {
                this.setValue(MB * value);
                break;
            }
            case KBytes: {
                this.setValue(KB * value);
                break;
            }
            case Bytes: {
                this.setValue(value);
            }
        }
    }

    public long getBytes() {
        return this.value;
    }

    public long getKBytes() {
        return this.value / KB;
    }

    public long getMBytes() {
        return this.value / MB;
    }

    public long getGBytes() {
        return this.value / GB;
    }

    public long getTBytes() {
        return this.value / TB;
    }

    private void setValue(long value) {
        this.value = value;
    }

    public static enum Type {
        TBytes,
        GBytes,
        MBytes,
        KBytes,
        Bytes;

    }
}

