/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.uima.ducc.common.utils.LoggingException;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccLogger {
    private Logger logger;
    private String component = "";
    private static DuccLoggingThread log_thread = null;
    private static LinkedBlockingQueue<DuccLoggingEvent> events = null;
    private static AtomicBoolean threaded = new AtomicBoolean(false);
    private static boolean watchdogStarted = false;
    private static final String DEFAULT_COMPONENT = "DUCC";
    private static List<Logger> nonDuccLoggers = new ArrayList<Logger>();
    private boolean debug = System.getProperty("log4j.debug") != null;
    private String defaultId = "N/A";
    private final String padding = "                ";
    private static Throwable loggingError = null;
    private static boolean disable_logger = false;

    protected static synchronized void initLogger() {
        if (log_thread == null) {
            events = new LinkedBlockingQueue();
            log_thread = new DuccLoggingThread();
            log_thread.setName("DuccLoggerThread");
            log_thread.setDaemon(true);
            log_thread.start();
        }
    }

    public static DuccLogger getLogger(Class claz, String component) {
        return new DuccLogger(claz, component);
    }

    public static DuccLogger getLogger(String claz, String component) {
        return new DuccLogger(claz, component);
    }

    public DuccLogger getLoggerFor(String claz) {
        if (this.logger == null) {
            System.out.println("DuccLogger is not initialized, cannot create logger for(" + claz + ").");
            return this;
        }
        if (claz == null) {
            throw new IllegalArgumentException("New log name must not be null");
        }
        DuccLogger ret = DuccLogger.getLogger(claz, this.getComponent());
        for (Logger l = this.logger; l != null; l = l.getParent()) {
            Enumeration apps = l.getAllAppenders();
            if (!apps.hasMoreElements()) continue;
            while (apps.hasMoreElements()) {
                Appender app = (Appender)apps.nextElement();
                if (ret.getAppender(app.getName()) != null) continue;
                ret.addAppender(app);
            }
        }
        return ret;
    }

    void removeAllAppenders() {
        this.logger.removeAllAppenders();
    }

    void addAppender(Appender app) {
        this.logger.addAppender(app);
    }

    Appender getAppender(String name) {
        return this.logger.getAppender(name);
    }

    public static void setUnthreaded() {
        System.out.println("setUnthreaded is not supported.");
    }

    public static void setThreaded() {
        threaded.set(true);
    }

    public DuccLogger(String claz, String component) {
        String ducc_home = System.getProperty("DUCC_HOME");
        if (ducc_home == null) {
            System.out.println("WARNING: Cannot find system property DUCC_HOME to configure ducc logger.  Using default log4j configurator.");
        } else if (!watchdogStarted) {
            String configFile = System.getProperty("DUCC_HOME") + "/resources/log4j.xml";
            String nodeName = System.getProperty("DUCC_NODENAME");
            if (nodeName != null && !nodeName.isEmpty()) {
                nodeName = nodeName.split("\\.", 2)[0];
                File cfgFile = new File(System.getProperty("DUCC_HOME") + "/resources/" + nodeName + "-log4j.xml");
                if (cfgFile.exists()) {
                    configFile = cfgFile.getAbsolutePath();
                    System.out.println("DuccLogger will use configuration file: " + configFile);
                }
            }
            String usersValue = System.setProperty("log4j.configuration", "file:" + configFile);
            DOMConfigurator.configureAndWatch((String)configFile);
            if (usersValue == null) {
                System.clearProperty("log4j.configuration");
            } else {
                System.setProperty("log4j.configuration", usersValue);
            }
            watchdogStarted = true;
        }
        if (this.debug) {
            System.out.println("Creating logger '" + claz + "' with component " + component);
        }
        if (component == null) {
            component = (String)MDC.get((String)"COMPONENT");
            if (component == null) {
                component = DEFAULT_COMPONENT;
            }
            Enumeration all_loggers = LogManager.getCurrentLoggers();
            while (all_loggers.hasMoreElements()) {
                Logger l = (Logger)all_loggers.nextElement();
                String n = l.getName();
                if (this.debug) {
                    System.out.println(" ===> Configured loggers " + n);
                }
                if (n.startsWith("org.apache.uima.ducc")) continue;
                if (this.debug) {
                    System.out.println("      Special logger: " + n);
                }
                nonDuccLoggers.add(l);
            }
        }
        this.component = component;
        this.logger = Logger.getLogger((String)claz);
        MDC.put((String)"COMPONENT", (Object)component);
        DuccLogErrorHandler errHandler = new DuccLogErrorHandler(this);
        Enumeration appenders = this.logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender app = (Appender)appenders.nextElement();
            app.setErrorHandler((ErrorHandler)errHandler);
        }
    }

    public DuccLogger(Class claz, String component) {
        this(claz.getName(), component);
    }

    public DuccLogger(Class claz) {
        this(claz, null);
    }

    public DuccLogger(String claz) {
        this(claz, null);
    }

    public boolean isDefaultLogger() {
        return this.component.equals(DEFAULT_COMPONENT);
    }

    public void setAdditionalAppenders() {
        if (this.debug) {
            System.out.println("============ Looking for appenders -----------");
        }
        if (this.isDefaultLogger()) {
            if (this.debug) {
                System.out.println(" ---> Skipping appender search for default component");
            }
            return;
        }
        for (Logger l = this.logger; l != null; l = l.getParent()) {
            Enumeration apps = l.getAllAppenders();
            if (apps.hasMoreElements()) {
                while (apps.hasMoreElements()) {
                    Appender app = (Appender)apps.nextElement();
                    if (l.getName().startsWith("org.apache.uima.ducc")) {
                        if (this.debug) {
                            System.out.println(" ---> Found appender " + app.getName() + " on logger " + l.getName());
                        }
                        for (Logger ll : nonDuccLoggers) {
                            if (this.debug) {
                                System.out.println(" ---> Add appender " + app.getName() + " to logger " + ll.getName());
                            }
                            if (ll.getAppender(app.getName()) != null) continue;
                            ll.addAppender(app);
                        }
                        continue;
                    }
                    if (!this.debug) continue;
                    System.out.println(" ---> Skipping non-DUCC appender " + app.getName() + " on logger " + l.getName());
                }
                continue;
            }
            if (!this.debug) continue;
            System.out.println(" ---> No appenders on logger " + l.getName());
        }
    }

    public String getComponent() {
        return this.component;
    }

    public void setLevel(Level l) {
        this.logger.setLevel(l);
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public boolean isLevelEnabled(Level l) {
        return l.isGreaterOrEqual((Priority)this.logger.getEffectiveLevel());
    }

    public boolean isFatal() {
        return this.isLevelEnabled(Level.FATAL);
    }

    public boolean isDebug() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    public boolean isError() {
        return this.isLevelEnabled(Level.ERROR);
    }

    public boolean isInfo() {
        return this.isLevelEnabled(Level.INFO);
    }

    public boolean isWarn() {
        return this.isLevelEnabled(Level.WARN);
    }

    public boolean isTrace() {
        return this.isLevelEnabled(Level.TRACE);
    }

    protected String formatMsg(DuccId pid, Object ... args) {
        String header = this.format(pid);
        String msg = this.formatMsg(args);
        return header + " " + msg;
    }

    private void appendStackTrace(StringBuffer s, Throwable t) {
        StackTraceElement[] stacktrace;
        s.append("\nAt:\n");
        for (StackTraceElement ste : stacktrace = t.getStackTrace()) {
            s.append("\t");
            s.append(ste.toString());
            s.append("\n");
        }
    }

    protected String formatMsg(Object ... args) {
        StringBuffer s = new StringBuffer();
        for (Object a : args) {
            if (a == null) {
                a = "<null>";
            }
            s.append(" ");
            if (a instanceof Throwable) {
                Throwable t = (Throwable)a;
                s.append(t.toString());
                s.append("\n");
                this.appendStackTrace(s, t);
                continue;
            }
            s.append(a.toString());
        }
        return s.toString();
    }

    public void setDefaultDuccId(String defaultDuccId) {
        if (defaultDuccId != null) {
            this.defaultId = defaultDuccId;
        }
    }

    private String format(DuccId duccId) {
        String id;
        if (duccId == null) {
            id = this.defaultId;
        } else {
            id = duccId.toString();
            int increase = id.length() - this.defaultId.length();
            if (increase > 0) {
                this.defaultId = this.defaultId + "                ".substring(0, increase);
            }
        }
        return id;
    }

    protected void setMDC() {
    }

    protected void clearMDC() {
    }

    public void doAppend(Level level, String method, DuccId jobid, String msg, Throwable t) {
        DuccLoggingEvent ev = new DuccLoggingEvent(this.logger, this.component, level, method, jobid, msg, t, Thread.currentThread().getId(), Thread.currentThread().getName());
        if (threaded.get()) {
            events.offer(ev);
        } else {
            DuccLogger.doLog(ev);
        }
    }

    public void doAppend(Level level, String method, DuccId jobid, String msg) {
        DuccLoggingEvent ev = new DuccLoggingEvent(this.logger, this.component, level, method, jobid, msg, null, Thread.currentThread().getId(), Thread.currentThread().getName());
        if (threaded.get()) {
            events.offer(ev);
        } else {
            DuccLogger.doLog(ev);
        }
    }

    public void fatal(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, location, jobid, this.formatMsg(args));
        }
    }

    public void fatal(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, location, jobid, this.formatMsg(args), t);
        }
    }

    public void fatal(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, location, jobid, this.formatMsg(processId, args));
        }
    }

    public void fatal(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, location, jobid, this.formatMsg(processId, args), t);
        }
    }

    public void debug(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, location, jobid, this.formatMsg(args));
        }
    }

    public void debug(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, location, jobid, this.formatMsg(args), t);
        }
    }

    public void debug(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, location, jobid, this.formatMsg(processId, args));
        }
    }

    public void debug(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, location, jobid, this.formatMsg(processId, args), t);
        }
    }

    public void error(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, location, jobid, this.formatMsg(args));
        }
    }

    public void error(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, location, jobid, this.formatMsg(args), t);
        }
    }

    public void error(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, location, jobid, this.formatMsg(processId, args));
        }
    }

    public void error(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, location, jobid, this.formatMsg(processId, args), t);
        }
    }

    public void info(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, location, jobid, this.formatMsg(args));
        }
    }

    public void info(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, location, jobid, this.formatMsg(args), t);
        }
    }

    public void info(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, location, jobid, this.formatMsg(processId, args));
        }
    }

    public void info(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, location, jobid, this.formatMsg(processId, args), t);
        }
    }

    public void trace(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, location, jobid, this.formatMsg(args));
        }
    }

    public void trace(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, location, jobid, this.formatMsg(args), t);
        }
    }

    public void trace(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, location, jobid, this.formatMsg(processId, args));
        }
    }

    public void trace(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, location, jobid, this.formatMsg(processId, args), t);
        }
    }

    public void warn(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, location, jobid, this.formatMsg(args));
        }
    }

    public void warn(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, location, jobid, this.formatMsg(args), t);
        }
    }

    public void warn(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, location, jobid, this.formatMsg(processId, args));
        }
    }

    public void warn(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, location, jobid, this.formatMsg(processId, args), t);
        }
    }

    public void shutdown() {
        if (threaded.get()) {
            DuccLoggingEvent ev = new DuccLoggingEvent();
            ev.done = true;
            events.offer(ev);
        }
    }

    protected static void setThrowable(Throwable t) {
        loggingError = t;
    }

    protected static synchronized void doLog(DuccLoggingEvent ev) {
        if (disable_logger) {
            return;
        }
        MDC.put((String)"COMPONENT", (Object)ev.component);
        MDC.put((String)"TID", (Object)ev.tid);
        MDC.put((String)"JID", (Object)ev.jobid);
        MDC.put((String)"METHOD", (Object)ev.method);
        MDC.put((String)"TNAME", (Object)ev.threadName);
        try {
            if (ev.throwable == null) {
                ev.logger.log((Priority)ev.level, ev.msg);
            } else {
                ev.logger.log((Priority)ev.level, ev.msg, ev.throwable);
            }
            if (loggingError != null) {
                throw loggingError;
            }
        }
        catch (Throwable t) {
            loggingError = null;
            if (threaded.get()) {
                System.out.println("Disabling logging due to logging exception.");
                disable_logger = true;
                throw new LoggingException("Error writing to DUCC logs", t);
            }
            StringWriter errors = new StringWriter();
            t.printStackTrace(new PrintWriter(errors));
            System.out.println(errors.toString());
            System.out.println("Unable to log due to logging exception.");
        }
    }

    static class DuccLogErrorHandler
    implements ErrorHandler {
        DuccLogger duccLogger = null;

        DuccLogErrorHandler(DuccLogger dl) {
            this.duccLogger = dl;
        }

        public void error(String msg) {
            System.err.println("A " + msg);
        }

        public void error(String msg, Exception e, int code) {
            System.err.println("B " + msg);
            loggingError = e;
        }

        public void error(String msg, Exception e, int code, LoggingEvent ev) {
            System.err.println("C " + msg);
            loggingError = e;
        }

        public void setAppender(Appender appender) {
            System.err.println("D");
        }

        public void setBackupAppender(Appender appender) {
            System.err.println("E");
        }

        public void setLogger(Logger logger) {
            System.err.println("F");
        }

        public void activateOptions() {
            System.err.println("G");
        }
    }

    static class DuccLoggingThread
    extends Thread {
        DuccLoggingThread() {
        }

        @Override
        public void run() {
            while (true) {
                DuccLoggingEvent ev = null;
                try {
                    ev = (DuccLoggingEvent)events.take();
                }
                catch (InterruptedException e) {
                    System.out.println("Logger is interrupted!");
                    continue;
                }
                if (ev.done) {
                    return;
                }
                DuccLogger.doLog(ev);
            }
        }
    }

    class DuccLoggingEvent {
        Logger logger;
        String component;
        Level level;
        Object msg;
        Throwable throwable;
        boolean done = false;
        long tid;
        String threadName;
        String method;
        String jobid;

        DuccLoggingEvent() {
        }

        DuccLoggingEvent(Logger logger, String component, Level level, String method, DuccId jobid, Object msg, Throwable throwable, long threadId, String threadName) {
            this.logger = logger;
            this.component = component.trim();
            this.level = level;
            this.method = method.trim();
            this.jobid = DuccLogger.this.format(jobid);
            this.msg = msg;
            this.throwable = throwable;
            this.tid = threadId;
            this.threadName = threadName.trim();
        }
    }
}

