/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils.id;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.persistence.IPropertiesFileManager;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.IDuccIdFactory;

public class DuccIdFactory
implements IDuccIdFactory {
    private AtomicLong seqno = new AtomicLong(-1L);
    private IPropertiesFileManager propertiesFileManager = null;
    private String propertiesFileKey = null;

    public DuccIdFactory() {
    }

    public DuccIdFactory(IPropertiesFileManager propertiesFileManager, String propertiesFileKey) {
        this.propertiesFileManager = propertiesFileManager;
        this.propertiesFileKey = propertiesFileKey;
    }

    public DuccIdFactory(long seed) {
        this.seqno.set(seed - 1L);
    }

    public DuccId next(long s) {
        this.seqno.set(Math.max(s, this.seqno.get()));
        return new DuccId(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuccId next() {
        DuccIdFactory duccIdFactory = this;
        synchronized (duccIdFactory) {
            if (this.propertiesFileManager != null) {
                this.seqno.set(this.propertiesFileManager.increment(this.propertiesFileKey));
            } else {
                this.seqno.incrementAndGet();
            }
            return new DuccId(this.seqno.get());
        }
    }
}

