/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.ducc.common.IIdentity;
import org.springframework.util.PropertyPlaceholderHelper;

public class Utils {
    public static final String FileSeparator = System.getProperty("file.separator");
    static String DUCC_HOME = null;

    public static boolean isIpAddress(String ip) {
        String two_five_five = "(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2(?:[0-4][0-9]|5[0-5]))";
        Pattern IPPattern = Pattern.compile("^(?:" + two_five_five + "\\.){3}" + two_five_five + "$");
        return IPPattern.matcher(ip).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePort() {
        ServerSocket socket = null;
        int port = 0;
        try {
            socket = new ServerSocket(0);
            port = socket.getLocalPort();
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean portAvailable(int port) {
        ServerSocket sock = null;
        try {
            sock = new ServerSocket();
            sock.bind(new InetSocketAddress(port));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
    }

    public static boolean isThisNode(String node, String thisNodeIP) throws Exception {
        return Utils.isIpAddress(node) && thisNodeIP.equals(node.trim());
    }

    private static boolean isThisNode(String node, List<IIdentity> nodeIdentities) throws Exception {
        if (Utils.isIpAddress(node)) {
            for (IIdentity identity : nodeIdentities) {
                if (!identity.getIP().startsWith(node)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTargetNodeForMessage(String targetNodeList, String thisNodeIP) throws Exception {
        String[] nodes;
        for (String node : nodes = targetNodeList.split(",")) {
            if (!Utils.isThisNode(node, thisNodeIP)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargetNodeForMessage(String targetNodeList, List<IIdentity> nodeIdentities) throws Exception {
        String[] nodes;
        for (String node : nodes = targetNodeList.split(",")) {
            if (!Utils.isThisNode(node, nodeIdentities)) continue;
            return true;
        }
        return false;
    }

    public static Properties loadPropertiesFromClasspathForResource(String resource) throws Exception {
        InputStream in = null;
        Properties properties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!resource.endsWith(".properties")) {
            resource = resource + ".properties";
        }
        if ((in = loader.getResourceAsStream(resource)) == null) {
            throw new IOException("Process Group Configuration File:" + resource + ".properties Not Found in the Classpath");
        }
        properties = new Properties();
        properties.load(in);
        return properties;
    }

    public static List<String> getHostsFromFile(String hostFilePath) throws Exception {
        ArrayList<String> nodeList = new ArrayList<String>();
        File nodesFile = new File(hostFilePath);
        if (nodesFile.exists()) {
            FileInputStream fstream = new FileInputStream(nodesFile);
            try (DataInputStream in = null;){
                String node;
                in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((node = br.readLine()) != null) {
                    nodeList.add(node);
                }
            }
        }
        return nodeList;
    }

    public static String generateUniqueId() {
        return new UID().toString();
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().equals("linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static String getPID() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        return pid.split("@")[0];
    }

    public static boolean isNumber(String number) {
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String resolvePlaceholders(String contents) {
        return Utils.resolvePlaceholders(contents, System.getProperties());
    }

    public static String resolvePlaceholders(String contents, Properties props) {
        Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = placeHolderPattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String placeholderValue = props.getProperty(key);
            if (placeholderValue == null && (placeholderValue = System.getProperty(key)) == null) {
                throw new IllegalArgumentException("Missing value for placeholder: " + key);
            }
            matcher.appendReplacement(sb, placeholderValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String resolvePlaceholderIfExists(String value, Properties props) {
        Utils.findDuccHome();
        if (value != null && value.contains("${")) {
            PropertyPlaceholderHelper pph = new PropertyPlaceholderHelper("${", "}");
            value = pph.replacePlaceholders(value, props);
        }
        return value;
    }

    public static <A> A[] concatAllArrays(A[] first, A[] ... next) {
        int totalLength = first.length;
        for (A[] array : next) {
            totalLength += array.length;
        }
        A[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (A[] array : next) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static int getPID(Process process) {
        int pid = -1;
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(process);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return pid;
    }

    private static boolean compare(String s1, String s2) {
        boolean retVal = false;
        if (s1 != null && s2 != null && s1.equals(s2)) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isMachineNameMatch(String m1, String m2) {
        boolean retVal = false;
        if (Utils.compare(m1, m2)) {
            retVal = true;
        } else {
            int ndx1 = m1.indexOf(".");
            int ndx2 = m2.indexOf(".");
            if (ndx1 <= 0 || ndx2 <= 0) {
                String n1 = m1;
                if (ndx1 > 0) {
                    n1 = m1.substring(0, ndx1);
                }
                String n2 = m2;
                if (ndx2 > 0) {
                    n2 = m2.substring(0, ndx2);
                }
                if (Utils.compare(n1, n2)) {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    public static String findDuccHome() {
        if (DUCC_HOME != null) {
            return DUCC_HOME;
        }
        DUCC_HOME = System.getProperty("DUCC_HOME");
        URL res = Utils.class.getProtectionDomain().getCodeSource().getLocation();
        String p = res.getPath();
        if (!p.endsWith(".jar")) {
            if (DUCC_HOME == null) {
                throw new IllegalArgumentException("DUCC_HOME system property missing and cannot infer it as not running from a jar");
            }
            return DUCC_HOME;
        }
        int ndx = p.lastIndexOf("/");
        ndx = p.lastIndexOf("/", ndx - 1);
        String jar_ducc_home = p.substring(0, ndx = p.lastIndexOf("/", ndx - 1));
        File props = new File(jar_ducc_home + "/resources/ducc.properties");
        if (!props.exists()) {
            if (DUCC_HOME == null) {
                throw new IllegalArgumentException("DUCC_HOME system property missing and cannot infer it as " + res + " is not part of a valid DUCC installation");
            }
            return DUCC_HOME;
        }
        if (DUCC_HOME == null) {
            DUCC_HOME = jar_ducc_home;
            System.setProperty("DUCC_HOME", DUCC_HOME);
        } else {
            try {
                DUCC_HOME = new File(DUCC_HOME).getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!jar_ducc_home.equals(DUCC_HOME)) {
                System.out.println("WARNING: Setting DUCC_HOME = " + DUCC_HOME + " but the CLI request is from " + jar_ducc_home);
            }
        }
        return DUCC_HOME;
    }

    public static void main(String[] args) {
        try {
            if (Utils.isThisNode("192.168.3.3", "192.168.3.3")) {
                System.out.println("Nodes equal");
            } else {
                System.out.println("Nodes NOT equal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

