/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.agent.metrics.swap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.uima.ducc.common.agent.metrics.swap.ProcessMemoryPageLoadUsage;

public class DuccProcessMemoryPageLoadUsage
implements ProcessMemoryPageLoadUsage {
    String pid;

    public DuccProcessMemoryPageLoadUsage(String pid) {
        this.pid = pid;
    }

    @Override
    public long getMajorFaults() throws Exception {
        return this.collectProcessMajorFaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collectProcessMajorFaults() throws Exception {
        String[] command = new String[]{"/bin/ps", "-o", "maj_flt", this.pid};
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream is = process.getInputStream();
        if (is != null) {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            int count = 0;
            String faults = null;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (count == 1) {
                        faults = line.trim();
                    }
                    ++count;
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
                process.waitFor();
                process.destroy();
            }
            if (faults != null) {
                return Long.parseLong(faults.trim());
            }
            return 0L;
        }
        return 0L;
    }
}

