/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.main;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.dataformat.xstream.XStreamDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.log4j.Level;
import org.apache.uima.ducc.common.admin.event.DuccAdminEvent;
import org.apache.uima.ducc.common.admin.event.RmAdminQLoad;
import org.apache.uima.ducc.common.admin.event.RmAdminQLoadReply;
import org.apache.uima.ducc.common.admin.event.RmAdminQOccupancy;
import org.apache.uima.ducc.common.admin.event.RmAdminQOccupancyReply;
import org.apache.uima.ducc.common.admin.event.RmAdminReconfigure;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.admin.event.RmAdminVaryOff;
import org.apache.uima.ducc.common.admin.event.RmAdminVaryOn;
import org.apache.uima.ducc.common.admin.event.RmAdminVaryReply;
import org.apache.uima.ducc.common.authentication.BrokerCredentials;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccRmAdmin
extends AbstractDuccComponent {
    public static final String FileSeparator = System.getProperty("file.separator");
    private String brokerUrl;
    private ProducerTemplate pt;
    private String targetEndpoint;
    String user;
    byte[] cypheredMessage;

    public DuccRmAdmin(CamelContext context, String epname) {
        super("DuccServiceReaper", context);
        try {
            this.loadProperties("ducc.deploy.configuration");
            this.brokerUrl = System.getProperty("ducc.broker.url");
            try {
                String brokerCredentialsFile = System.getProperty("ducc.broker.credentials.file");
                this.targetEndpoint = System.getProperty(epname);
                if (this.targetEndpoint == null) {
                    throw new IllegalArgumentException("Cannot find endpoint for RM admin.  Is 'ducc.rm.admin.endpoint' configured n ducc.properties?");
                }
                ActiveMQComponent duccAMQComponent = new ActiveMQComponent(context);
                duccAMQComponent.setBrokerURL(this.brokerUrl);
                if (brokerCredentialsFile != null && brokerCredentialsFile.length() > 0) {
                    String path = "";
                    try {
                        Utils.findDuccHome();
                        path = Utils.resolvePlaceholderIfExists(brokerCredentialsFile, System.getProperties());
                        BrokerCredentials.Credentials credentials = BrokerCredentials.get(path);
                        if (credentials.getUsername() != null && credentials.getPassword() != null) {
                            duccAMQComponent.setUserName(credentials.getUsername());
                            duccAMQComponent.setPassword(credentials.getPassword());
                        }
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("DuccRmAdmin Failed - File Not Found:" + path + " Broker Credentials File:" + brokerCredentialsFile);
                        System.exit(-1);
                    }
                }
                context.addComponent("activemq", (Component)duccAMQComponent);
                this.pt = context.createProducerTemplate();
            }
            catch (Throwable exx) {
                System.out.println("DuccRmAdmin Failed:" + exx);
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public DuccLogger getLogger() {
        DuccLogger ret = new DuccLogger("admin");
        ret.setLevel(Level.OFF);
        return ret;
    }

    private String marshallEvent(DuccAdminEvent duccEvent) throws Exception {
        XStreamDataFormat xStreamDataFormat = new XStreamDataFormat();
        XStream xStream = xStreamDataFormat.getXStream((ClassResolver)new DefaultClassResolver());
        return xStream.toXML((Object)duccEvent);
    }

    private RmAdminReply dispatchAndWaitForReply(DuccAdminEvent duccEvent) throws Exception {
        int i;
        int maxRetryCount = 20;
        Object reply = null;
        RuntimeExchangeException ree = null;
        for (i = 0; i < maxRetryCount; ++i) {
            try {
                reply = this.pt.sendBody(this.targetEndpoint, ExchangePattern.InOut, (Object)this.marshallEvent(duccEvent));
                ree = null;
                break;
            }
            catch (RuntimeExchangeException e) {
                String msg = e.getMessage();
                if (msg == null || !msg.startsWith("Failed to resolve replyTo destination on the exchange")) {
                    throw new DuccRuntimeException("Ducc JMS Dispatcher is unable to deliver a request.", (Exception)((Object)e));
                }
                ree = e;
                continue;
            }
        }
        if (i == maxRetryCount) {
            throw new DuccRuntimeException("ActiveMQ failed to create temp reply queue. After 20 attempts to deliver request to the OR, Ducc JMS Dispatcher is giving up.", (Exception)((Object)ree));
        }
        if (reply instanceof RmAdminReply) {
            return (RmAdminReply)reply;
        }
        throw new DuccRuntimeException("Received unexpected object as response: " + reply.getClass().getName());
    }

    public RmAdminVaryReply varyoff(String[] args) throws Exception {
        String[] nodes = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            nodes[i - 1] = args[i];
        }
        RmAdminVaryOff vo = new RmAdminVaryOff(nodes, this.user, this.cypheredMessage);
        return (RmAdminVaryReply)this.dispatchAndWaitForReply(vo);
    }

    public RmAdminVaryReply varyon(String[] args) throws Exception {
        String[] nodes = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            nodes[i - 1] = args[i];
        }
        RmAdminVaryOn vo = new RmAdminVaryOn(nodes, this.user, this.cypheredMessage);
        return (RmAdminVaryReply)this.dispatchAndWaitForReply(vo);
    }

    public RmAdminQLoadReply qload() throws Exception {
        RmAdminQLoad ql = new RmAdminQLoad(this.user, this.cypheredMessage);
        return (RmAdminQLoadReply)this.dispatchAndWaitForReply(ql);
    }

    public RmAdminQOccupancyReply qoccupancy() throws Exception {
        RmAdminQOccupancy qo = new RmAdminQOccupancy(this.user, this.cypheredMessage);
        return (RmAdminQOccupancyReply)this.dispatchAndWaitForReply(qo);
    }

    public RmAdminReply reconfigure() throws Exception {
        RmAdminReconfigure np = new RmAdminReconfigure(this.user, this.cypheredMessage);
        return this.dispatchAndWaitForReply(np);
    }

    public int run(String[] args) throws Exception {
        this.user = System.getProperty("user.name");
        Crypto crypto = new Crypto(this.user, System.getProperty("user.home"));
        this.cypheredMessage = crypto.encrypt(this.user);
        if (args[0].equals("--varyoff")) {
            if (args.length < 2) {
                DuccRmAdmin.usage("Missing node list");
            }
            RmAdminVaryReply reply = this.varyoff(args);
            System.out.println(reply.getMessage());
            return reply.getRc() ? 0 : 1;
        }
        if (args[0].equals("--varyon")) {
            if (args.length < 2) {
                DuccRmAdmin.usage("Missing node list");
            }
            RmAdminVaryReply reply = this.varyon(args);
            System.out.println(reply.getMessage());
            return reply.getRc() ? 0 : 1;
        }
        if (args[0].equals("--qload")) {
            if (args.length != 1) {
                DuccRmAdmin.usage("Qload takes no arguments.");
            }
            RmAdminQLoadReply reply = this.qload();
            System.out.println(reply.toString());
            return reply.getRc() ? 0 : 1;
        }
        if (args[0].equals("--qoccupancy")) {
            if (args.length != 1) {
                DuccRmAdmin.usage("Qoccupancy takes no arguments.");
            }
            RmAdminQOccupancyReply reply = this.qoccupancy();
            System.out.println(reply.toString());
            return reply.getRc() ? 0 : 1;
        }
        if (args[0].equals("--reconfigure")) {
            if (args.length != 1) {
                DuccRmAdmin.usage("Reconfigure takes no arguments.");
            }
            RmAdminReply reply = this.reconfigure();
            System.out.println(reply.getMessage());
            return reply.getRc() ? 0 : 1;
        }
        System.out.println("Unknown command: " + args[0]);
        return 1;
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("Usage:\n");
        System.out.println("DuccRmAdmin verb options");
        System.out.println("Where verbs are:");
        System.out.println("   --varyoff string-delimeted-nodes");
        System.out.println("   --varyon  string-delimeted-nodes");
        System.out.println("   --qload");
        System.out.println("   --qoccupancy");
        System.out.println("   --reconfigure");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int rc = 0;
        try {
            DuccRmAdmin admin = new DuccRmAdmin((CamelContext)new DefaultCamelContext(), "ducc.rm.admin.endpoint");
            rc = admin.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            rc = 1;
        }
        finally {
            System.exit(rc);
        }
    }
}

