/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.persistence.IPropertiesFileManager;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class PropertiesFileManager
implements IPropertiesFileManager {
    private static Messages messages = Messages.getInstance();
    private DuccLogger logger = null;
    private String basedir = null;
    private String propertiesFileName = null;
    private Properties properties = new Properties();
    private boolean loadOnGet = false;
    private boolean storeOnSet = true;

    public PropertiesFileManager(String componentId, String basedir, String propertiesFileName) {
        this.logger = DuccService.getDuccLogger(this.getClass().getName());
        this.basedir = basedir;
        this.propertiesFileName = propertiesFileName;
        this.init();
    }

    public PropertiesFileManager(String componentId, String basedir, String propertiesFileName, boolean loadOnGet, boolean storeOnSet) {
        this.logger = DuccService.getDuccLogger(this.getClass().getName());
        this.basedir = basedir;
        this.propertiesFileName = propertiesFileName;
        this.loadOnGet = loadOnGet;
        this.storeOnSet = storeOnSet;
        this.init();
    }

    private String getFullFileName() {
        return this.basedir + File.separator + this.propertiesFileName;
    }

    private boolean mkdirs(String directory) {
        boolean created = false;
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdirs();
            created = true;
        }
        return created;
    }

    private void init() {
        String methodName = "init";
        this.logger.trace(methodName, null, messages.fetch("enter"));
        this.logger.debug(methodName, null, messages.fetchLabel("logger") + this.logger);
        this.logger.debug(methodName, null, messages.fetchLabel("basedir") + this.basedir);
        this.logger.debug(methodName, null, messages.fetchLabel("propertiesFileName") + this.propertiesFileName);
        this.logger.debug(methodName, null, messages.fetchLabel("loadOnGet") + this.loadOnGet);
        this.logger.debug(methodName, null, messages.fetchLabel("storeOnSet") + this.storeOnSet);
        this.mkdirs(this.basedir);
        this.load();
        this.logger.info(methodName, null, this.getFullFileName());
        this.logger.trace(methodName, null, messages.fetch("exit"));
    }

    private void load() {
        String methodName = "load";
        this.logger.trace(methodName, null, messages.fetch("enter"));
        try {
            FileInputStream fis = new FileInputStream(this.getFullFileName());
            this.properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            this.logger.warn(methodName, null, messages.fetchLabel("load_failed") + this.getFullFileName());
        }
        this.logger.trace(methodName, null, messages.fetch("exit"));
    }

    private void store() {
        String methodName = "store";
        this.logger.trace(methodName, null, messages.fetch("enter"));
        try {
            FileOutputStream fos = new FileOutputStream(this.getFullFileName());
            this.properties.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            this.logger.error(methodName, null, e, new Object[0]);
        }
        this.logger.trace(methodName, null, messages.fetch("exit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String defaultValue) {
        String methodName = "get";
        PropertiesFileManager propertiesFileManager = this;
        synchronized (propertiesFileManager) {
            this.logger.trace(methodName, null, messages.fetch("enter"));
            if (this.loadOnGet) {
                this.load();
            }
            String value = this.properties.getProperty(key, defaultValue);
            this.logger.debug(methodName, null, messages.fetchLabel("key") + key + " " + messages.fetchLabel("value") + value);
            this.logger.trace(methodName, null, messages.fetch("exit"));
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        String methodName = "set";
        PropertiesFileManager propertiesFileManager = this;
        synchronized (propertiesFileManager) {
            this.logger.trace(methodName, null, messages.fetch("enter"));
            this.properties.setProperty(key, value);
            this.logger.debug(methodName, null, messages.fetchLabel("key") + key + " " + messages.fetchLabel("value") + value);
            if (this.storeOnSet) {
                this.store();
            }
            this.logger.trace(methodName, null, messages.fetch("exit"));
        }
    }

    @Deprecated
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void remove(String key) {
        String methodName = "remove";
        PropertiesFileManager propertiesFileManager = this;
        synchronized (propertiesFileManager) {
            this.logger.trace(methodName, null, messages.fetch("enter"));
            this.properties.remove(key);
            this.logger.debug(methodName, null, messages.fetchLabel("key") + key);
            this.store();
            this.logger.trace(methodName, null, messages.fetch("exit"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int increment(String key) {
        String methodName = "increment";
        PropertiesFileManager propertiesFileManager = this;
        synchronized (propertiesFileManager) {
            this.logger.trace(methodName, null, messages.fetch("enter"));
            int retVal = Integer.valueOf(this.get(key, "-1"));
            this.logger.debug(methodName, null, messages.fetchLabel("key") + key + " " + messages.fetchLabel("value") + ++retVal);
            this.set(key, String.valueOf(retVal));
            this.logger.trace(methodName, null, messages.fetch("exit"));
            return retVal;
        }
    }
}

